/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.RotatorStr;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vator;

public class Rotator {
    public static final Animator DoRotator = new Animator(Rotator::DoRotator);

    public static void ReverseRotator(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return;
        }
        RotatorStr r = u.getRotator();
        if (u.Tics != 0) {
            u.Tics = 0;
            Rotator.SetRotatorActive(SpriteNum);
            return;
        }
        if (r.tgt == 0) {
            r.tgt = r.open_dest;
        } else if (r.tgt == r.open_dest) {
            r.tgt = 0;
        }
        r.vel = -r.vel;
    }

    public static void SetRotatorActive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        RotatorStr r = u.getRotator();
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags |= Gameutils.SPR_ACTIVE;
        u.Tics = 0;
        if (r.tgt == 0) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 0);
        } else {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 1);
        }
    }

    public static void SetRotatorInactive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 2, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags &= ~Gameutils.SPR_ACTIVE;
    }

    public static void DoRotatorOperate(PlayerStr pp, int sectnum) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec == null) {
            return;
        }
        short match = sec.getHitag();
        if (match > 0 && Rotator.TestRotatorMatchActive(match)) {
            Rotator.DoRotatorMatch(pp, match, true);
        }
    }

    public static void DoRotatorMatch(PlayerStr pp, int match, boolean manual) {
        int first_vator = -1;
        ListNode<Sprite> node = Main.boardService.getStatNode(71);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 143 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.getUser(i);
                if (Gameutils.TEST_BOOL4(fsp) && (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT || Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_AI_BOTS)) {
                    if (pp != null && Gameutils.TEST_BOOL11(fsp)) {
                        Text.PutStringInfo(pp, "This only opens in single play.");
                    }
                } else if (Gameutils.SP_TAG3(fsp) != 1 || !manual) {
                    if (first_vator == -1) {
                        first_vator = i;
                    }
                    short sectnum = fsp.getSectnum();
                    Sect_User su = Sector.getSectUser(sectnum);
                    if (pp != null && su != null && su.stag == 29 && su.number != 0) {
                        int key_num = su.number;
                        Text.PutStringInfo(pp, Text.KeyDoorMessage[key_num - 1]);
                        return;
                    }
                    if (fu != null && MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE)) {
                        Rotator.ReverseRotator(i);
                    } else {
                        Rotator.SetRotatorActive(i);
                    }
                }
            }
            node = nexti;
        }
    }

    public static boolean TestRotatorMatchActive(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(71);
        while (node != null) {
            USER fu;
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 143 && Gameutils.SP_TAG2(fsp) == match && (fu = Gameutils.getUser(i)) != null && !Gameutils.TEST_BOOL6(fsp) && (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE) || fu.Tics != 0)) {
                return false;
            }
            node = nexti;
        }
        return true;
    }

    private static void DoRotatorMove(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Sprite pivot = null;
        boolean kill = false;
        RotatorStr r = u.getRotator();
        if (r.pos < r.tgt) {
            r.pos += r.speed;
            r.speed += r.vel;
            if (r.pos > r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos > r.tgt) {
            r.pos -= r.speed;
            r.speed += r.vel;
            if (r.pos < r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos == r.tgt) {
            if (r.pos == r.open_dest) {
                r.tgt = 0;
                r.vel = -r.vel;
                Rotator.SetRotatorInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
                if (u.WaitTics != 0) {
                    u.Tics = u.WaitTics;
                }
            } else if (r.pos == 0) {
                r.tgt = r.open_dest;
                r.speed = r.orig_speed;
                r.vel = Pragmas.klabs(r.vel);
                Rotator.SetRotatorInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
            if (Gameutils.TEST_BOOL2(sp)) {
                kill = true;
            }
        }
        int closest = 99999;
        ListNode<Sprite> node = Main.boardService.getStatNode(72);
        while (node != null) {
            int dist;
            ListNode<Sprite> nexti = node.getNext();
            Sprite spr = node.get();
            if (spr.getLotag() == sp.getLotag() && (dist = Game.Distance(sp.getX(), sp.getY(), spr.getX(), spr.getY())) < closest) {
                closest = dist;
                pivot = spr;
            }
            node = nexti;
        }
        if (pivot == null) {
            return;
        }
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sp.getSectnum());
        if (sec != null) {
            int ndx = 0;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Point p = EngineUtils.rotatepoint(pivot.getX(), pivot.getY(), r.orig[ndx].x, r.orig[ndx].y, r.pos);
                Main.engine.dragpoint(wn.getIndex(), p.getX(), p.getY());
                ++ndx;
            }
        }
        if (kill) {
            Rotator.SetRotatorInactive(SpriteNum);
            Sprites.KillSprite(SpriteNum);
        }
    }

    public static void DoRotator(int SpriteNum) {
        Rotator.DoRotatorMove(SpriteNum);
    }
}

