/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import com.badlogic.gdx.Gdx;
import java.io.FileOutputStream;
import java.nio.file.Path;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Wang.Border;
import ru.m210projects.Wang.Cheats;
import ru.m210projects.Wang.Config;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Factory.DemoRecorder;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JPlayer;
import ru.m210projects.Wang.LoadSave;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;

public class GameScreen
extends GameAdapter {
    private final Main game;
    private int nonsharedtimer;
    private boolean NewGame = false;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        Player.domovethings(net);
    }

    @Override
    public void DrawWorld(float smooth) {
        this.game.pIntSkip2.saveinterpolations();
        this.game.pIntSkip4.saveinterpolations();
        this.game.pIntSkip2.dointerpolations(smooth);
        this.game.pIntSkip4.dointerpolations(smooth);
        Draw.drawscreen(Game.Player[Game.screenpeek], (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        Draw.drawhud(Game.Player[Game.screenpeek]);
        Renderer renderer = this.game.getRenderer();
        if (this.game.net.bOutOfSync) {
            this.game.getFont(1).drawTextScaled(renderer, 160, 20, Strhandler.toCharArray("Out of sync!"), 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, Strhandler.toCharArray("seed checksum error"), 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 1: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, Strhandler.toCharArray("player struct checksum error"), 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 2: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, Strhandler.toCharArray("player sprite checksum error"), 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 3: {
                    this.game.getFont(1).drawTextScaled(renderer, 160, 30, Strhandler.toCharArray("missile sprites checksum error"), 1.0f, 0, 12, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                }
            }
        }
        this.game.pIntSkip2.restoreinterpolations();
        this.game.pIntSkip4.restoreinterpolations();
        if (Game.Player[Game.screenpeek].FadeAmt != 0) {
            renderer.showScreenFade(Palette.WANG_SCREEN_FADE);
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    protected boolean gameKeyDownCommon(GameKey gameKey, boolean inGame) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        boolean shiftPressed = Gdx.input.isKeyPressed(59);
        boolean ctrlPressed = Gdx.input.isKeyPressed(129);
        if (shiftPressed || ctrlPressed) {
            return false;
        }
        WangMenuHandler menu = this.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            if (inGame) {
                menu.mOpen(menu.mMenus[1], -1);
            } else {
                menu.mOpen(menu.mMenus[0], -1);
            }
            return true;
        }
        if (Config.SwKeys.Show_Help.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
            return true;
        }
        if (Config.SwKeys.Show_Loadmenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1 || this.game.net.FakeMultiplayer) {
                return false;
            }
            menu.mOpen(menu.mMenus[7], -1);
            return true;
        }
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        if ((Draw.dimensionmode == 5 || Draw.dimensionmode == 6) && Config.SwKeys.Map_Follow_Mode.equals(gameKey)) {
            boolean bl = Draw.ScrollMode2D = !Draw.ScrollMode2D;
            if (Draw.ScrollMode2D) {
                Draw.Follow_posx = pp.oposx;
                Draw.Follow_posy = pp.oposy;
            }
            Text.PutStringInfoLine(pp, "ScrollMode " + (Draw.ScrollMode2D ? "ON" : "OFF"));
            return true;
        }
        if (Config.SwKeys.Show_Sounds.equals(gameKey)) {
            menu.mOpen(menu.mMenus[3], -1);
            return true;
        }
        if (Config.SwKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[5], -1);
            return true;
        }
        if (Config.SwKeys.Gamma.equals(gameKey)) {
            this.openGamma(menu);
            return true;
        }
        if (Config.SwKeys.Messages.equals(gameKey)) {
            Main.cfg.Messages = !Main.cfg.Messages;
            Text.PutStringInfoLine(pp, "Messages " + (Main.cfg.Messages ? "ON" : "OFF"));
            return true;
        }
        if (Config.SwKeys.Toggle_Crosshair.equals(gameKey)) {
            Main.cfg.Crosshair = !Main.cfg.Crosshair;
            Text.PutStringInfoLine(pp, "Crosshair " + (Main.cfg.Crosshair ? "ON" : "OFF"));
            return true;
        }
        if (Config.SwKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[9], -1);
            return true;
        }
        if (Config.SwKeys.Screenshot.equals(gameKey)) {
            this.makeScreenshot();
            return true;
        }
        if (Config.SwKeys.See_Coop_View.equals(gameKey)) {
            if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COOPERATIVE || Main.gNet.FakeMultiplayer) {
                if ((Game.screenpeek = Mmulti.connectpoint2[Game.screenpeek]) < 0) {
                    Game.screenpeek = Mmulti.connecthead;
                }
                Palette.ResetPalette(Game.Player[Game.screenpeek], 256);
                Palette.DoPlayerDivePalette(Game.Player[Game.screenpeek]);
                Palette.DoPlayerNightVisionPalette(Game.Player[Game.screenpeek]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (Draw.dimensionmode == 5 || Draw.dimensionmode == 6) {
            int j = Main.engine.getTotalClock() - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (processor.isGameKeyPressed(GameKeys.Enlarge_Screen)) {
                Draw.zoom += Pragmas.mulscale(j, Math.max(Draw.zoom, 256), 6);
            }
            if (processor.isGameKeyPressed(GameKeys.Shrink_Screen)) {
                Draw.zoom -= Pragmas.mulscale(j, Math.max(Draw.zoom, 256), 6);
            }
            if (Draw.zoom > 2048) {
                Draw.zoom = 2048;
            }
            if (Draw.zoom < 48) {
                Draw.zoom = 48;
            }
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        boolean shiftPressed = Gdx.input.isKeyPressed(59);
        boolean ctrlPressed = Gdx.input.isKeyPressed(129);
        if (this.gameKeyDownCommon(gameKey, true)) {
            return true;
        }
        PlayerStr pp = Game.Player[Mmulti.myconnectindex];
        WangMenuHandler menu = this.game.menu;
        if (Config.SwKeys.See_Chase_View.equals(gameKey)) {
            if (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60)) {
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                    pp.view_outside_dang = Gameutils.NORM_ANGLE(pp.view_outside_dang + 256);
                }
            } else if (MyTypes.TEST(pp.Flags, Gameutils.PF_VIEW_FROM_OUTSIDE)) {
                pp.Flags &= ~Gameutils.PF_VIEW_FROM_OUTSIDE;
            } else {
                pp.Flags |= Gameutils.PF_VIEW_FROM_OUTSIDE;
                pp.camera_dist = 0;
            }
        }
        if (shiftPressed || ctrlPressed) {
            return false;
        }
        if (Config.SwKeys.Show_Savemenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1 || this.game.net.FakeMultiplayer) {
                return false;
            }
            if (!MyTypes.TEST(pp.Flags, Gameutils.PF_DEAD)) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[8], -1);
            }
        }
        if (Config.SwKeys.Quicksave.equals(gameKey)) {
            LoadSave.quicksave();
        }
        if (Config.SwKeys.Quickload.equals(gameKey)) {
            LoadSave.quickload();
        }
        if (Draw.dimensionmode != 5 && Draw.dimensionmode != 6) {
            if (GameKeys.Enlarge_Screen.equals(gameKey)) {
                Border.SetBorder(pp, Main.cfg.BorderNum + 1);
            }
            if (GameKeys.Shrink_Screen.equals(gameKey)) {
                Border.SetBorder(pp, Main.cfg.BorderNum - 1);
            }
        }
        return false;
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sound.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(Entry map) {
        Draw.gNameShowTime = 500;
        Game.FinishAnim = 0;
        if (!Game.InitLevel(map, this.NewGame)) {
            return false;
        }
        Game.boardfilename = map;
        if (this != Main.gDemoScreen) {
            Main.gDemoScreen.demfile = null;
            Game.InitPlayerGameSettings();
        } else {
            Game.Player[Mmulti.myconnectindex].Flags = Main.gDemoScreen.demfile.Flags[Mmulti.myconnectindex];
            if (Main.gDemoScreen.demfile.nVersion != 1) {
                int i;
                Game.Player[Mmulti.myconnectindex].Armor = (short)Main.gDemoScreen.demfile.Armors[Mmulti.myconnectindex];
                Game.Player[Mmulti.myconnectindex].WpnFlags = (short)Main.gDemoScreen.demfile.WpnFlags[Mmulti.myconnectindex];
                Game.Player[Mmulti.myconnectindex].MaxHealth = (short)Main.gDemoScreen.demfile.MaxHealth[Mmulti.myconnectindex];
                for (i = 0; i < 14; ++i) {
                    Game.Player[Mmulti.myconnectindex].WpnAmmo[i] = (short)Main.gDemoScreen.demfile.WpnAmmo[Mmulti.myconnectindex][i];
                }
                Game.Player[Mmulti.myconnectindex].WpnRocketHeat = Main.gDemoScreen.demfile.WpnRocketHeats[Mmulti.myconnectindex];
                Game.Player[Mmulti.myconnectindex].WpnRocketNuke = Main.gDemoScreen.demfile.WpnRocketNukes[Mmulti.myconnectindex];
                for (i = 0; i < 7; ++i) {
                    Game.Player[Mmulti.myconnectindex].InventoryPercent[i] = (short)Main.gDemoScreen.demfile.InventoryPercent[Mmulti.myconnectindex][i];
                    Game.Player[Mmulti.myconnectindex].InventoryAmount[i] = (short)Main.gDemoScreen.demfile.InventoryAmount[Mmulti.myconnectindex][i];
                }
                Game.Player[Mmulti.myconnectindex].InventoryNum = Main.gDemoScreen.demfile.InventoryNums[Mmulti.myconnectindex];
                USER u = Gameutils.getUser(Game.Player[Mmulti.myconnectindex].PlayerSprite);
                if (u != null) {
                    u.Health = (short)Main.gDemoScreen.demfile.Health[Mmulti.myconnectindex];
                }
            }
        }
        Main.gNet.InitNetPlayerOptions();
        Main.gNet.ResetTimers();
        Main.gNet.InitPrediction(Game.Player[Mmulti.myconnectindex]);
        Main.gNet.WaitForAllPlayers(0);
        Main.engine.getTimer().reset();
        Game.InitTimingVars();
        Sound.StartMusic();
        Sound.StartAmbientSound();
        if (Game.DemoRecording) {
            int democount = 0;
            do {
                int a = democount / 1000 % 10;
                int b = democount / 100 % 10;
                int c = democount / 10 % 10;
                int d = democount % 10;
                String fn = "demo" + a + b + c + d + ".dmo";
                if (this.game.getCache().getGameDirectory().getEntry(fn).exists()) continue;
                try {
                    Path path = this.game.getCache().getGameDirectory().getPath().resolve(fn);
                    Game.rec = new DemoRecorder(new FileOutputStream(path.toFile()), path, 2, map.getName());
                    Console.out.println("Start recording to " + fn);
                }
                catch (Exception e) {
                    Console.out.println("Can't start demo record: " + e, OsdColor.RED);
                }
                break;
            } while (++democount < 9999);
        }
        if (!this.NewGame && this.game.nNetMode == BuildGame.NetMode.Single && this != Main.gDemoScreen) {
            LoadSave.gAutosaveRequest = true;
        }
        this.NewGame = false;
        System.err.println(map);
        return true;
    }

    public void newgame(boolean isMultiplayer, Object item, int nEpisode, int nLevel, int nDifficulty) {
        if (Game.rec != null) {
            Game.rec.close();
        }
        if (Mmulti.numplayers > 1 && this.game.pNet.bufferJitter >= 0 && Mmulti.myconnectindex == Mmulti.connecthead) {
            for (int i = 0; i <= this.game.pNet.bufferJitter; ++i) {
                this.game.pNet.GetNetworkInput();
            }
        }
        Game.boardfilename = Directory.DUMMY_ENTRY;
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(() -> {
            Cheats.InfinityAmmo = false;
            if (!isMultiplayer) {
                if (Mmulti.numplayers > 1) {
                    this.pNet.NetDisconnect(Mmulti.myconnectindex);
                }
                Mmulti.connecthead = 0;
                Mmulti.connectpoint2[0] = -1;
                WangNetwork.CommPlayers = 1;
                this.game.nNetMode = BuildGame.NetMode.Single;
                Main.gNet.FakeMultiplayer = false;
                if (this != Main.gDemoScreen) {
                    Main.gNet.KillLimit = 0;
                    Main.gNet.TimeLimit = 0;
                    Main.gNet.TimeLimitClock = 0;
                    Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
                    Main.gNet.TeamPlay = false;
                    Main.gNet.HurtTeammate = false;
                    Main.gNet.SpawnMarkers = false;
                    Main.gNet.NoRespawn = false;
                    Main.gNet.Nuke = true;
                }
            } else {
                if (Main.gNet.FakeMultiplayer) {
                    Mmulti.connecthead = 0;
                    WangNetwork.CommPlayers = Main.gNet.FakeMultiNumPlayers;
                    for (int i = 0; i < 16; ++i) {
                        Mmulti.connectpoint2[i] = (short)(i + 1);
                    }
                    Mmulti.connectpoint2[Main.gNet.FakeMultiNumPlayers - 1] = -1;
                } else {
                    WangNetwork.CommPlayers = Mmulti.numplayers;
                }
                if (this != Main.gDemoScreen) {
                    Main.gNet.HurtTeammate = Game.pNetInfo.nFriendlyFire == 1;
                    Main.gNet.SpawnMarkers = Game.pNetInfo.SpawnMarkers;
                    Main.gNet.TeamPlay = Game.pNetInfo.TeamPlay;
                    Main.gNet.Nuke = Game.pNetInfo.NetNuke;
                    Main.gNet.KillLimit = Game.pNetInfo.KillLimit * 10;
                    Main.gNet.TimeLimitClock = Main.gNet.TimeLimit = WangNetwork.TimeLimitTable[Game.pNetInfo.TimeLimit] * 60 * 120;
                    Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.values()[Game.pNetInfo.nGameType + 1];
                    if (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT_NO_RESPAWN) {
                        Main.gNet.MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT;
                        Main.gNet.NoRespawn = true;
                    } else {
                        Main.gNet.NoRespawn = false;
                    }
                }
                Game.GodMode = false;
                this.game.nNetMode = BuildGame.NetMode.Multiplayer;
            }
            Main.UserFlag flag = Main.UserFlag.None;
            if (item instanceof GameInfo && !item.equals(Game.defGame)) {
                flag = Main.UserFlag.Addon;
                GameInfo game = (GameInfo)item;
                ResourceHandler.checkEpisodeResources(game);
                Console.out.println("Start user episode: " + game.Title);
            } else {
                ResourceHandler.resetEpisodeResources();
            }
            if (item instanceof FileEntry) {
                flag = Main.UserFlag.UserMap;
                Game.boardfilename = (Entry)item;
                Game.Level = 0;
                Console.out.println("Start user map: " + Game.boardfilename.getName());
            }
            Main.mUserFlag = flag;
            if (this != Main.gDemoScreen && !isMultiplayer) {
                VOC3D skillvoice = null;
                switch (nDifficulty) {
                    case 0: {
                        skillvoice = Sound.PlaySound(248, null, 0);
                        break;
                    }
                    case 1: {
                        skillvoice = Sound.PlaySound(368, null, 0);
                        break;
                    }
                    case 2: {
                        skillvoice = Sound.PlaySound(349, null, 0);
                        break;
                    }
                    case 3: {
                        skillvoice = Sound.PlaySound(369, null, 0);
                    }
                }
                long startTime = System.currentTimeMillis();
                while (skillvoice != null && skillvoice.isPlaying() && skillvoice.isActive() && System.currentTimeMillis() - startTime <= 5000L) {
                }
            }
            if (nEpisode == 0) {
                Game.Level = nLevel + 1;
            } else if (nEpisode == 1) {
                Game.Level = 5 + nLevel;
            } else if (nEpisode == 2) {
                Game.Level = 23 + nLevel;
            }
            Game.Skill = nDifficulty;
            Game.FinishAnim = 0;
            if (flag == Main.UserFlag.Addon && this.game.nNetMode == BuildGame.NetMode.Single && this != Main.gDemoScreen && nLevel == 0) {
                Entry currentAnmEntry = this.game.getCache().getEntry("sw.anm", true);
                Entry defAnmEntry = this.game.getCache().getEntry("sw.anm", false);
                if (currentAnmEntry.exists() && defAnmEntry.exists() && currentAnmEntry.getChecksum() != defAnmEntry.getChecksum() && Main.gAnmScreen.init(0)) {
                    Sound.StopSound();
                    this.game.changeScreen(Main.gAnmScreen.setCallback(() -> {
                        this.NewGame = true;
                        if (!this.enterlevel(this.getTitle())) {
                            this.game.show();
                        }
                    }).escSkipping(true));
                    return;
                }
            }
            this.NewGame = true;
            if (!this.enterlevel(this.getTitle())) {
                this.game.show();
            }
        });
    }

    public boolean enterlevel(String title) {
        if (title == null) {
            return false;
        }
        if (this != Main.gDemoScreen) {
            Game.DemoRecording = Game.isDemoRecording;
        }
        Entry map = Main.mUserFlag == Main.UserFlag.UserMap ? Game.boardfilename : this.game.getCache().getEntry(Game.currentGame.getMapPath(Game.Level), true);
        this.loadboard(map, null).setTitle(title);
        return true;
    }

    public String getTitle() {
        String title = "";
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            return Game.currentGame.getMapTitle(Game.Level);
        }
        Entry file = Game.boardfilename;
        if (file.exists()) {
            title = file.getName();
        }
        return title;
    }

    protected void openGamma(WangMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    protected void makeScreenshot() {
        Entry map = Game.boardfilename;
        String name = Main.mUserFlag == Main.UserFlag.UserMap ? "scr-" + map.getName() + "-xxxx.png" : "scr-" + this.getTitle() + "-xxxx.png";
        Renderer renderer = this.game.getRenderer();
        String filename = renderer.screencapture(this.game.getUserDirectory(), name);
        if (filename != null) {
            JPlayer.adduserquote(filename + " saved");
        } else {
            JPlayer.adduserquote("Screenshot not saved. Access denied!");
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        boolean shiftPressed = Gdx.input.isKeyPressed(59);
        boolean ctrlPressed = Gdx.input.isKeyPressed(129);
        if (shiftPressed || ctrlPressed) {
            int fkey = -1;
            for (int i = 0; i < 10; ++i) {
                if (keycode != i + 131) continue;
                fkey = i;
                break;
            }
            if (fkey >= 0) {
                if (ctrlPressed && Sound.PlaySoundRTS(fkey) && WangNetwork.CommPlayers > 1) {
                    WangNetwork.PacketType.RTS_Sound.setData(fkey);
                    int l = WangNetwork.PacketType.RTS_Sound.Send(WangNetwork.netbuf);
                    this.game.net.sendtoall(WangNetwork.netbuf, l);
                }
                if (shiftPressed) {
                    String message = Main.cfg.WangBangMacro[fkey];
                    JPlayer.adduserquote(message);
                    if (WangNetwork.CommPlayers > 1) {
                        WangNetwork.PacketType.Message.setData(-1, message);
                        int l = WangNetwork.PacketType.Message.Send(WangNetwork.netbuf);
                        this.game.net.sendtoall(WangNetwork.netbuf, l);
                    }
                }
                return true;
            }
        }
        return super.keyDown(keycode);
    }
}

