/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.ScreenAdapters.MenuAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;

public class MenuScreen
extends MenuAdapter {
    private final WangMenuHandler menu;

    public MenuScreen(Main game) {
        super(game, game.menu.mMenus[0]);
        this.menu = game.menu;
    }

    public static void DrawBackground(Engine engine) {
        Renderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int scale = Pragmas.divscale(ydim, 240L, 16);
        int width = Pragmas.mulscale(engine.getTile(9220).getWidth(), scale, 16);
        if (width != 0) {
            int framesnum = xdim / width;
            int fy = Pragmas.scale(20L, ydim, 240L);
            int statusx1 = Gameutils.coordsConvertXScaled(160 - engine.getTile(2324).getWidth() / 2, ConvertType.Normal);
            int statusx2 = Gameutils.coordsConvertXScaled(160 + engine.getTile(2324).getWidth() / 2, ConvertType.Normal);
            int x = 0;
            for (int i = 0; i <= framesnum; ++i) {
                if (x - width <= statusx1 || x + width >= statusx2) {
                    renderer.rotatesprite(x << 16, fy << 16, scale, 0, 9220, 0, 0, 280);
                }
                x += width;
            }
        }
        renderer.rotatesprite(xdim << 15, ydim << 15, scale, 0, 2324, 0, 0, 8);
    }

    @Override
    public void show() {
        byte[] palette = this.engine.getPaletteManager().getBasePalette();
        this.engine.setbrightness(Main.cfg.getPaletteGamma(), palette);
        if (!this.menu.gShowMenu) {
            this.menu.mOpen(this.menu.mMenus[0], -1);
        }
        Sound.CDAudio_Play(2, true);
        Sound.COVER_SetReverb(0);
    }

    @Override
    public void process(float delta) {
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            Text.DrawFragBar();
        }
        if (!this.game.gPaused) {
            this.game.pNet.GetPackets();
        }
    }

    @Override
    public void draw(float delta) {
        this.game.getRenderer().clearview(117);
        MenuScreen.DrawBackground(this.engine);
    }
}

