/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.CopySect;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Light;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.MiscActr;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Quake;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Rotator;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Slidor;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Spike;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.NEAR_TAG_INFO;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.SINE_WALL;
import ru.m210projects.Wang.Type.SINE_WAVE_FLOOR;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Spring_Board;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.Vector3i;
import ru.m210projects.Wang.Vator;
import ru.m210projects.Wang.WallMove;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Star;

public class Sector {
    public static final int NTAG_SEARCH_LO_HI = 3;
    public static final int MAX_SINE_WAVE = 6;
    public static final int MAX_SINE_WALL = 10;
    public static final int MAX_SINE_WALL_POINTS = 64;
    public static final int SO_SCALE_NONE = 0;
    public static final int SO_SCALE_HOLD = 1;
    public static final int SO_SCALE_DEST = 2;
    public static final int SO_SCALE_RANDOM = 3;
    public static final int SO_SCALE_CYCLE = 4;
    public static final int SO_SCALE_RANDOM_POINT = 5;
    public static final int SCALE_POINT_SPEED = 4 + Gameutils.RANDOM_RANGE(8);
    public static final int SWITCH_LEVER = 581;
    public static final int SWITCH_FUSE = 558;
    public static final int SWITCH_FLIP = 561;
    public static final int SWITCH_RED_CHAIN = 563;
    public static final int SWITCH_GREEN_CHAIN = 565;
    public static final int SWITCH_TOUCH = 567;
    public static final int SWITCH_DRAGON = 569;
    public static final int SWITCH_LIGHT = 551;
    public static final int SWITCH_1 = 575;
    public static final int SWITCH_3 = 579;
    public static final int SWITCH_SHOOTABLE_1 = 577;
    public static final int SWITCH_4 = 571;
    public static final int SWITCH_5 = 573;
    public static final int SWITCH_6 = 583;
    public static final int EXIT_SWITCH = 2470;
    public static final int SWITCH_SKULL = 553;
    public static final int SINE_FLOOR = 1;
    public static final int SINE_CEILING = 2;
    public static final int SINE_SLOPED = MyTypes.BIT(3);
    public static final int PLAYER_SOUNDEVENT_TAG = 900;
    private static final short[] StatList = new short[]{0, 70, 82, 57, 10, 83, 42, 68, 60};
    public static int LevelSecrets;
    public static PlayerStr GlobPlayerStr;
    private static final Sect_User[] SectUser;
    public static final Anim[] pAnim;
    public static int AnimCnt;
    public static final Animator DoSpawnSpot;
    public static final SINE_WAVE_FLOOR[][] SineWaveFloor;
    public static final SINE_WALL[][] SineWall;
    public static final Spring_Board[] SpringBoard;
    public static int x_min_bound;
    public static int y_min_bound;
    public static int x_max_bound;
    public static int y_max_bound;
    private static final Vector3i midPoint;
    private static final int[] snd;
    private static int nti_cnt;
    private static final NEAR_TAG_INFO[] nti;
    private static final int[] z;

    public static void InitSectorStructs() {
        int j;
        int i;
        for (i = 0; i < 25; ++i) {
            Sprites.SectorObject[i] = new Sector_Object();
        }
        for (i = 0; i < 20; ++i) {
            Sector.SpringBoard[i] = new Spring_Board();
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 64; ++j) {
                Sector.SineWall[i][j] = new SINE_WALL();
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 21; ++j) {
                Sector.SineWaveFloor[i][j] = new SINE_WAVE_FLOOR();
            }
        }
        for (i = 0; i < 16; ++i) {
            Sector.nti[i] = new NEAR_TAG_INFO();
        }
    }

    public static void SetSectorWallBits(ru.m210projects.Build.Types.Sector sec, int bit_mask, boolean set_sectwall, boolean set_nextwall) {
        Wall w;
        short wall_num;
        Wall[] walls = Main.boardService.getBoard().getWalls();
        short start_wall = wall_num = sec.getWallptr();
        do {
            w = walls[wall_num];
            if (set_sectwall) {
                w.setExtra(w.getExtra() | bit_mask);
            }
            if (!set_nextwall || w.getNextwall() < 0) continue;
            Wall nw = walls[w.getNextwall()];
            nw.setExtra(nw.getExtra() | bit_mask);
        } while ((wall_num = w.getPoint2()) != start_wall);
    }

    public static void WallSetupDontMove() {
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (ListNode<Sprite> n = Main.boardService.getStatNode(85); n != null; n = n.getNext()) {
            Sprite spu = n.get();
            for (ListNode<Sprite> node = Main.boardService.getStatNode(86); node != null; node = node.getNext()) {
                Sprite spl = node.get();
                if (spu.getLotag() != spl.getLotag()) continue;
                for (Wall wal : walls) {
                    if (wal.getX() >= spl.getX() || wal.getX() <= spu.getX() || wal.getY() >= spl.getY() || wal.getY() <= spu.getY()) continue;
                    wal.setExtra(wal.getExtra() | Gameutils.WALLFX_DONT_MOVE);
                }
            }
        }
    }

    public static void WallSetup() {
        int NextSineWall = 0;
        Sector.WallSetupDontMove();
        for (int a = 0; a < 10; ++a) {
            for (int b = 0; b < 64; ++b) {
                SineWall[a][b].reset();
            }
        }
        x_min_bound = 999999;
        y_min_bound = 999999;
        x_max_bound = -999999;
        y_max_bound = -999999;
        Wall[] walls = Main.boardService.getBoard().getWalls();
        for (int i = 0; i < walls.length; ++i) {
            Wall wp = walls[i];
            if (wp.getPicnum() == 341) {
                wp.setPicnum(2356);
            }
            if (wp.getPicnum() == 342) {
                wp.setPicnum(2357);
            }
            x_min_bound = Math.min(wp.getX(), x_min_bound);
            y_min_bound = Math.min(wp.getY(), y_min_bound);
            x_max_bound = Math.max(wp.getX(), x_max_bound);
            y_max_bound = Math.max(wp.getY(), y_max_bound);
            switch (wp.getLotag()) {
                case 500: {
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_LOOP_DONT_SPIN);
                    Wall nw = walls[wp.getNextwall()];
                    nw.setExtra(nw.getExtra() | Gameutils.WALLFX_LOOP_DONT_SPIN);
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 500) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_LOOP_DONT_SPIN);
                        if (w.getNextwall() != -1) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_LOOP_DONT_SPIN);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    break;
                }
                case 507: {
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_DONT_SCALE);
                    Wall nw = walls[wp.getNextwall()];
                    nw.setExtra(nw.getExtra() | Gameutils.WALLFX_DONT_SCALE);
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 507) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_DONT_SCALE);
                        if (w.getNextwall() >= 0) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_DONT_SCALE);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    wp.setLotag(0);
                    break;
                }
                case 508: {
                    Wall nw = walls[wp.getNextwall()];
                    wp.setExtra(wp.getExtra() | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                    nw.setExtra(nw.getExtra() | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 508) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                        if (w.getNextwall() >= 0) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | (Gameutils.WALLFX_LOOP_OUTER | Gameutils.WALLFX_LOOP_OUTER_SECONDARY));
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    break;
                }
                case 504: {
                    Wall nw = walls[wp.getNextwall()];
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_LOOP_OUTER);
                    if (wp.getNextwall() != -1) {
                        nw.setExtra(nw.getExtra() | Gameutils.WALLFX_LOOP_OUTER);
                    }
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 504) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_LOOP_OUTER);
                        if (w.getNextwall() != -1) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_LOOP_OUTER);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    wp.setLotag(0);
                    break;
                }
                case 505: {
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_DONT_MOVE);
                    break;
                }
                case 502: {
                    Wall nw = walls[wp.getNextwall()];
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_LOOP_SPIN_2X);
                    nw.setExtra(nw.getExtra() | Gameutils.WALLFX_LOOP_SPIN_2X);
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 502) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_LOOP_SPIN_2X);
                        if (w.getNextwall() != -1) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_LOOP_SPIN_2X);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    break;
                }
                case 503: {
                    Wall nw = walls[wp.getNextwall()];
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_LOOP_SPIN_4X);
                    nw.setExtra(nw.getExtra() | Gameutils.WALLFX_LOOP_SPIN_4X);
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 503) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_LOOP_SPIN_4X);
                        if (w.getNextwall() != -1) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_LOOP_SPIN_4X);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    break;
                }
                case 501: {
                    Wall nw = walls[wp.getNextwall()];
                    wp.setExtra(wp.getExtra() | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                    nw.setExtra(nw.getExtra() | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                    short start_wall = wp.getPoint2();
                    int wall_num = start_wall;
                    while (walls[wall_num].getLotag() != 501) {
                        Wall w = walls[wall_num];
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                        if (w.getNextwall() != -1) {
                            Wall w2 = walls[w.getNextwall()];
                            w2.setExtra(w2.getExtra() | Gameutils.WALLFX_LOOP_REVERSE_SPIN);
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    break;
                }
                case 300: 
                case 301: {
                    Wall w;
                    int num_points;
                    int range = 250;
                    int speed = 3;
                    int peak = 0;
                    int tag_end = wp.getLotag() + 2;
                    int type = wp.getLotag() - 300;
                    int wall_num = i;
                    for (num_points = 0; num_points < 64 && walls[wall_num].getLotag() != tag_end; ++num_points) {
                        w = walls[wall_num];
                        if (num_points == 0) {
                            if (w.getHitag() != 0) {
                                range = w.getHitag();
                            }
                        } else if (num_points == 1) {
                            if (w.getHitag() != 0) {
                                speed = w.getHitag();
                            }
                        } else if (num_points == 2 && w.getHitag() != 0) {
                            peak = w.getHitag();
                        }
                        wall_num = walls[wall_num].getPoint2();
                    }
                    if (peak != 0) {
                        num_points = peak;
                    }
                    wall_num = i;
                    for (int cnt = 0; cnt < 64 && walls[wall_num].getLotag() != tag_end; ++cnt) {
                        SINE_WALL sw = SineWall[NextSineWall][cnt];
                        w = walls[wall_num];
                        sw.type = type;
                        sw.wall = wall_num;
                        sw.speed_shift = speed;
                        sw.range = range;
                        w.setExtra(w.getExtra() | Gameutils.WALLFX_DONT_STICK);
                        sw.orig_xy = sw.type == 0 ? w.getY() - (sw.range >> 2) : w.getX() - (sw.range >> 2);
                        sw.sintable_ndx = cnt * (2048 / num_points);
                        wall_num = walls[wall_num].getPoint2();
                    }
                    ++NextSineWall;
                }
            }
            Break.SetupWallForBreak(wp);
        }
    }

    public static void SectorLiquidSet(int i) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(i);
        if (sec == null) {
            return;
        }
        if (sec.getFloorpicnum() >= 300 && sec.getFloorpicnum() <= 307) {
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_LIQUID_WATER);
        } else if (sec.getFloorpicnum() >= 320 && sec.getFloorpicnum() <= 343) {
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_LIQUID_WATER);
        } else if (sec.getFloorpicnum() >= 780 && sec.getFloorpicnum() <= 794) {
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_LIQUID_WATER);
        } else if (sec.getFloorpicnum() >= 890 && sec.getFloorpicnum() <= 897) {
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_LIQUID_WATER);
        } else if (sec.getFloorpicnum() >= 175 && sec.getFloorpicnum() <= 182) {
            Sect_User sectu = Sprites.SetupSectUser(i);
            sec.setExtra(sec.getExtra() | Gameutils.SECTFX_LIQUID_LAVA);
            if (sectu.damage == 0) {
                sectu.damage = 40;
            }
        }
    }

    public static boolean SectorSetup() {
        int a;
        int NextSineWave = 0;
        Sector.WallSetup();
        for (int ndx = 0; ndx < 25; ++ndx) {
            Sprites.SectorObject[ndx].reset();
            Sprites.SectorObject[ndx].xmid = Integer.MAX_VALUE;
        }
        for (a = 0; a < 6; ++a) {
            for (int b = 0; b < 21; ++b) {
                SineWaveFloor[a][b].reset();
            }
        }
        for (a = 0; a < 20; ++a) {
            SpringBoard[a].reset();
        }
        LevelSecrets = 0;
        ru.m210projects.Build.Types.Sector[] sectors = Main.boardService.getBoard().getSectors();
        block14: for (int i = 0; i < sectors.length; ++i) {
            ru.m210projects.Build.Types.Sector sec = sectors[i];
            short tag = sec.getLotag();
            if (Game.Level == 14 && Game.swGetAddon() == 2 && i == 750 && tag == 216) {
                sec.setLotag(116);
            }
            if (MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_SINK)) {
                Sector.SectorLiquidSet(i);
            }
            if (MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_PLAX) && sec.getFloorpicnum() != 341) {
                sec.setExtra(sec.getExtra() | Gameutils.SECTFX_Z_ADJUST);
            }
            if (MyTypes.TEST(sec.getCeilingstat(), Gameutils.CEILING_STAT_PLAX) && sec.getCeilingpicnum() != 341) {
                sec.setExtra(sec.getExtra() | Gameutils.SECTFX_Z_ADJUST);
            }
            if (tag >= 501 && tag < 601 && !Track.SetupSectorObject(i, tag)) {
                return false;
            }
            switch (tag) {
                case 217: {
                    ++LevelSecrets;
                    continue block14;
                }
                case 115: {
                    Sector.SetSectorWallBits(sec, Gameutils.WALLFX_DONT_STICK, true, true);
                    continue block14;
                }
                case 400: 
                case 420: 
                case 440: {
                    int cnt;
                    ru.m210projects.Build.Types.Sector ns;
                    int range;
                    int near_sect = i;
                    int base_sect = i;
                    int swf_ndx = 0;
                    short range_diff = 0;
                    int wave_diff = 0;
                    short peak_dist = 0;
                    int speed_shift = 3;
                    int num = (tag - 400) / 20;
                    SINE_WAVE_FLOOR swf = SineWaveFloor[NextSineWave][swf_ndx];
                    swf.flags = 0;
                    switch (num) {
                        case 0: {
                            swf.flags |= 1;
                            if (!MyTypes.TEST(sectors[base_sect].getFloorstat(), Gameutils.FLOOR_STAT_SLOPE)) break;
                            swf.flags |= SINE_SLOPED;
                            break;
                        }
                        case 1: {
                            swf.flags |= 2;
                            break;
                        }
                        case 2: {
                            swf.flags |= 3;
                        }
                    }
                    swf.sector = near_sect;
                    ru.m210projects.Build.Types.Sector s1 = sectors[swf.sector];
                    swf.range = range = Gameutils.Z(s1.getHitag());
                    swf.floor_origz = s1.getFloorz() - (range >> 2);
                    swf.ceiling_origz = s1.getCeilingz() - (range >> 2);
                    swf_ndx = 1;
                    int sector_cnt = 1;
                    while ((ns = Main.boardService.getSector(near_sect = Sector.FindNextSectorByTag(sectors[base_sect], tag + swf_ndx))) != null) {
                        swf = SineWaveFloor[NextSineWave][swf_ndx];
                        if (swf_ndx == 1 && ns.getHitag() != 0) {
                            range_diff = ns.getHitag();
                        } else if (swf_ndx == 2 && ns.getHitag() != 0) {
                            speed_shift = ns.getHitag();
                        } else if (swf_ndx == 3 && ns.getHitag() != 0) {
                            peak_dist = ns.getHitag();
                        }
                        swf.sector = near_sect;
                        swf.floor_origz = ns.getFloorz() - (range >> 2);
                        swf.ceiling_origz = ns.getCeilingz() - (range >> 2);
                        swf.range = range -= range_diff;
                        base_sect = swf.sector;
                        ++sector_cnt;
                        ++swf_ndx;
                    }
                    if (sector_cnt > 8 && sectors[base_sect].getHitag() != 0) {
                        wave_diff = sectors[base_sect].getHitag();
                    }
                    for (cnt = 0; swf.sector >= 0 && cnt < SineWaveFloor[NextSineWave].length; ++cnt) {
                        swf = SineWaveFloor[NextSineWave][cnt];
                        swf.sintable_ndx = peak_dist != 0 ? cnt * (2048 / peak_dist) : cnt * (2048 / swf_ndx);
                        swf.speed_shift = speed_shift;
                    }
                    if (wave_diff != 0) {
                        for (cnt = sector_cnt - 1; cnt >= 0; --cnt) {
                            ru.m210projects.Build.Types.Sector s;
                            if (cnt > 8) continue;
                            swf = SineWaveFloor[NextSineWave][cnt];
                            swf.range -= wave_diff;
                            wave_diff += wave_diff;
                            if (swf.range < Gameutils.Z(4)) {
                                swf.range = Gameutils.Z(4);
                            }
                            if ((s = Main.boardService.getSector(swf.sector)) == null) continue;
                            swf.floor_origz = s.getFloorz() - (swf.range >> 2);
                            swf.ceiling_origz = s.getCeilingz() - (swf.range >> 2);
                        }
                    }
                    ++NextSineWave;
                    continue block14;
                }
            }
        }
        return true;
    }

    public static Vector3i SectorMidPoint(int sectnum) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sectnum);
        if (sec != null) {
            short startwall = sec.getWallptr();
            int endwall = startwall + sec.getWallnum() - 1;
            int xsum = 0;
            int ysum = 0;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wall = wn.get();
                xsum += wall.getX();
                ysum += wall.getY();
            }
            Sector.midPoint.x = xsum / (endwall - startwall + 1);
            Sector.midPoint.y = ysum / (endwall - startwall + 1);
            Sector.midPoint.z = MyTypes.DIV2(sec.getFloorz() + sec.getCeilingz());
        }
        return midPoint;
    }

    public static void DoSpringBoard(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
        if (sec != null) {
            pp.jump_speed = -sec.getHitag();
            Player.DoPlayerBeginForceJump(pp);
        }
    }

    public static void DoSpringBoardDown() {
        for (Spring_Board sbp : SpringBoard) {
            ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(sbp.Sector);
            if (sec == null || (sbp.TimeOut = (short)(sbp.TimeOut - 3)) > 0) continue;
            int nextsec = Main.engine.nextsectorneighborz(sbp.Sector, sec.getFloorz(), 1, 1);
            ru.m210projects.Build.Types.Sector nsec = Main.boardService.getSector(nextsec);
            if (nsec != null) {
                int destz = nsec.getFloorz();
                Sector.AnimSet(sbp.Sector, destz, 256, Anim.AnimType.FloorZ);
                sec.setLotag(240);
            }
            sbp.Sector = (short)-1;
        }
    }

    public static int FindNextSectorByTag(ru.m210projects.Build.Types.Sector sec, int tag) {
        for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
            Wall wall = wn.get();
            short next_sectnum = wall.getNextsector();
            ru.m210projects.Build.Types.Sector nsec = Main.boardService.getSector(next_sectnum);
            if (nsec == null || nsec.getLotag() != tag) continue;
            return next_sectnum;
        }
        return -1;
    }

    public static void DoSpawnActorTrigger(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(56);
        while (node != null) {
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == match && Sprites.ActorSpawn(node.getIndex())) {
                Player.DoSpawnTeleporterEffectPlace(sp);
                Sound.PlaySound(484, sp, 0);
            }
            node = nexti;
        }
    }

    public static boolean OperateSector(int sectnum, boolean player_is_operating) {
        PlayerStr pp = GlobPlayerStr;
        if (!player_is_operating) {
            Sect_User su = Sector.getSectUser(sectnum);
            if (su != null && su.stag == 29) {
                return false;
            }
            ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
            while (node != null) {
                ListNode<Sprite> nexti = node.getNext();
                Sprite fsp = node.get();
                Sect_User su1 = Sector.getSectUser(fsp.getSectnum());
                if (su1 != null && su1.stag == 29) {
                    return false;
                }
                if (fsp.getStatnum() == 70 && Gameutils.SP_TAG1(fsp) == 92 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                if (fsp.getStatnum() == 71 && Gameutils.SP_TAG1(fsp) == 143 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                if (fsp.getStatnum() == 73 && Gameutils.SP_TAG1(fsp) == 145 && Gameutils.TEST_BOOL7(fsp)) {
                    return false;
                }
                node = nexti;
            }
        }
        switch (Gameutils.LOW_TAG(sectnum)) {
            case 206: {
                Vator.DoVatorOperate(pp, sectnum);
                return true;
            }
            case 218: {
                Rotator.DoRotatorOperate(pp, sectnum);
                return true;
            }
            case 220: {
                Slidor.DoSlidorOperate(pp, sectnum);
                return true;
            }
        }
        return false;
    }

    public static int AnimateSwitch(Sprite sp, int tgt_value) {
        switch (sp.getPicnum()) {
            case 551: 
            case 553: 
            case 561: 
            case 563: 
            case 565: 
            case 567: 
            case 569: 
            case 571: 
            case 573: 
            case 575: 
            case 577: 
            case 579: 
            case 581: 
            case 583: 
            case 2470: {
                if (tgt_value == 999) {
                    return 0;
                }
                sp.setPicnum(sp.getPicnum() + 1);
                if (tgt_value == 0) {
                    Sector.AnimateSwitch(sp, tgt_value);
                    return 0;
                }
                return 1;
            }
            case 552: 
            case 554: 
            case 562: 
            case 564: 
            case 566: 
            case 568: 
            case 570: 
            case 572: 
            case 574: 
            case 576: 
            case 578: 
            case 580: 
            case 582: 
            case 584: 
            case 2471: {
                if (tgt_value == 999) {
                    return 1;
                }
                sp.setPicnum(sp.getPicnum() - 1);
                if (tgt_value == 1) {
                    Sector.AnimateSwitch(sp, tgt_value);
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public static void SectorExp(int SpriteNum, int sectnum, int orig_ang, int zh) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_WALL | Gameutils.CSTAT_SPRITE_FLOOR));
        Vector3i p = Sector.SectorMidPoint(sectnum);
        int x = p.x;
        int y = p.y;
        int z = p.z;
        sp.setAng(orig_ang);
        sp.setX(x);
        sp.setY(y);
        sp.setZ(z);
        sp.setAng(sp.getAng() + Gameutils.RANDOM_P2(256) - 128);
        sp.setX(sp.getX() + Gameutils.RANDOM_P2(1024) - 512);
        sp.setY(sp.getY() + Gameutils.RANDOM_P2(1024) - 512);
        sp.setZ(zh);
        Main.engine.changespritesect(SpriteNum, sectnum);
        Main.engine.getzsofslope(sp.getSectnum(), sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null) {
            u.hiz = Rooms.cz.get();
            u.loz = Rooms.fz.get();
        }
        int explosion = Weapon.SpawnSectorExp(SpriteNum);
        WangSprite exp = Main.boardService.getSprite(explosion);
        USER eu = Gameutils.getUser(explosion);
        if (exp == null || eu == null) {
            return;
        }
        exp.setXrepeat(exp.getXrepeat() + (Gameutils.RANDOM_P2(8192) >> 8) - 16);
        exp.setYrepeat(exp.getYrepeat() + (Gameutils.RANDOM_P2(8192) >> 8) - 16);
        eu.xchange = Gameutils.MOVEx(92, exp.getAng());
        eu.ychange = Gameutils.MOVEy(92, exp.getAng());
    }

    public static void DoExplodeSector(int match) {
        int orig_ang = 0;
        ListNode<Sprite> node = Main.boardService.getStatNode(75);
        while (node != null) {
            int cf = node.getIndex();
            ListNode<Sprite> nextcf = node.getNext();
            Sprite esp = node.get();
            if (match == esp.getLotag()) {
                ru.m210projects.Build.Types.Sector sectp;
                if (Gameutils.getUser(cf) == null) {
                    Sprites.SpawnUser(cf, 0, null);
                }
                if ((sectp = Main.boardService.getSector(esp.getSectnum())) != null) {
                    sectp.setCeilingz(sectp.getCeilingz() - Gameutils.Z(Gameutils.SP_TAG4(esp)));
                    if (Gameutils.SP_TAG5(esp) != 0) {
                        sectp.setFloorheinum(Gameutils.SP_TAG5(esp));
                        sectp.setFloorstat(sectp.getFloorstat() | Gameutils.FLOOR_STAT_SLOPE);
                    }
                    if (Gameutils.SP_TAG6(esp) != 0) {
                        sectp.setCeilingheinum(Gameutils.SP_TAG6(esp));
                        sectp.setCeilingstat(sectp.getCeilingstat() | Gameutils.CEILING_STAT_SLOPE);
                    }
                    for (int zh = sectp.getCeilingz(); zh < sectp.getFloorz(); zh += Gameutils.Z(60)) {
                        Sector.SectorExp(cf, esp.getSectnum(), orig_ang, zh + Gameutils.Z(Gameutils.RANDOM_P2(64)) - Gameutils.Z(32));
                    }
                    Sprites.KillSprite(cf);
                }
            }
            node = nextcf;
        }
    }

    public static void DoSpawnSpot(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u != null && (u.WaitTics -= 3) < 0) {
            Sprites.change_sprite_stat(SpriteNum, 67);
            Shrap.SpawnShrap(SpriteNum, -1);
            if (u.LastDamage == 1) {
                Sprites.KillSprite(SpriteNum);
            }
        }
    }

    public static void DoSpawnSpotsForKill(int match) {
        if (match < 0) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(67);
        while (node != null) {
            USER u;
            int sn = node.getIndex();
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == 69 && sp.getLotag() == match && (u = Gameutils.getUser(sn)) != null) {
                Sprites.change_sprite_stat(sn, 41);
                u.ActorActionFunc = DoSpawnSpot;
                u.WaitTics = Gameutils.SP_TAG5(sp) * 15;
                Main.engine.setspritez(sn, sp.getX(), sp.getY(), sp.getZ());
                u.LastDamage = 1;
            }
            node = next_sn;
        }
    }

    public static void DoSpawnSpotsForDamage(int match) {
        if (match < 0) {
            return;
        }
        ListNode<Sprite> node = Main.boardService.getStatNode(67);
        while (node != null) {
            USER u;
            int sn = node.getIndex();
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == 69 && sp.getLotag() == match && (u = Gameutils.getUser(sn)) != null) {
                Sprites.change_sprite_stat(sn, 41);
                u.ActorActionFunc = DoSpawnSpot;
                u.WaitTics = Gameutils.SP_TAG7(sp) * 15;
                u.LastDamage = 0;
            }
            node = next_sn;
        }
    }

    public static void DoSoundSpotMatch(int match, int sound_num, Sound.SoundType ignored) {
        --sound_num;
        ListNode<Sprite> node = Main.boardService.getStatNode(65);
        while (node != null) {
            int sn = node.getIndex();
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) == match && !Gameutils.TEST_BOOL6(sp)) {
                Sector.snd[0] = Gameutils.SP_TAG13(sp);
                Sector.snd[1] = Gameutils.SP_TAG5(sp);
                Sector.snd[2] = Gameutils.SP_TAG6(sp);
                int snd2play = 0;
                int flags = 0;
                if (Gameutils.TEST_BOOL2(sp)) {
                    flags = 193;
                }
                if (Gameutils.TEST_BOOL1(sp)) {
                    Gameutils.SET_BOOL6(sp);
                }
                if (Gameutils.TEST_BOOL4(sp)) {
                    flags |= 8;
                }
                if (Gameutils.TEST_BOOL5(sp)) {
                    flags |= 4;
                }
                if (Gameutils.TEST_BOOL3(sp)) {
                    if (snd[0] != 0 && snd[1] != 0) {
                        snd2play = snd[Gameutils.RANDOM_RANGE(2)];
                    } else if (snd[0] != 0 || snd[1] != 0 || snd[2] != 0) {
                        snd2play = snd[Gameutils.RANDOM_RANGE(3)];
                    }
                } else if (snd[sound_num] != 0) {
                    snd2play = snd[sound_num];
                }
                if (snd2play > 0) {
                    if (Gameutils.TEST_BOOL7(sp)) {
                        PlayerStr pp = GlobPlayerStr;
                        if (pp != null && pp == Game.Player[Mmulti.myconnectindex]) {
                            Sound.PlayerSound(snd2play, 9, pp);
                        }
                    } else {
                        Sound.Set3DSoundOwner(sn, Sound.PlaySound(snd2play, sp, flags));
                    }
                }
            }
            node = next_sn;
        }
    }

    public static void DoSoundSpotStopSound(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(65);
        while (node != null) {
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) == match && Gameutils.TEST_BOOL2(sp)) {
                Sound.DeleteNoSoundOwner(node.getIndex());
            }
            node = next_sn;
        }
    }

    public static void DoStopSoundSpotMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(66);
        while (node != null) {
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.SP_TAG2(sp) == match) {
                Sector.DoSoundSpotStopSound(Gameutils.SP_TAG5(sp));
            }
            node = next_sn;
        }
    }

    public static boolean TestKillSectorObject(Sector_Object sop) {
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_KILLABLE)) {
            Sector.KillMatchingCrackSprites(sop.match_event);
            Track.CollapseSectorObject(sop, sop.xmid, sop.ymid);
            Sector.DoSpawnSpotsForKill(sop.match_event);
            Track.KillSectorObjectSprites(sop);
            return true;
        }
        return false;
    }

    public static void DoSectorObjectKillMatch(int match) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.match_event != match) continue;
            Sector.TestKillSectorObject(sop);
            return;
        }
    }

    public static void SearchExplodeSectorMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(46);
        while (node != null) {
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == match) {
                Sector.KillMatchingCrackSprites(match);
                Sector.DoExplodeSector(match);
                return;
            }
            node = next_sn;
        }
    }

    public static void KillMatchingCrackSprites(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(46);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getHitag() == match && !MyTypes.TEST(Gameutils.SP_TAG8(sp), MyTypes.BIT(2))) {
                Sprites.KillSprite(i);
            }
            node = nexti;
        }
    }

    public static void WeaponExplodeSectorInRange(int weapon) {
        WangSprite wp = Main.boardService.getSprite(weapon);
        if (wp == null) {
            return;
        }
        USER wu = Gameutils.getUser(weapon);
        ListNode<Sprite> node = Main.boardService.getStatNode(46);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            int dist = Gameutils.FindDistance3D(wp.getX() - sp.getX(), wp.getY() - sp.getY(), wp.getZ() - sp.getZ() >> 4);
            if (sp.getClipdist() != 0) {
                int radius = (sp.getClipdist() << 2) * 8;
                if ((wu == null || dist <= wu.Radius / 2 + radius) && Rooms.FAFcansee(wp.getX(), wp.getY(), wp.getZ(), wp.getSectnum(), sp.getX(), sp.getY(), sp.getZ(), sp.getSectnum())) {
                    Weapon.MissileHitMatch(weapon, 12, i);
                    return;
                }
            }
            node = nexti;
        }
    }

    public static void ShootableSwitch(int SpriteNum, int ignored) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return;
        }
        switch (sp.getPicnum()) {
            case 577: {
                Sector.OperateSprite(SpriteNum, false);
                sp.setPicnum(578);
                break;
            }
            case 558: 
            case 559: {
                sp.setCstat(sp.getCstat() & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sector.OperateSprite(SpriteNum, false);
                sp.setPicnum(560);
            }
        }
    }

    public static void DoDeleteSpriteMatch(int match) {
        int del_x = 0;
        int del_y = 0;
        while (true) {
            Sprite sp;
            ListNode<Sprite> nexti;
            int i;
            int found = -1;
            ListNode<Sprite> node = Main.boardService.getStatNode(81);
            while (node != null) {
                i = node.getIndex();
                nexti = node.getNext();
                sp = node.get();
                if (sp.getLotag() == match) {
                    found = i;
                    del_x = sp.getX();
                    del_y = sp.getY();
                    break;
                }
                node = nexti;
            }
            if (found == -1) {
                return;
            }
            for (int stat = 0; stat < StatList.length; ++stat) {
                node = Main.boardService.getStatNode(StatList[stat]);
                while (node != null) {
                    i = node.getIndex();
                    nexti = node.getNext();
                    sp = node.get();
                    if (del_x == sp.getX() && del_y == sp.getY()) {
                        if (StatList[stat] == 83) {
                            sp.setShade((byte)Gameutils.SPRITE_TAG6(i));
                            sp.setPal(0);
                            Light.SectorLightShade(i, sp.getShade());
                            Light.DiffuseLighting(sp);
                        }
                        Weapon.SpriteQueueDelete(i);
                        Sprites.KillSprite(i);
                    }
                    node = nexti;
                }
            }
            Sprites.KillSprite(found);
        }
    }

    public static void DoChangorMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(94);
        while (node != null) {
            int sn = node.getIndex();
            ListNode<Sprite> next_sn = node.getNext();
            Sprite sp = node.get();
            ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(sp.getSectnum());
            if (sectp != null && Gameutils.SP_TAG2(sp) == match) {
                if (Gameutils.TEST_BOOL1(sp)) {
                    sectp.setCeilingpicnum(Gameutils.SP_TAG4(sp));
                    sectp.setCeilingz(sectp.getCeilingz() + Gameutils.Z(Gameutils.SP_TAG5(sp)));
                    sectp.setCeilingheinum(sectp.getCeilingheinum() + Gameutils.SP_TAG6(sp));
                    if (sectp.getCeilingheinum() != 0) {
                        sectp.setCeilingstat(sectp.getCeilingstat() | Gameutils.CEILING_STAT_SLOPE);
                    } else {
                        sectp.setCeilingstat(sectp.getCeilingstat() & ~Gameutils.CEILING_STAT_SLOPE);
                    }
                    sectp.setCeilingshade(sectp.getCeilingshade() + Gameutils.SP_TAG7(sp));
                    sectp.setCeilingpal(sectp.getCeilingpal() + Gameutils.SP_TAG8(sp));
                } else {
                    sectp.setFloorpicnum(Gameutils.SP_TAG4(sp));
                    sectp.setFloorz(sectp.getFloorz() + Gameutils.Z(Gameutils.SP_TAG5(sp)));
                    sectp.setFloorheinum(sectp.getFloorheinum() + Gameutils.SP_TAG6(sp));
                    if (sectp.getFloorheinum() != 0) {
                        sectp.setFloorstat(sectp.getFloorstat() | Gameutils.FLOOR_STAT_SLOPE);
                    } else {
                        sectp.setFloorstat(sectp.getFloorstat() & ~Gameutils.FLOOR_STAT_SLOPE);
                    }
                    sectp.setFloorshade(sectp.getFloorshade() + Gameutils.SP_TAG7(sp));
                    sectp.setFloorpal(sectp.getFloorpal() + Gameutils.SP_TAG8(sp));
                }
                sectp.setVisibility(sectp.getVisibility() + Gameutils.SP_TAG9(sp));
                if (!Gameutils.TEST_BOOL2(sp)) {
                    Sprites.KillSprite(sn);
                }
            }
            node = next_sn;
        }
    }

    public static void DoMatchEverything(PlayerStr pp, int match, int state) {
        PlayerStr bak = GlobPlayerStr;
        GlobPlayerStr = pp;
        Sector.DoStopSoundSpotMatch(match);
        Sector.DoSoundSpotMatch(match, 1, Sound.SoundType.SOUND_EVERYTHING_TYPE);
        GlobPlayerStr = bak;
        Light.DoLightingMatch(match, state);
        Quake.DoQuakeMatch(match);
        if (!Vator.TestVatorMatchActive(match)) {
            Vator.DoVatorMatch(pp, match);
        }
        if (!Spike.TestSpikeMatchActive(match)) {
            Spike.DoSpikeMatch(pp, match);
        }
        if (Rotator.TestRotatorMatchActive(match)) {
            Rotator.DoRotatorMatch(pp, match, false);
        }
        if (!Slidor.TestSlidorMatchActive(match)) {
            Slidor.DoSlidorMatch(pp, match, false);
        }
        Sector.DoSectorObjectKillMatch(match);
        Morth.DoSectorObjectSetScale(match);
        Morth.DoSOevent(match, state);
        Sector.DoSpawnActorTrigger(match);
        Sector.SearchExplodeSectorMatch(match);
        CopySect.CopySectorMatch(match);
        WallMove.DoWallMoveMatch(match);
        Sector.DoSpawnSpotsForKill(match);
        Sector.DoTrapReset(match);
        Sector.DoTrapMatch(match);
        Sprites.SpawnItemsMatch(match);
        Sector.DoChangorMatch(match);
        Sector.DoDeleteSpriteMatch(match);
    }

    public static boolean ComboSwitchTest(int combo_type, int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(0);
        while (node != null) {
            int state;
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (sp.getLotag() == combo_type && sp.getHitag() == match && (state = Sector.AnimateSwitch(sp, 999)) != Gameutils.SP_TAG3(sp)) {
                return false;
            }
            node = nexti;
        }
        return true;
    }

    public static boolean OperateSprite(int SpriteNum, boolean player_is_operating) {
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null) {
            return false;
        }
        PlayerStr pp = null;
        if (WangNetwork.Prediction) {
            return false;
        }
        if (sp.getPicnum() == 2307) {
            return false;
        }
        if (player_is_operating) {
            pp = GlobPlayerStr;
            if (!Rooms.FAFcansee(pp.posx, pp.posy, pp.posz, pp.cursectnum, sp.getX(), sp.getY(), sp.getZ() - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.getSectnum())) {
                return false;
            }
        }
        switch (sp.getLotag()) {
            case 4590: 
            case 4594: 
            case 4600: 
            case 4604: 
            case 5023: 
            case 5032: {
                USER u = Gameutils.getUser(SpriteNum);
                if (u == null) break;
                u.FlagOwner = 1;
                u.WaitTics = Gameutils.SEC(4);
                if (pp != Game.Player[Mmulti.myconnectindex]) {
                    return true;
                }
                int choose_snd = Gameutils.STD_RANDOM_RANGE(1000);
                if (sp.getLotag() == 4594) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(543, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(544, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(545, 9, pp);
                    } else {
                        Sound.PlayerSound(546, 9, pp);
                    }
                } else if (sp.getLotag() == 4590) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(539, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(540, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(541, 9, pp);
                    } else {
                        Sound.PlayerSound(542, 9, pp);
                    }
                } else if (sp.getLotag() == 4600) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(547, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(548, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(549, 9, pp);
                    } else {
                        Sound.PlayerSound(550, 9, pp);
                    }
                } else if (sp.getLotag() == 4604) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(551, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(552, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(553, 9, pp);
                    } else {
                        Sound.PlayerSound(554, 9, pp);
                    }
                } else if (sp.getLotag() == 5023) {
                    if (choose_snd > 700) {
                        Sound.PlayerSound(460, 9, pp);
                    } else if (choose_snd > 500) {
                        Sound.PlayerSound(461, 9, pp);
                    } else if (choose_snd > 250) {
                        Sound.PlayerSound(462, 9, pp);
                    } else {
                        Sound.PlayerSound(463, 9, pp);
                    }
                } else if (choose_snd > 700) {
                    Sound.PlayerSound(464, 9, pp);
                } else if (choose_snd > 500) {
                    Sound.PlayerSound(465, 9, pp);
                } else if (choose_snd > 250) {
                    Sound.PlayerSound(466, 9, pp);
                } else {
                    Sound.PlayerSound(467, 9, pp);
                }
                return true;
            }
            case 4768: {
                USER u = Gameutils.getUser(SpriteNum);
                if (u == null) break;
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko1Operate[0]);
                return true;
            }
            case 4792: {
                USER u = Gameutils.getUser(SpriteNum);
                if (u == null) break;
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko2Operate[0]);
                return true;
            }
            case 4816: {
                USER u = Gameutils.getUser(SpriteNum);
                if (u == null) break;
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko3Operate[0]);
                return true;
            }
            case 4840: {
                USER u = Gameutils.getUser(SpriteNum);
                if (u == null) break;
                if (u.WaitTics > 0) {
                    return true;
                }
                Sound.PlaySound(420, sp, 0);
                u.WaitTics = Gameutils.SEC(3) + Gameutils.SEC(Gameutils.RANDOM_RANGE(10));
                Sprites.ChangeState(SpriteNum, MiscActr.s_Pachinko4Operate[0]);
                return true;
            }
            case 29: {
                short key_num = sp.getHitag();
                if (key_num > 0 && key_num <= 8 && pp != null && pp.HasKey[key_num - 1] != 0) {
                    for (int i = 0; i < Main.boardService.getSectorCount(); ++i) {
                        Sect_User su = Sector.getSectUser(i);
                        if (su == null || su.stag != 29 || su.number != key_num) continue;
                        su.number = 0;
                    }
                    JSector.UnlockKeyLock(key_num, SpriteNum);
                }
                return true;
            }
            case 213: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(201, sp, 0);
                if (Sector.ComboSwitchTest(213, sp.getHitag())) {
                    Sector.DoMatchEverything(pp, sp.getHitag(), 1);
                }
                return true;
            }
            case 214: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(201, sp, 0);
                if (Sector.ComboSwitchTest(213, sp.getHitag())) {
                    Sector.DoMatchEverything(pp, sp.getHitag(), 1);
                }
                sp.setLotag(0);
                sp.setHitag(0);
                return true;
            }
            case 211: {
                Sector.DoMatchEverything(pp, sp.getHitag(), Sector.AnimateSwitch(sp, -1));
                return true;
            }
            case 212: {
                Sector.DoMatchEverything(pp, sp.getHitag(), Sector.AnimateSwitch(sp, -1));
                sp.setLotag(0);
                sp.setHitag(0);
                return true;
            }
            case 210: {
                Light.DoLightingMatch(sp.getHitag(), Sector.AnimateSwitch(sp, -1));
                return true;
            }
            case 206: {
                if (!Vator.TestVatorMatchActive(sp.getHitag())) {
                    Vator.DoVatorMatch(pp, sp.getHitag());
                }
                if (!Spike.TestSpikeMatchActive(sp.getHitag())) {
                    Spike.DoSpikeMatch(pp, sp.getHitag());
                }
                if (Rotator.TestRotatorMatchActive(sp.getHitag())) {
                    Rotator.DoRotatorMatch(pp, sp.getHitag(), false);
                }
                if (!Slidor.TestSlidorMatchActive(sp.getHitag())) {
                    Slidor.DoSlidorMatch(pp, sp.getHitag(), false);
                }
                return true;
            }
            case 116: {
                Sector.AnimateSwitch(sp, -1);
                Sound.PlaySound(202, sp, 0);
                Game.Level = sp.getHitag() != 0 ? (int)sp.getHitag() : ++Game.Level;
                Game.ExitLevel = true;
                Game.FinishedLevel = true;
                return true;
            }
            case 200: {
                Sprites.change_sprite_stat(SpriteNum, 41);
                USER u = Sprites.SpawnUser(SpriteNum, 0, null);
                u.ActorActionFunc = Sprites.DoGrating;
                sp.setLotag(0);
                sp.setHitag(sp.getHitag() / 2);
                return true;
            }
            case 208: {
                Sector.AnimateSwitch(sp, -1);
                Morth.DoSectorObjectSetScale(sp.getHitag());
                return true;
            }
            case 209: {
                Sector.AnimateSwitch(sp, -1);
                Morth.DoSectorObjectSetScale(sp.getHitag());
                sp.setLotag(0);
                sp.setHitag(0);
                return true;
            }
            case 215: {
                Sector.DoMatchEverything(null, sp.getHitag(), Sector.AnimateSwitch(sp, -1));
                sp.setHitag(0);
                sp.setLotag(0);
                Sound.PlaySound(201, sp, 0);
                break;
            }
            case 304: {
                short so_num = sp.getHitag();
                Sector.AnimateSwitch(sp, -1);
                Sector_Object sop = Sprites.SectorObject[so_num];
                sop.ang_tgt = Gameutils.NORM_ANGLE(sop.ang_tgt + 512);
                Sound.PlaySound(202, sp, 0);
                return true;
            }
        }
        return false;
    }

    public static void DoTrapReset(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(57);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            USER u = Gameutils.getUser(i);
            if (u != null && sp.getLotag() == match) {
                if (sp.getHitag() == 43) {
                    u.WaitTics = 0;
                }
                if (sp.getHitag() == 44) {
                    u.WaitTics = 0;
                }
                if (sp.getHitag() == 63) {
                    u.WaitTics = 0;
                }
            }
            node = nexti;
        }
    }

    public static void DoTrapMatch(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(57);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            USER u = Gameutils.getUser(i);
            if (u != null && sp.getLotag() == match) {
                if (sp.getHitag() == 43) {
                    u.WaitTics -= 3;
                    if (u.WaitTics <= 0) {
                        u.WaitTics = 120;
                        Weapon.InitFireballTrap(i);
                    }
                }
                if (sp.getHitag() == 44) {
                    u.WaitTics -= 3;
                    if (u.WaitTics <= 0) {
                        u.WaitTics = 120;
                        Weapon.InitBoltTrap(i);
                    }
                }
                if (sp.getHitag() == 63) {
                    u.WaitTics -= 3;
                    if (u.WaitTics <= 0) {
                        u.WaitTics = 120;
                        Weapon.InitSpearTrap(i);
                    }
                }
            }
            node = nexti;
        }
    }

    public static void OperateTripTrigger(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
        if (sectp == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        switch (Gameutils.LOW_TAG(pp.cursectnum)) {
            case 116: {
                Game.Level = sectp.getHitag() != 0 ? (int)sectp.getHitag() : ++Game.Level;
                Game.ExitLevel = true;
                Game.FinishedLevel = true;
                break;
            }
            case 217: {
                if (pp == Game.Player[Mmulti.myconnectindex]) {
                    Sound.PlayerSound(326, 13, pp);
                }
                Text.PutStringInfo(pp, "You found a secret area!");
                ++Game.Player[0].SecretsFound;
                sectp.setLotag(0);
                sectp.setHitag(0);
                break;
            }
            case 211: {
                Sector.DoMatchEverything(pp, sectp.getHitag(), -1);
                break;
            }
            case 212: {
                Sector.DoMatchEverything(pp, sectp.getHitag(), -1);
                sectp.setLotag(0);
                sectp.setHitag(0);
                break;
            }
            case 206: {
                if (!Vator.TestVatorMatchActive(sectp.getHitag())) {
                    Vator.DoVatorMatch(pp, sectp.getHitag());
                }
                if (!Spike.TestSpikeMatchActive(sectp.getHitag())) {
                    Spike.DoSpikeMatch(pp, sectp.getHitag());
                }
                if (Rotator.TestRotatorMatchActive(sectp.getHitag())) {
                    Rotator.DoRotatorMatch(pp, sectp.getHitag(), false);
                }
                if (Slidor.TestSlidorMatchActive(sectp.getHitag())) break;
                Slidor.DoSlidorMatch(pp, sectp.getHitag(), false);
                break;
            }
            case 210: {
                Light.DoLightingMatch(sectp.getHitag(), -1);
                break;
            }
            case 208: {
                Morth.DoSectorObjectSetScale(sectp.getHitag());
                break;
            }
            case 209: {
                Morth.DoSectorObjectSetScale(sectp.getHitag());
                sectp.setLotag(0);
                sectp.setHitag(0);
                break;
            }
            case 3: {
                short dist = sectp.getHitag();
                ListNode<Sprite> node = Main.boardService.getStatNode(2);
                while (node != null) {
                    int i = node.getIndex();
                    ListNode<Sprite> nexti = node.getNext();
                    Sprite sp = node.get();
                    USER u = Gameutils.getUser(i);
                    if (u != null && MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_TRIGGER) && Game.Distance(sp.getX(), sp.getY(), pp.posx, pp.posy) < dist) {
                        u.tgt_sp = pp.PlayerSprite;
                        u.Flags &= ~Gameutils.SPR_WAIT_FOR_TRIGGER;
                    }
                    node = nexti;
                }
                break;
            }
            case 43: {
                Sector.DoTrapReset(sectp.getHitag());
                break;
            }
            case 44: {
                Sector.DoMatchEverything(null, sectp.getHitag(), -1);
                break;
            }
            case 216: {
                Sector.DoMatchEverything(null, sectp.getHitag(), -1);
                sectp.setHitag(0);
                sectp.setLotag(0);
                break;
            }
            case 215: {
                Sector.DoMatchEverything(null, sectp.getHitag(), -1);
                sectp.setHitag(0);
                sectp.setLotag(0);
                Sound.PlaySound(201, pp, 0);
            }
        }
    }

    public static void OperateContinuousTrigger(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
        if (sectp == null) {
            return;
        }
        if (WangNetwork.Prediction) {
            return;
        }
        if (Gameutils.LOW_TAG(pp.cursectnum) == 43) {
            Sector.DoTrapMatch(sectp.getHitag());
            ListNode<Sprite> node = Main.boardService.getStatNode(57);
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite sp = node.get();
                USER u = Gameutils.getUser(i);
                if (u != null) {
                    if (sp.getHitag() == 43 && sp.getLotag() == sectp.getHitag()) {
                        u.WaitTics -= 3;
                        if (u.WaitTics <= 0) {
                            u.WaitTics = 120;
                            Weapon.InitFireballTrap(i);
                        }
                    }
                    if (sp.getHitag() == 44 && sp.getLotag() == sectp.getHitag()) {
                        u.WaitTics -= 3;
                        if (u.WaitTics <= 0) {
                            u.WaitTics = 120;
                            Weapon.InitBoltTrap(i);
                        }
                    }
                    if (sp.getHitag() == 63 && sp.getLotag() == sectp.getHitag()) {
                        u.WaitTics -= 3;
                        if (u.WaitTics <= 0) {
                            u.WaitTics = 120;
                            Weapon.InitSpearTrap(i);
                        }
                    }
                }
                node = nexti;
            }
        }
    }

    public static void PlayerTakeSectorDamage(PlayerStr pp) {
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        USER u = Gameutils.getUser(pp.PlayerSprite);
        if (sectu == null || u == null) {
            return;
        }
        if ((u.DamageTics -= 3) < 0) {
            u.DamageTics = 120;
            Panel.PlayerUpdateHealth(pp, -sectu.damage);
            Weapon.PlayerCheckDeath(pp, -1);
        }
    }

    public static void NearThings(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
        if (sectp == null) {
            return;
        }
        if (sectp.getHitag() == 900) {
            if (pp == Game.Player[Mmulti.myconnectindex]) {
                Sound.PlayerSound(sectp.getLotag(), 9, pp);
            }
            return;
        }
        Main.engine.neartag(pp.posx, pp.posy, pp.posz, pp.cursectnum, pp.getAnglei(), Engine.neartag, 1024, 3);
        WangSprite sp = Main.boardService.getSprite(Engine.neartag.tagsprite);
        if (sp != null) {
            if (sp.getHitag() == 900 && pp == Game.Player[Mmulti.myconnectindex]) {
                Sound.PlayerSound(sp.getLotag(), 9, pp);
            }
            return;
        }
        Wall nearwall = Main.boardService.getWall(Engine.neartag.tagwall);
        if (nearwall != null) {
            if (nearwall.getHitag() == 900) {
                if (pp == Game.Player[Mmulti.myconnectindex]) {
                    Sound.PlayerSound(nearwall.getLotag(), 9, pp);
                }
                return;
            }
            return;
        }
        int dang = pp.getAnglei();
        Rooms.FAFhitscan(pp.posx, pp.posy, pp.posz - Gameutils.Z(30), pp.cursectnum, EngineUtils.sin(Gameutils.NORM_ANGLE(dang + 512)), EngineUtils.sin(Gameutils.NORM_ANGLE(dang)), 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect == -1) {
            return;
        }
        if (Game.Distance(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, pp.posx, pp.posy) > 1024) {
            return;
        }
        if (Engine.pHitInfo.hitsprite != -1) {
            return;
        }
        if (Engine.neartag.tagsector >= 0) {
            return;
        }
        Wall wp = Main.boardService.getWall(Engine.pHitInfo.hitwall);
        if (wp != null && !MyTypes.TEST(wp.getExtra(), Gameutils.WALLFX_DONT_STICK) && pp == Game.Player[Mmulti.myconnectindex]) {
            if (Gameutils.STD_RANDOM_RANGE(1000) > 970) {
                Sound.PlayerSound(450, 9, pp);
            } else {
                Sound.PlayerSound(264, 9, pp);
            }
        }
    }

    public static void NearTagList(NEAR_TAG_INFO[] ntip, int ntipnum, PlayerStr pp, int z, int dist, int type, int count) {
        Main.engine.neartag(pp.posx, pp.posy, z, pp.cursectnum, pp.getAnglei(), Engine.neartag, dist, type);
        short neartagsector = Engine.neartag.tagsector;
        int neartaghitdist = Engine.neartag.taghitdist;
        short neartagwall = Engine.neartag.tagwall;
        short neartagsprite = Engine.neartag.tagsprite;
        ru.m210projects.Build.Types.Sector nearsec = Main.boardService.getSector(neartagsector);
        Wall nearwall = Main.boardService.getWall(neartagwall);
        WangSprite nearsprite = Main.boardService.getSprite(neartagsprite);
        if (nearsec != null) {
            short save_lotag = nearsec.getLotag();
            short save_hitag = nearsec.getHitag();
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = neartagsector;
            ntip[ntipnum].spritenum = -1;
            ++ntipnum;
            if (++nti_cnt >= count) {
                return;
            }
            nearsec.setLotag(0);
            nearsec.setHitag(0);
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            nearsec.setLotag(save_lotag);
            nearsec.setHitag(save_hitag);
        } else if (nearwall != null) {
            short save_lotag = nearwall.getLotag();
            short save_hitag = nearwall.getHitag();
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = -1;
            ntip[ntipnum].spritenum = -1;
            ++ntipnum;
            if (++nti_cnt >= count) {
                return;
            }
            nearwall.setLotag(0);
            nearwall.setHitag(0);
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            nearwall.setLotag(save_lotag);
            nearwall.setHitag(save_hitag);
        } else if (nearsprite != null) {
            short save_lotag = nearsprite.getLotag();
            short save_hitag = nearsprite.getHitag();
            ntip[ntipnum].dist = neartaghitdist;
            ntip[ntipnum].sectnum = -1;
            ntip[ntipnum].spritenum = neartagsprite;
            ++ntipnum;
            if (++nti_cnt >= count) {
                return;
            }
            nearsprite.setLotag(0);
            nearsprite.setHitag(0);
            Sector.NearTagList(ntip, ntipnum, pp, z, dist, type, count);
            nearsprite.setLotag(save_lotag);
            nearsprite.setHitag(save_hitag);
        } else {
            ntip[ntipnum].dist = -1;
            ntip[ntipnum].sectnum = -1;
            ntip[ntipnum].spritenum = -1;
            ++nti_cnt;
        }
    }

    public static void BuildNearTagList(NEAR_TAG_INFO[] ntip, int size, PlayerStr pp, int z, int dist, int type, int count) {
        for (int i = 0; i < size; ++i) {
            ntip[i].reset();
        }
        nti_cnt = 0;
        Sector.NearTagList(ntip, 0, pp, z, dist, type, count);
    }

    public static boolean DoPlayerGrabStar(PlayerStr pp) {
        int i;
        WangSprite sp = null;
        for (i = 0; i < 32 && (Weapon.StarQueue[i] < 0 || (sp = Main.boardService.getSprite(Weapon.StarQueue[i])) == null || Gameutils.FindDistance3D(sp.getX() - pp.posx, sp.getY() - pp.posy, sp.getZ() - pp.posz + Gameutils.Z(12) >> 4) >= 500); ++i) {
        }
        if (i < 32) {
            Panel.PlayerUpdateAmmo(pp, 1, 1);
            Sound.PlaySound(54, sp, 0);
            Sprites.KillSprite(Weapon.StarQueue[i]);
            Weapon.StarQueue[i] = -1;
            if (MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(1))) {
                return true;
            }
            pp.WpnFlags |= MyTypes.BIT(1);
            Star.InitWeaponStar(pp);
            return true;
        }
        return false;
    }

    public static void PlayerOperateEnv(PlayerStr pp) {
        ru.m210projects.Build.Types.Sector sectp = Main.boardService.getSector(pp.cursectnum);
        Sprite psp = pp.getSprite();
        if (psp == null || sectp == null) {
            return;
        }
        Sect_User sectu = Sector.getSectUser(pp.cursectnum);
        if (WangNetwork.Prediction) {
            return;
        }
        if (Gameutils.TEST_SYNC_KEY(pp, 18)) {
            if (Gameutils.FLAG_KEY_PRESSED(pp, 18)) {
                if (Sector.DoPlayerGrabStar(pp)) {
                    Gameutils.FLAG_KEY_RELEASE(pp, 18);
                } else {
                    Sector.NearThings(pp);
                }
                Sector.BuildNearTagList(nti, 16, pp, pp.posz, 2048, 3, 8);
                boolean found = false;
                int nt_ndx = 0;
                while (Sector.nti[nt_ndx].dist >= 0) {
                    if (Sector.nti[nt_ndx].spritenum >= 0 && Sector.nti[nt_ndx].dist < 1792 && Sector.OperateSprite(Sector.nti[nt_ndx].spritenum, true)) {
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        found = true;
                    }
                    ++nt_ndx;
                }
                if (!found) {
                    Sector.z[0] = psp.getZ() - Gameutils.SPRITEp_SIZE_Z(psp) - Gameutils.Z(10);
                    Sector.z[1] = psp.getZ();
                    Sector.z[2] = MyTypes.DIV2(z[0] + z[1]);
                    block6: for (int i = 0; i < 3; ++i) {
                        Sector.BuildNearTagList(nti, 16, pp, z[i], 1792, 3, 8);
                        nt_ndx = 0;
                        while (Sector.nti[nt_ndx].dist >= 0) {
                            if (Sector.nti[nt_ndx].spritenum >= 0 && Sector.nti[nt_ndx].dist < 1792 && Sector.OperateSprite(Sector.nti[nt_ndx].spritenum, true)) {
                                Gameutils.FLAG_KEY_RELEASE(pp, 18);
                                continue block6;
                            }
                            ++nt_ndx;
                        }
                    }
                }
                int neartaghitdist = Sector.nti[0].dist;
                int neartagsector = Sector.nti[0].sectnum;
                if (neartagsector >= 0 && neartaghitdist < 1024 && Sector.OperateSector(neartagsector, true)) {
                    ru.m210projects.Build.Types.Sector secretSec;
                    Gameutils.FLAG_KEY_RELEASE(pp, 18);
                    if (pp.cursectnum == 491 && Game.Level == 11 && Game.swGetAddon() == 1 && (secretSec = Main.boardService.getSector(715)) != null && secretSec.getLotag() == 217) {
                        if (pp == Game.Player[Mmulti.myconnectindex]) {
                            Sound.PlayerSound(326, 13, pp);
                        }
                        Text.PutStringInfo(pp, "You found a secret area!");
                        ++Game.Player[0].SecretsFound;
                        secretSec.setLotag(0);
                    }
                }
                switch (Gameutils.LOW_TAG(pp.cursectnum)) {
                    case 206: {
                        Vator.DoVatorOperate(pp, pp.cursectnum);
                        Spike.DoSpikeOperate(pp, pp.cursectnum);
                        Rotator.DoRotatorOperate(pp, pp.cursectnum);
                        Slidor.DoSlidorOperate(pp, pp.cursectnum);
                        break;
                    }
                    case 240: {
                        Sector.DoSpringBoard(pp);
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                        break;
                    }
                    case 112: {
                        if (!Sector.OperateSector(pp.cursectnum, true)) break;
                        Gameutils.FLAG_KEY_RELEASE(pp, 18);
                    }
                }
            }
        } else {
            Gameutils.FLAG_KEY_RESET(pp, 18);
        }
        if (sectu != null && sectu.damage != 0) {
            if (MyTypes.TEST(sectu.flags, Gameutils.SECTFU_DAMAGE_ABOVE_SECTOR)) {
                Sector.PlayerTakeSectorDamage(pp);
            } else if (Gameutils.SPRITEp_BOS(pp.getSprite()) >= sectp.getFloorz() && !MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING)) {
                Sector.PlayerTakeSectorDamage(pp);
            }
        } else {
            USER u = Gameutils.getUser(pp.PlayerSprite);
            if (u != null) {
                u.DamageTics = 0;
            }
        }
        Sector.OperateContinuousTrigger(pp);
        if (pp.lastcursectnum != pp.cursectnum) {
            Sector.OperateTripTrigger(pp);
            ru.m210projects.Build.Types.Sector sec = Main.boardService.getSector(pp.cursectnum);
            if (sec != null && MyTypes.TEST(sec.getExtra(), Gameutils.SECTFX_WARP_SECTOR) && !MyTypes.TEST(pp.Flags2, Gameutils.PF2_TELEPORTED)) {
                Player.DoPlayerWarpTeleporter(pp);
            }
            pp.Flags2 &= ~Gameutils.PF2_TELEPORTED;
        }
    }

    public static void DoSineWaveFloor() {
        ru.m210projects.Build.Types.Sector sec;
        SINE_WAVE_FLOOR swf;
        int swi;
        int flags;
        int wave;
        for (wave = 0; wave < 6; ++wave) {
            flags = Sector.SineWaveFloor[wave][0].flags;
            for (swi = 0; swi < SineWaveFloor[wave].length && Sector.SineWaveFloor[wave][swi].sector >= 0; ++swi) {
                int newz;
                swf = SineWaveFloor[wave][swi];
                swf.sintable_ndx = Gameutils.NORM_ANGLE(swf.sintable_ndx + (3 << swf.speed_shift));
                sec = Main.boardService.getSector(swf.sector);
                if (sec == null) continue;
                if (MyTypes.TEST(flags, 1)) {
                    newz = swf.floor_origz + (swf.range * EngineUtils.sin(swf.sintable_ndx) >> 14);
                    Main.game.pInt.setfloorinterpolate(swf.sector, sec);
                    sec.setFloorz(newz);
                }
                if (!MyTypes.TEST(flags, 2)) continue;
                newz = swf.ceiling_origz + (swf.range * EngineUtils.sin(swf.sintable_ndx) >> 14);
                Main.game.pInt.setceilinterpolate(swf.sector, sec);
                sec.setCeilingz(newz);
            }
        }
        for (wave = 0; wave < 6; ++wave) {
            flags = Sector.SineWaveFloor[wave][0].flags;
            for (swi = 0; swi < SineWaveFloor[wave].length && Sector.SineWaveFloor[wave][swi].sector >= 0; ++swi) {
                Wall wal;
                swf = SineWaveFloor[wave][swi];
                sec = Main.boardService.getSector(swf.sector);
                if (sec == null || !MyTypes.TEST(sec.getFloorstat(), Gameutils.FLOOR_STAT_SLOPE) || !MyTypes.TEST(flags, SINE_SLOPED) || sec.getWallnum() != 4 || (wal = Main.boardService.getWall(sec.getWallptr() + 2)) == null) continue;
                Main.game.pInt.setfheinuminterpolate(swf.sector, sec);
                ru.m210projects.Build.Types.Sector ns = Main.boardService.getSector(wal.getNextsector());
                if (ns == null) continue;
                Main.engine.alignflorslope(swf.sector, wal.getX(), wal.getY(), ns.getFloorz());
            }
        }
    }

    public static void DoSineWaveWall() {
        for (int sw_num = 0; sw_num < 6; ++sw_num) {
            for (int swi = 0; swi < 64 && Sector.SineWall[sw_num][swi].wall >= 0; ++swi) {
                SINE_WALL sw = SineWall[sw_num][swi];
                Wall wp = Main.boardService.getWall(sw.wall);
                if (wp == null) continue;
                sw.sintable_ndx = Gameutils.NORM_ANGLE(sw.sintable_ndx + (3 << sw.speed_shift));
                int newsp = sw.orig_xy + (sw.range * EngineUtils.sin(sw.sintable_ndx) >> 14);
                if (sw.type == 0) {
                    Main.engine.dragpoint(sw.wall, wp.getX(), newsp);
                    continue;
                }
                Main.engine.dragpoint(sw.wall, newsp, wp.getY());
            }
        }
    }

    public static int getAnimValue(Object obj, Anim.AnimType type) {
        int j = 0;
        switch (type) {
            case FloorZ: {
                j = ((ru.m210projects.Build.Types.Sector)obj).getFloorz();
                break;
            }
            case CeilZ: {
                j = ((ru.m210projects.Build.Types.Sector)obj).getCeilingz();
                break;
            }
            case SpriteZ: {
                j = ((Sprite)obj).getZ();
                break;
            }
            case SectorObjectZ: {
                j = ((Sector_Object)obj).zmid;
                break;
            }
            case UserZ: {
                j = ((USER)obj).sz;
                break;
            }
            case SectUserDepth: {
                j = ((Sect_User)obj).depth_fract;
            }
        }
        return j;
    }

    public static void DoAnim(int numtics) {
        int i = AnimCnt - 1;
        while (i >= 0) {
            Interpolation gInt = Main.game.pInt;
            Anim gAnm = pAnim[i];
            Object obj = gAnm.ptr;
            int animval = Sector.getAnimValue(gAnm.ptr, gAnm.type);
            animval = animval < gAnm.goal ? Math.min(animval + numtics * Gameutils.PIXZ(gAnm.vel), gAnm.goal) : Math.max(animval - numtics * Gameutils.PIXZ(gAnm.vel), gAnm.goal);
            gAnm.vel += gAnm.vel_adj * numtics;
            switch (gAnm.type) {
                case FloorZ: {
                    gInt.setfloorinterpolate(gAnm.index, (ru.m210projects.Build.Types.Sector)obj);
                    ((ru.m210projects.Build.Types.Sector)obj).setFloorz(animval);
                    break;
                }
                case CeilZ: {
                    gInt.setceilinterpolate(gAnm.index, (ru.m210projects.Build.Types.Sector)obj);
                    ((ru.m210projects.Build.Types.Sector)obj).setCeilingz(animval);
                    break;
                }
                case SpriteZ: {
                    gInt.setsprinterpolate(gAnm.index, (Sprite)obj);
                    ((Sprite)obj).setZ(animval);
                    break;
                }
                case SectorObjectZ: {
                    ((Sector_Object)obj).zmid = animval;
                    break;
                }
                case UserZ: {
                    ((USER)obj).sz = animval;
                    break;
                }
                case SectUserDepth: {
                    ((Sect_User)obj).depth_fract = animval;
                }
            }
            if (animval == gAnm.goal) {
                Anim.AnimCallback acp = gAnm.callback;
                if (gAnm.callback != null) {
                    gAnm.callback.invoke(gAnm, gAnm.callbackdata);
                }
                if (gAnm.callback == acp) {
                    gAnm.copy(pAnim[--AnimCnt]);
                }
            }
            --i;
        }
    }

    public static int AnimGetGoal(Object object, Anim.AnimType type) {
        int j = -1;
        for (int i = AnimCnt - 1; i >= 0; --i) {
            if (object != Sector.pAnim[i].ptr || type != Sector.pAnim[i].type) continue;
            j = i;
            break;
        }
        return j;
    }

    public static void AnimDelete(Object object, Anim.AnimType type) {
        int j = -1;
        for (int i = 0; i < AnimCnt; ++i) {
            if (object != Sector.pAnim[i].ptr || type != Sector.pAnim[i].type) continue;
            j = i;
            break;
        }
        if (j == -1) {
            return;
        }
        pAnim[j].copy(pAnim[--AnimCnt]);
    }

    public static void InitAnim() {
        for (int i = 0; i < 256; ++i) {
            Sector.pAnim[i] = new Anim();
        }
    }

    public static Object GetAnimObject(int index, Anim.AnimType type) {
        Object object = null;
        switch (type) {
            case FloorZ: 
            case CeilZ: {
                object = Main.boardService.getSector(index);
                break;
            }
            case SpriteZ: {
                object = Main.boardService.getSprite(index);
                break;
            }
            case SectorObjectZ: {
                object = Sprites.SectorObject[index];
                break;
            }
            case UserZ: {
                object = Gameutils.getUser(index);
                break;
            }
            case SectUserDepth: {
                object = Sprites.SetupSectUser(index);
            }
        }
        return object;
    }

    public static int AnimSet(int index, int thegoal, int thevel, Anim.AnimType type) {
        if (AnimCnt >= 256) {
            return -1;
        }
        Object animptr = Sector.GetAnimObject(index, type);
        if (animptr == null) {
            return -1;
        }
        int j = Sector.AnimGetGoal(animptr, type);
        if (j == -1) {
            j = AnimCnt;
        }
        Sector.pAnim[j].ptr = animptr;
        Sector.pAnim[j].index = index;
        Sector.pAnim[j].type = type;
        Sector.pAnim[j].goal = thegoal;
        Sector.pAnim[j].vel = Gameutils.Z(thevel);
        Sector.pAnim[j].vel_adj = 0;
        Sector.pAnim[j].callback = null;
        Sector.pAnim[j].callbackdata = -1;
        if (j == AnimCnt) {
            ++AnimCnt;
        }
        return j;
    }

    public static void AnimSetCallback(int anim_ndx, Anim.AnimCallback call, int data) {
        if (anim_ndx >= AnimCnt) {
            return;
        }
        if (anim_ndx == -1) {
            return;
        }
        Sector.pAnim[anim_ndx].callback = call;
        Sector.pAnim[anim_ndx].callbackdata = data;
    }

    public static void AnimSetVelAdj(int anim_ndx, int vel_adj) {
        if (anim_ndx >= AnimCnt) {
            return;
        }
        if (anim_ndx == -1) {
            return;
        }
        Sector.pAnim[anim_ndx].vel_adj = vel_adj;
    }

    public static void DoPanning() {
        int ny;
        int nx;
        ru.m210projects.Build.Types.Sector sectp;
        Sprite sp;
        ListNode<Sprite> nexti;
        ListNode<Sprite> node = Main.boardService.getStatNode(87);
        while (node != null) {
            nexti = node.getNext();
            sp = node.get();
            sectp = Main.boardService.getSector(sp.getSectnum());
            if (sectp != null) {
                nx = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) * sp.getXvel() >> 20;
                ny = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) * sp.getXvel() >> 20;
                sectp.setFloorxpanning(sectp.getFloorxpanning() + nx);
                sectp.setFloorypanning(sectp.getFloorypanning() + ny);
                sectp.setFloorxpanning(sectp.getFloorxpanning() & 0xFF);
                sectp.setFloorypanning(sectp.getFloorypanning() & 0xFF);
            }
            node = nexti;
        }
        node = Main.boardService.getStatNode(88);
        while (node != null) {
            nexti = node.getNext();
            sp = node.get();
            sectp = Main.boardService.getSector(sp.getSectnum());
            if (sectp != null) {
                nx = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) * sp.getXvel() >> 20;
                ny = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) * sp.getXvel() >> 20;
                sectp.setCeilingxpanning(sectp.getCeilingxpanning() + nx);
                sectp.setCeilingypanning(sectp.getCeilingypanning() + ny);
                sectp.setCeilingxpanning(sectp.getCeilingxpanning() & 0xFF);
                sectp.setCeilingypanning(sectp.getCeilingypanning() & 0xFF);
            }
            node = nexti;
        }
        node = Main.boardService.getStatNode(89);
        while (node != null) {
            nexti = node.getNext();
            sp = node.get();
            Wall wp = Main.boardService.getWall(sp.getOwner());
            if (wp != null) {
                nx = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng() + 512)) * sp.getXvel() >> 20;
                ny = EngineUtils.sin(Gameutils.NORM_ANGLE(sp.getAng())) * sp.getXvel() >> 20;
                wp.setXpanning(wp.getXpanning() + nx);
                wp.setYpanning(wp.getYpanning() + ny);
                wp.setXpanning(wp.getXpanning() & 0xFF);
                wp.setYpanning(wp.getYpanning() & 0xFF);
            }
            node = nexti;
        }
    }

    public static void DoSector() {
        for (int j = 0; j < 25; ++j) {
            Sector_Object sop = Sprites.SectorObject[j];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            boolean riding = false;
            int min_dist = 999999;
            short pnum = Mmulti.connecthead;
            while (pnum != -1) {
                PlayerStr pp = Game.Player[pnum];
                if (pp.sop_riding == j) {
                    riding = true;
                    pp.sop_riding = -1;
                    break;
                }
                int dist = Gameutils.DISTANCE(pp.posx, pp.posy, sop.xmid, sop.ymid);
                if (dist < min_dist) {
                    min_dist = dist;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            if (sop.Animator != null) {
                sop.Animator.invoke(j);
                continue;
            }
            int sync_flag = MyTypes.DTEST(sop.flags, Gameutils.SOBJ_SYNC1 | Gameutils.SOBJ_SYNC2);
            if (sync_flag != 0) {
                if (sync_flag == Gameutils.SOBJ_SYNC1) {
                    Track.MoveSectorObjects(j, 3, 1);
                    continue;
                }
                if (Sprites.MoveSkip2) continue;
                Track.MoveSectorObjects(j, 6, 2);
                continue;
            }
            if (riding) {
                Track.MoveSectorObjects(j, 3, 1);
                continue;
            }
            if (min_dist < 15000) {
                if (Sprites.MoveSkip2) continue;
                Track.MoveSectorObjects(j, 6, 2);
                continue;
            }
            if (Sprites.MoveSkip4 != 0) continue;
            Track.MoveSectorObjects(j, 12, 4);
        }
        Sector.DoPanning();
        Light.DoLighting();
        Sector.DoSineWaveFloor();
        Sector.DoSineWaveWall();
        Sector.DoSpringBoardDown();
    }

    public static void clearSecUser() {
        Arrays.fill(SectUser, null);
    }

    @Nullable
    public static Sect_User getSectUser(int sectnum) {
        if (sectnum >= 0 && sectnum < SectUser.length) {
            return SectUser[sectnum];
        }
        return null;
    }

    public static void setSectUser(int sectnum, Sect_User su) {
        Sector.SectUser[sectnum] = su;
    }

    static {
        SectUser = new Sect_User[Engine.MAXSECTORS];
        pAnim = new Anim[256];
        AnimCnt = 0;
        DoSpawnSpot = new Animator(Sector::DoSpawnSpot);
        SineWaveFloor = new SINE_WAVE_FLOOR[6][21];
        SineWall = new SINE_WALL[10][64];
        SpringBoard = new Spring_Board[20];
        midPoint = new Vector3i();
        snd = new int[3];
        nti = new NEAR_TAG_INFO[16];
        z = new int[3];
    }
}

