/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vator;

public class Spike {
    public static final Animator DoSpike = new Animator(Spike::DoSpike);
    public static final Animator DoSpikeAuto = new Animator(Spike::DoSpikeAuto);

    public static void ReverseSpike(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if (u.Tics != 0) {
            u.Tics = 0;
            Spike.SetSpikeActive(SpriteNum);
            return;
        }
        if (u.z_tgt == u.oz) {
            if (sp.getZ() == u.oz) {
                u.z_tgt = u.sz;
            } else if (u.sz == u.oz) {
                u.z_tgt = sp.getZ();
            }
        } else if (u.z_tgt == u.sz) {
            if (sp.getZ() == u.oz) {
                u.z_tgt = sp.getZ();
            } else if (u.sz == u.oz) {
                u.z_tgt = u.sz;
            }
        }
        u.vel_rate = -u.vel_rate;
    }

    public static void SetSpikeActive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Vator.InterpSectorSprites(sp.getSectnum(), true);
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags |= Gameutils.SPR_ACTIVE;
        u.Tics = 0;
        if (u.z_tgt == sp.getZ()) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 1);
        } else if (u.z_tgt == u.sz) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 0);
        }
    }

    public static void SetSpikeInactive(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        Vator.InterpSectorSprites(sp.getSectnum(), false);
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 2, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags &= ~Gameutils.SPR_ACTIVE;
    }

    public static void DoSpikeOperate(PlayerStr pp, int sectnum) {
        ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (fsp.getStatnum() == 82 && Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG3(fsp) == 0) {
                int match = Gameutils.SP_TAG2(fsp);
                if (match > 0) {
                    if (!Spike.TestSpikeMatchActive(match)) {
                        Spike.DoSpikeMatch(pp, match);
                    }
                    return;
                }
                Spike.SetSpikeActive(i);
                break;
            }
            node = nexti;
        }
    }

    public static void DoSpikeMatch(PlayerStr ignored, int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(82);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.getUser(i);
                if (fu != null && MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE)) {
                    Spike.ReverseSpike(i);
                } else {
                    Spike.SetSpikeActive(i);
                }
            }
            node = nexti;
        }
    }

    public static boolean TestSpikeMatchActive(int match) {
        ListNode<Sprite> node = Main.boardService.getStatNode(82);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite fsp = node.get();
            if (Gameutils.SP_TAG1(fsp) == 106 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.getUser(i);
                if (!Gameutils.TEST_BOOL6(fsp) && fu != null && (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE) || fu.Tics != 0)) {
                    return true;
                }
            }
            node = nexti;
        }
        return false;
    }

    public static int DoSpikeMove(int SpriteNum, int lptr) {
        USER u = Gameutils.getUser(SpriteNum);
        if (u == null) {
            return 0;
        }
        int zval = lptr;
        if (zval < u.z_tgt) {
            u.jump_speed += u.vel_rate * 3;
            if ((zval += 3 * u.jump_speed) > u.z_tgt) {
                zval = u.z_tgt;
            }
        }
        if (zval > u.z_tgt) {
            u.jump_speed += u.vel_rate * 3;
            if ((zval -= 3 * u.jump_speed) < u.z_tgt) {
                zval = u.z_tgt;
            }
        }
        return zval;
    }

    public static void SpikeAlign(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        if ((byte)Gameutils.SP_TAG7(sp) < 0) {
            if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_YFLIP)) {
                Main.game.pInt.setcheinuminterpolate(sp.getSectnum(), Main.boardService.getSector(sp.getSectnum()));
                Main.engine.alignceilslope(sp.getSectnum(), sp.getX(), sp.getY(), u.zclip);
            } else {
                Main.game.pInt.setfheinuminterpolate(sp.getSectnum(), Main.boardService.getSector(sp.getSectnum()));
                Main.engine.alignflorslope(sp.getSectnum(), sp.getX(), sp.getY(), u.zclip);
            }
        } else if (MyTypes.TEST(sp.getCstat(), Gameutils.CSTAT_SPRITE_YFLIP)) {
            Morth.SOBJ_AlignCeilingToPoint(Sprites.SectorObject[Gameutils.SP_TAG7(sp)], sp.getX(), sp.getY(), u.zclip);
        } else {
            Morth.SOBJ_AlignFloorToPoint(Sprites.SectorObject[Gameutils.SP_TAG7(sp)], sp.getX(), sp.getY(), u.zclip);
        }
    }

    public static void MoveSpritesWithSpike(int sectnum) {
        ListNode<Sprite> node = Main.boardService.getSectNode(sectnum);
        while (node != null) {
            int i = node.getIndex();
            ListNode<Sprite> nexti = node.getNext();
            Sprite sp = node.get();
            if (Gameutils.getUser(i) == null && !MyTypes.TEST(sp.getExtra(), Gameutils.SPRX_STAY_PUT_VATOR)) {
                Main.engine.getzsofslope(sectnum, sp.getX(), sp.getY(), Rooms.fz, Rooms.cz);
                Main.game.pInt.setsprinterpolate(i, sp);
                sp.setZ(Rooms.fz.get());
            }
            node = nexti;
        }
    }

    public static void DoSpike(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int lptr = u.zclip = Spike.DoSpikeMove(SpriteNum, u.zclip);
        Spike.MoveSpritesWithSpike(sp.getSectnum());
        Spike.SpikeAlign(SpriteNum);
        if (lptr == u.z_tgt) {
            if (u.z_tgt == sp.getZ()) {
                u.z_tgt = u.sz;
                u.vel_rate = -u.vel_rate;
                Spike.SetSpikeInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            } else if (u.z_tgt == u.sz) {
                u.jump_speed = u.vel_tgt;
                u.vel_rate = Pragmas.klabs(u.vel_rate);
                u.z_tgt = sp.getZ();
                Spike.SetSpikeInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
            if (Gameutils.TEST_BOOL2(sp)) {
                Spike.SetSpikeInactive(SpriteNum);
                Sprites.KillSprite(SpriteNum);
                return;
            }
            if (lptr != u.oz && u.WaitTics != 0) {
                u.Tics = u.WaitTics;
            }
        } else if (Gameutils.TEST_BOOL3(sp) && u.z_tgt == u.oz) {
            boolean found = false;
            ListNode<Sprite> node = Main.boardService.getSectNode(sp.getSectnum());
            while (node != null) {
                int i = node.getIndex();
                ListNode<Sprite> nexti = node.getNext();
                Sprite bsp = node.get();
                USER bu = Gameutils.getUser(i);
                if (bu != null && MyTypes.TEST(bsp.getCstat(), Gameutils.CSTAT_SPRITE_BLOCK) && MyTypes.TEST(bsp.getExtra(), Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                    Spike.ReverseSpike(SpriteNum);
                    found = true;
                    break;
                }
                node = nexti;
            }
            if (!found) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp = Game.Player[pnum];
                    if (Main.boardService.getSector(pp.lo_sectp) != null && pp.lo_sectp == sp.getSectnum() || pp.hi_sectp != -1 && pp.hi_sectp == sp.getSectnum()) {
                        Spike.ReverseSpike(SpriteNum);
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
        }
    }

    public static void DoSpikeAuto(int SpriteNum) {
        USER u = Gameutils.getUser(SpriteNum);
        WangSprite sp = Main.boardService.getSprite(SpriteNum);
        if (sp == null || u == null) {
            return;
        }
        int lptr = u.zclip = Spike.DoSpikeMove(SpriteNum, u.zclip);
        Spike.MoveSpritesWithSpike(sp.getSectnum());
        Spike.SpikeAlign(SpriteNum);
        if (lptr == u.z_tgt) {
            if (u.z_tgt == sp.getZ()) {
                u.z_tgt = u.sz;
                u.vel_rate = -u.vel_rate;
                u.Tics = u.WaitTics;
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            } else if (u.z_tgt == u.sz) {
                u.jump_speed = u.vel_tgt;
                u.vel_rate = Pragmas.klabs(u.vel_rate);
                u.z_tgt = sp.getZ();
                u.Tics = u.WaitTics;
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
        }
    }
}

