/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.Input;
import ru.m210projects.Wang.Type.ResourceHandler;

public class DemoFile {
    public static final String header = "SWDEM";
    public int rcnt;
    public int reccnt;
    public Input[][] recsync;
    public Main.UserFlag userFlag;
    public String mapname;
    public int numplayers;
    public int Episode;
    public int Level;
    public int Skill;
    public String LevelSong;
    public int[] Flags;
    public int[] Armors;
    public int[] Health;
    public int[] MaxHealth;
    public int[] WpnFlags;
    public byte[] WpnRocketHeats;
    public byte[] WpnRocketNukes;
    public int[][] WpnAmmo;
    public int[][] InventoryPercent;
    public int[][] InventoryAmount;
    public int[] InventoryNums;
    public GameInfo addon;
    public int KillLimit;
    public int TimeLimit;
    public int TimeLimitClock;
    public WangNetwork.MultiGameTypes MultiGameType;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean AutoAim;
    public boolean NoRespawn;
    public boolean Nuke;
    public int nVersion = 1;

    public DemoFile(InputStream is) throws Exception {
        int p;
        this.mapname = StreamUtils.readString(is, 5);
        if (this.mapname.equalsIgnoreCase(header)) {
            this.nVersion = StreamUtils.readInt(is);
            this.reccnt = StreamUtils.readInt(is);
            this.userFlag = Main.UserFlag.parseValue(StreamUtils.readByte(is));
            if (this.userFlag == Main.UserFlag.Addon) {
                String addonFileName = StreamUtils.readDataString(is).toLowerCase();
                this.addon = this.findAddon(addonFileName);
            }
            this.mapname = StreamUtils.readDataString(is);
            this.numplayers = StreamUtils.readUnsignedByte(is);
            this.Episode = StreamUtils.readUnsignedByte(is);
            this.Level = StreamUtils.readUnsignedByte(is);
            this.Flags = new int[this.numplayers];
            this.Armors = new int[this.numplayers];
            this.Health = new int[this.numplayers];
            this.MaxHealth = new int[this.numplayers];
            this.WpnFlags = new int[this.numplayers];
            this.WpnRocketHeats = new byte[this.numplayers];
            this.WpnRocketNukes = new byte[this.numplayers];
            this.WpnAmmo = new int[this.numplayers][14];
            this.InventoryPercent = new int[this.numplayers][7];
            this.InventoryAmount = new int[this.numplayers][7];
            this.InventoryNums = new int[this.numplayers];
            for (p = 0; p < this.numplayers; ++p) {
                int i;
                this.Flags[p] = StreamUtils.readInt(is);
                this.Armors[p] = StreamUtils.readInt(is);
                this.Health[p] = StreamUtils.readInt(is);
                this.MaxHealth[p] = StreamUtils.readInt(is);
                this.WpnFlags[p] = StreamUtils.readInt(is);
                this.WpnRocketHeats[p] = StreamUtils.readByte(is);
                this.WpnRocketNukes[p] = StreamUtils.readByte(is);
                for (i = 0; i < 14; ++i) {
                    this.WpnAmmo[p][i] = StreamUtils.readInt(is);
                }
                for (i = 0; i < 7; ++i) {
                    this.InventoryPercent[p][i] = StreamUtils.readInt(is);
                    this.InventoryAmount[p][i] = StreamUtils.readInt(is);
                }
                this.InventoryNums[p] = StreamUtils.readInt(is);
            }
        } else {
            this.mapname = this.mapname + StreamUtils.readString(is, 11);
            this.numplayers = StreamUtils.readUnsignedByte(is);
            this.Episode = StreamUtils.readUnsignedByte(is);
            this.Level = StreamUtils.readUnsignedByte(is);
            this.LevelSong = StreamUtils.readString(is, 16);
            this.Flags = new int[this.numplayers];
            for (p = 0; p < this.numplayers; ++p) {
                StreamUtils.readInt(is);
                StreamUtils.readInt(is);
                StreamUtils.readInt(is);
                this.Flags[p] = StreamUtils.readInt(is);
                StreamUtils.readShort(is);
            }
        }
        this.Skill = StreamUtils.readShort(is);
        this.KillLimit = StreamUtils.readInt(is);
        this.TimeLimit = StreamUtils.readInt(is);
        this.TimeLimitClock = StreamUtils.readInt(is);
        short i = StreamUtils.readShort(is);
        this.MultiGameType = i != -1 ? WangNetwork.MultiGameTypes.values()[i] : null;
        this.TeamPlay = StreamUtils.readBoolean(is);
        this.HurtTeammate = StreamUtils.readBoolean(is);
        this.SpawnMarkers = StreamUtils.readBoolean(is);
        this.AutoAim = StreamUtils.readBoolean(is);
        this.NoRespawn = StreamUtils.readBoolean(is);
        this.Nuke = StreamUtils.readBoolean(is);
        int inputsize = DemoFile.getInputSize(this.nVersion);
        int swpackets = is.available() / (this.numplayers * inputsize);
        this.recsync = new Input[this.numplayers][swpackets];
        int rcnt = 0;
        while (is.available() > 0) {
            for (int p2 = 0; p2 < this.numplayers; ++p2) {
                this.recsync[p2][rcnt] = new Input().readObject(is, this.nVersion);
            }
            ++rcnt;
        }
        this.reccnt = rcnt;
    }

    public static void convertDemo(Path path, InputStream is) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            StreamUtils.writeString(os, StreamUtils.readString(is, 5));
            int ver = StreamUtils.readInt(is);
            StreamUtils.writeInt(os, ver);
            int rcnt = StreamUtils.readInt(is);
            StreamUtils.writeInt(os, rcnt);
            StreamUtils.writeByte(os, 2);
            boolean hasAddon = StreamUtils.readBoolean(is);
            StreamUtils.readDataString(is);
            StreamUtils.writeDataString(os, StreamUtils.readDataString(is));
            int numplayers = StreamUtils.readByte(is);
            StreamUtils.writeByte(os, numplayers);
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            for (int p = 0; p < numplayers; ++p) {
                int i;
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
                StreamUtils.writeByte(os, StreamUtils.readByte(is));
                StreamUtils.writeByte(os, StreamUtils.readByte(is));
                for (i = 0; i < 14; ++i) {
                    StreamUtils.writeInt(os, StreamUtils.readInt(is));
                }
                for (i = 0; i < 7; ++i) {
                    StreamUtils.writeInt(os, StreamUtils.readInt(is));
                    StreamUtils.writeInt(os, StreamUtils.readInt(is));
                }
                StreamUtils.writeInt(os, StreamUtils.readInt(is));
            }
            StreamUtils.writeShort(os, StreamUtils.readShort(is));
            StreamUtils.writeInt(os, StreamUtils.readInt(is));
            StreamUtils.writeInt(os, StreamUtils.readInt(is));
            StreamUtils.writeInt(os, StreamUtils.readInt(is));
            StreamUtils.writeShort(os, StreamUtils.readShort(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            StreamUtils.writeByte(os, StreamUtils.readByte(is));
            int r = 0;
            while (is.available() > 0) {
                for (int p = 0; p < numplayers; ++p) {
                    Input input = new Input().readObject(is, ver);
                    input.writeObject(os, ver);
                }
                ++r;
            }
            System.out.println(r + " " + rcnt);
        }
    }

    public static int getInputSize(int nVersion) {
        return nVersion == 1 ? 12 : 16;
    }

    private GameInfo findAddon(String addonFileName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                return ResourceHandler.episodeManager.getEpisode(addonEntry);
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return null;
    }
}

