/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.CustomScript;
import ru.m210projects.Wang.Type.EpisodeEntry;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LevelInfo;

public class EpisodeManager {
    private final HashMap<String, GameInfo> episodeCache = new HashMap();

    public void putEpisode(GameInfo gameInfo) {
        this.episodeCache.put(this.getHashKey(gameInfo.getEpisodeEntry().getFileEntry()), gameInfo);
    }

    private String getHashKey(FileEntry entry) {
        return entry.getRelativePath().toString().toUpperCase(Locale.ROOT);
    }

    public GameInfo getEpisode(FileEntry entry) {
        GameInfo addon = this.episodeCache.get(this.getHashKey(entry));
        if (addon != null) {
            return addon;
        }
        addon = this.checkOfficialAddon(entry);
        if (addon == null) {
            addon = this.checkCustomAddon(entry);
        }
        if (addon != null) {
            this.episodeCache.put(this.getHashKey(addon.getEpisodeEntry().getFileEntry()), addon);
            if (!Game.defGame.getEpisodeEntry().equals(entry)) {
                Console.out.println("Found addon: " + addon.Title + " ( " + entry.getName() + " )");
            }
        }
        return addon;
    }

    private GameInfo checkCustomAddon(@NotNull FileEntry entry) {
        if (entry == null) {
            EpisodeManager.$$$reportNull$$$0(0);
        }
        CustomScript script = null;
        Directory group = entry.isDirectory() ? entry.getDirectory() : Main.game.cache.newGroup(entry);
        for (Entry file : group.getEntries()) {
            if (!file.getName().toLowerCase(Locale.ROOT).endsWith("custom.txt")) continue;
            script = new CustomScript(file);
        }
        EpisodeInfo[] UnnamedEpisode = null;
        boolean hasFirstEpisode = group.getEntry("$bullet.map").exists();
        boolean hasSecondEpisode = group.getEntry("$whirl.map").exists();
        if (hasFirstEpisode || hasSecondEpisode) {
            int i;
            UnnamedEpisode = new EpisodeInfo[hasSecondEpisode ? 2 : 1];
            int n = i = hasFirstEpisode ? 0 : 4;
            while (i < 29 && (i <= 3 || hasSecondEpisode)) {
                LevelInfo map;
                int epnum;
                int n2 = epnum = i < 4 ? 0 : 1;
                if (UnnamedEpisode[epnum] == null) {
                    UnnamedEpisode[epnum] = new EpisodeInfo();
                    UnnamedEpisode[epnum].Title = "Episode " + epnum;
                    UnnamedEpisode[epnum].Description = "No description";
                }
                EpisodeInfo ep = UnnamedEpisode[epnum];
                LevelInfo levelInfo = map = epnum == 0 ? Game.pSharewareEp.gMapInfo[i] : Game.pOriginalEp.gMapInfo[i - 4];
                if (map != null && group.getEntry(map.LevelName).exists()) {
                    ep.gMapInfo[epnum == 0 ? i : i - 4] = new LevelInfo(map.LevelName, map.SongName, "Map" + (i + 1), map.BestTime, map.ParTime);
                    ++ep.nMaps;
                }
                ++i;
            }
        }
        if (script != null || UnnamedEpisode != null) {
            GameInfo addon = new GameInfo(group.getName(), new EpisodeEntry.Addon(group, entry), UnnamedEpisode);
            if (script != null) {
                script.apply(addon);
                if (UnnamedEpisode == null) {
                    for (int i = 0; i < 29; ++i) {
                        Entry mapEntry = group.getEntry(addon.getMapPath(i));
                        if (!mapEntry.exists()) continue;
                        return addon;
                    }
                    return null;
                }
            }
            return addon;
        }
        return null;
    }

    private GameInfo checkOfficialAddon(@NotNull FileEntry entry) {
        long crc32;
        EpisodeInfo episodeInfo;
        if (entry == null) {
            EpisodeManager.$$$reportNull$$$0(1);
        }
        HashMap<Long, EpisodeInfo> officialAddons = new HashMap<Long, EpisodeInfo>(){
            {
                this.put(1488316004L, Game.pWantonEp);
                this.put(1830650101L, Game.pTwinDragonEp);
            }
        };
        Group group = entry.isDirectory() ? entry.getDirectory() : Main.game.cache.newGroup(entry);
        Entry logoFile = group.getEntry("zfcin.anm");
        if (logoFile.exists() && (episodeInfo = (EpisodeInfo)officialAddons.get(crc32 = logoFile.getChecksum())) != null) {
            return new GameInfo(episodeInfo.Title, new EpisodeEntry.Addon(group, entry), null, episodeInfo);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "entry";
        objectArray2[1] = "ru/m210projects/Wang/Type/EpisodeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCustomAddon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOfficialAddon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

