/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Input
implements BuildNet.NetInput {
    public int bits;
    public float angvel;
    public float aimvel;
    public int vel;
    public int svel;

    public Input readObject(InputStream is, int nVersion) throws IOException {
        this.vel = StreamUtils.readShort(is);
        this.svel = StreamUtils.readShort(is);
        if (nVersion == 1) {
            this.angvel = StreamUtils.readUnsignedByte(is);
            this.aimvel = StreamUtils.readUnsignedByte(is);
            StreamUtils.readShort(is);
        } else {
            this.angvel = StreamUtils.readFloat(is);
            this.aimvel = StreamUtils.readFloat(is);
        }
        this.bits = StreamUtils.readInt(is);
        return this;
    }

    public void writeObject(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeShort(os, this.vel);
        StreamUtils.writeShort(os, this.svel);
        if (nVersion == 1) {
            StreamUtils.writeByte(os, (byte)this.angvel);
            StreamUtils.writeByte(os, (byte)this.aimvel);
            StreamUtils.writeShort(os, 0);
        } else {
            StreamUtils.writeFloat(os, this.angvel);
            StreamUtils.writeFloat(os, this.aimvel);
        }
        StreamUtils.writeInt(os, this.bits);
    }

    @Override
    public int GetInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int k = packbuf[offset++] & 0xFF;
        this.Copy(oldInput);
        if ((k & 1) != 0) {
            this.vel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 2) != 0) {
            this.svel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 4) != 0) {
            this.angvel = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        if ((k & 8) != 0) {
            this.bits = this.bits & 0xFFFFFF00 | packbuf[offset++] & 0xFF;
        }
        if ((k & 0x10) != 0) {
            this.bits = this.bits & 0xFFFF00FF | (packbuf[offset++] & 0xFF) << 8;
        }
        if ((k & 0x20) != 0) {
            this.bits = this.bits & 0xFF00FFFF | (packbuf[offset++] & 0xFF) << 16;
        }
        if ((k & 0x40) != 0) {
            this.bits = this.bits & 0xFFFFFF | (packbuf[offset++] & 0xFF) << 24;
        }
        if ((k & 0x80) != 0) {
            this.aimvel = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        return offset;
    }

    @Override
    public int PutInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int syncptr = offset;
        packbuf[offset++] = 0;
        Input osyn = (Input)oldInput;
        if (this.vel != osyn.vel) {
            LittleEndian.putShort(packbuf, offset, (short)this.vel);
            offset += 2;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 1);
        }
        if (this.svel != osyn.svel) {
            LittleEndian.putShort(packbuf, offset, (short)this.svel);
            offset += 2;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 2);
        }
        if (this.angvel != osyn.angvel) {
            LittleEndian.putFloat(packbuf, offset, this.angvel);
            offset += 4;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 4);
        }
        if (((this.bits ^ osyn.bits) & 0xFF) != 0) {
            packbuf[offset++] = (byte)(this.bits & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 8);
        }
        if (((this.bits ^ osyn.bits) & 0xFF00) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 8 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x10);
        }
        if (((this.bits ^ osyn.bits) & 0xFF0000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 16 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x20);
        }
        if (((this.bits ^ osyn.bits) & 0xFF000000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 24 & 0xFF);
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0x40);
        }
        if (this.aimvel != osyn.aimvel) {
            LittleEndian.putFloat(packbuf, offset, this.aimvel);
            offset += 4;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 0xFFFFFF80);
        }
        return offset;
    }

    @Override
    public void reset() {
        this.vel = 0;
        this.svel = 0;
        this.angvel = 0.0f;
        this.bits = 0;
        this.aimvel = 0.0f;
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput netsrc) {
        if (netsrc == null) {
            return null;
        }
        Input src = (Input)netsrc;
        this.vel = src.vel;
        this.svel = src.svel;
        this.angvel = src.angvel;
        this.bits = src.bits;
        this.aimvel = src.aimvel;
        return this;
    }
}

