/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.util.List;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Digi;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.EpisodeEntry;
import ru.m210projects.Wang.Type.EpisodeManager;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.VOC_INFO;
import ru.m210projects.Wang.Type.VoxelScript;

public class ResourceHandler {
    public static final EpisodeManager episodeManager = new EpisodeManager();
    public static boolean usecustomarts;
    private static GrpFile usergroup;

    public static void resetEpisodeResources() {
        Console.out.println("Resetting custom resources", OsdColor.GREEN);
        if (usergroup != null) {
            Main.game.getCache().removeGroup(usergroup);
        }
        usergroup = null;
        Game.currentGame = Game.defGame;
        for (VOC_INFO vocInfo : Digi.voc) {
            vocInfo.data = null;
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        if (Main.engine.loadpics() == 0) {
            throw new AssertException("ART files not found " + Main.game.getCache().getGameDirectory().getPath().resolve(Main.engine.getTileManager().getTilesPath()));
        }
        if (!Main.game.setDefs(Main.game.baseDef)) {
            Main.game.baseDef.apply();
        }
        ResourceHandler.InitSpecialTextures();
        usecustomarts = false;
    }

    public static void InitSpecialTextures() {
        Main.engine.allocatepermanenttile(340, 0, 0);
        for (int i = 0; i < 8; ++i) {
            Main.engine.allocatepermanenttile(i + 6000, 0, 0);
        }
    }

    public static void InitGroupResources(DefScript addonScript, List<Entry> list) {
        for (Entry res : list) {
            switch (res.getExtension()) {
                case "ART": {
                    Main.engine.loadpic(res);
                    usecustomarts = true;
                    break;
                }
                case "DEF": {
                    if (res.getName().equalsIgnoreCase("swgdx.def")) break;
                    addonScript.loadScript(res.getName() + " script", res);
                    Console.out.println("Found def-script. Loading " + res.getName());
                    break;
                }
                case "TXT": {
                    if (!res.getName().equalsIgnoreCase("swvoxfil.txt")) break;
                    VoxelScript vox = new VoxelScript(res);
                    vox.apply(addonScript);
                    Console.out.println("Found swvoxfil.txt. Loading... ");
                }
            }
        }
    }

    private static void searchEpisodeResources(Group container, GrpFile resourceHolder) {
        for (Entry file : container.getEntries()) {
            Group subContainer = Directory.DUMMY_DIRECTORY;
            if (file.isDirectory() && file instanceof FileEntry) {
                subContainer = ((FileEntry)file).getDirectory();
            } else if (file.isExtension("zip") || file.isExtension("pk3") || file.isExtension("grp") || file.isExtension("rff")) {
                subContainer = Main.game.getCache().newGroup(file);
            }
            if (!((Object)subContainer).equals(Directory.DUMMY_DIRECTORY)) {
                ResourceHandler.searchEpisodeResources(subContainer, resourceHolder);
                continue;
            }
            resourceHolder.addEntry(file);
        }
    }

    public static void checkEpisodeResources(GameInfo addon) {
        DefScript addonScript;
        if (addon == null) {
            return;
        }
        if (addon.equals(Game.currentGame)) {
            return;
        }
        ResourceHandler.resetEpisodeResources();
        usergroup = new GrpFile("RemovableGroup");
        EpisodeEntry addonEntry = addon.getEpisodeEntry();
        Group parent = addonEntry.getGroup();
        if (addonEntry.isPackageEpisode()) {
            addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
            try {
                Entry res = parent.getEntry("swgdx.def");
                if (res.exists()) {
                    addonScript.loadScript(parent.getName() + " script", res);
                }
                ResourceHandler.searchEpisodeResources(parent, usergroup);
            }
            catch (Exception e) {
                throw new WarningException("Error found in " + ((EpisodeEntry.Addon)addonEntry).getName() + "\r\n" + e.getMessage());
            }
        } else {
            addonScript = new DefScript(Main.game.baseDef, addonEntry.getFileEntry());
            if (!Main.game.getCache().isGameDirectory(parent)) {
                ResourceHandler.searchEpisodeResources(parent, usergroup);
                Entry def = parent.getEntry("swgdx.def");
                if (def.exists()) {
                    addonScript.loadScript(def);
                }
            }
        }
        Main.game.getCache().addGroup(usergroup, CacheResourceMap.CachePriority.HIGHEST);
        ResourceHandler.InitGroupResources(addonScript, usergroup.getEntries());
        Game.currentGame = addon;
        Main.game.setDefs(addonScript);
    }

    public static GameInfo levelGetEpisode(Entry entry) {
        if (entry == null || !entry.exists()) {
            return null;
        }
        if (entry instanceof FileEntry) {
            return episodeManager.getEpisode((FileEntry)entry);
        }
        return null;
    }
}

