/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.Types.collections.DynamicArray;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Factory.WangSprite;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.MirrorType;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.SINE_WALL;
import ru.m210projects.Wang.Type.SINE_WAVE_FLOOR;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.Spring_Board;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Type.USER;

public class SafeLoader {
    public int Level;
    public int Skill;
    public Entry boardfilename;
    public int numsectors;
    public Sector[] sector;
    public Wall[] wall;
    public List<Sprite> sprite;
    public int playTrack;
    public int FinishTimer;
    public boolean FinishedLevel;
    public int FinishAnim;
    public final PlayerStr[] Player = new PlayerStr[8];
    public short connecthead;
    public final short[] connectpoint2 = new short[16];
    public short numplayers;
    public int CommPlayers;
    public short myconnectindex;
    public final Array<Sect_User> SectUser = new DynamicArray<Sect_User>(1024, Sect_User.class, false);
    public final Array<USER> pUser = new DynamicArray<USER>(4096, USER.class, false);
    public final Sector_Object[] SectorObject = new Sector_Object[25];
    public final SINE_WAVE_FLOOR[][] SineWaveFloor = new SINE_WAVE_FLOOR[6][21];
    public final SINE_WALL[][] SineWall = new SINE_WALL[10][64];
    public final Spring_Board[] SpringBoard = new Spring_Board[20];
    public int x_min_bound;
    public int y_min_bound;
    public int x_max_bound;
    public int y_max_bound;
    public final TRACK[] Track = new TRACK[100];
    public int screenpeek;
    public int totalsynctics;
    public final Anim[] pAnim = new Anim[256];
    public int AnimCnt;
    public final short[] pskyoff = new short[256];
    public short pskybits;
    public int randomseed;
    public int totalclock;
    public int visibility;
    public short NormalVisibility;
    public int parallaxyoffs;
    public byte parallaxtype;
    public boolean MoveSkip2;
    public int MoveSkip4;
    public int MoveSkip8;
    public final MirrorType[] mirror = new MirrorType[8];
    public boolean mirrorinview;
    public int mirrorcnt;
    public int StarQueueHead = 0;
    public final IntArray StarQueue = new IntArray(32);
    public int HoleQueueHead = 0;
    public final IntArray HoleQueue = new IntArray(64);
    public int WallBloodQueueHead = 0;
    public final IntArray WallBloodQueue = new IntArray(32);
    public int FloorBloodQueueHead = 0;
    public final IntArray FloorBloodQueue = new IntArray(32);
    public int GenericQueueHead = 0;
    public final IntArray GenericQueue = new IntArray(32);
    public int LoWangsQueueHead = 0;
    public final IntArray LoWangsQueue = new IntArray(16);
    public int PlayClock;
    public int Kills;
    public int TotalKillable;
    public short LevelSecrets;
    public final int[] picanm = new int[Engine.MAXTILES];
    public final BitMap show2dsector = new BitMap(1024);
    public final BitMap show2dwall = new BitMap(8192);
    public final BitMap show2dsprite = new BitMap(4096);
    public int Bunny_Count;
    public boolean GodMode;
    public boolean serpwasseen;
    public boolean sumowasseen;
    public boolean zillawasseen;
    public final IntArray BossSpriteNum = new IntArray(3);
    public int TimeLimit;
    public int TimeLimitClock;
    public WangNetwork.MultiGameTypes MultiGameType = WangNetwork.MultiGameTypes.MULTI_GAME_NONE;
    public boolean TeamPlay;
    public boolean HurtTeammate;
    public boolean SpawnMarkers;
    public boolean NoRespawn;
    public boolean Nuke = true;
    public GameInfo addon;
    public byte warp_on;
    public String addonFileName;
    private String message;

    public SafeLoader() {
        int j;
        int i;
        for (i = 0; i < 256; ++i) {
            this.pAnim[i] = new Anim();
        }
        for (i = 0; i < 8; ++i) {
            this.Player[i] = new PlayerStr();
        }
        for (i = 0; i < 25; ++i) {
            this.SectorObject[i] = new Sector_Object();
        }
        for (i = 0; i < 20; ++i) {
            this.SpringBoard[i] = new Spring_Board();
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 64; ++j) {
                this.SineWall[i][j] = new SINE_WALL();
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 21; ++j) {
                this.SineWaveFloor[i][j] = new SINE_WAVE_FLOOR();
            }
        }
    }

    public boolean load(InputStream is) throws IOException {
        this.message = null;
        this.addon = this.LoadGDXHeader(is);
        this.pUser.clear();
        this.SectUser.clear();
        this.StarQueue.clear();
        this.HoleQueue.clear();
        this.WallBloodQueue.clear();
        this.FloorBloodQueue.clear();
        this.GenericQueue.clear();
        this.LoWangsQueue.clear();
        this.LoadMap(is);
        this.LoadPlayers(is);
        this.LoadSectorUserInfos(is);
        this.LoadUserInfos(is);
        this.LoadSectorObjects(is);
        this.LoadSineSect(is);
        this.x_min_bound = StreamUtils.readInt(is);
        this.y_min_bound = StreamUtils.readInt(is);
        this.x_max_bound = StreamUtils.readInt(is);
        this.y_max_bound = StreamUtils.readInt(is);
        this.LoadTracks(is);
        this.screenpeek = StreamUtils.readInt(is);
        this.totalsynctics = StreamUtils.readInt(is);
        this.LoadAnims(is);
        this.totalclock = StreamUtils.readInt(is);
        this.randomseed = StreamUtils.readInt(is);
        this.NormalVisibility = StreamUtils.readShort(is);
        this.visibility = StreamUtils.readInt(is);
        this.parallaxtype = StreamUtils.readByte(is);
        this.parallaxyoffs = StreamUtils.readInt(is);
        for (int i = 0; i < this.pskyoff.length; ++i) {
            this.pskyoff[i] = StreamUtils.readShort(is);
        }
        this.pskybits = StreamUtils.readShort(is);
        this.MoveSkip2 = StreamUtils.readBoolean(is);
        this.MoveSkip4 = StreamUtils.readInt(is);
        this.MoveSkip8 = StreamUtils.readInt(is);
        this.LoadMirrors(is);
        this.LoadQueues(is);
        this.LoadStuff(is);
        if (this.warp_on == 1 && this.addon == null) {
            this.message = "Can't find user episode file: " + this.addonFileName;
            this.warp_on = (byte)2;
            this.Level = 0;
        }
        System.out.println(is.available());
        return is.available() == 0;
    }

    public String getMessage() {
        return this.message;
    }

    public GameInfo LoadGDXHeader(InputStream is) {
        this.Level = -1;
        this.Skill = -1;
        this.warp_on = 0;
        this.addon = null;
        this.addonFileName = null;
        try {
            StreamUtils.skip(is, 40);
            this.Level = StreamUtils.readInt(is);
            this.Skill = StreamUtils.readInt(is);
            StreamUtils.skip(is, 16000);
            this.LoadUserEpisodeInfo(is);
            if (this.warp_on == 1) {
                this.addon = SafeLoader.findAddon(this.addonFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }

    public void LoadUserEpisodeInfo(InputStream is) throws IOException {
        this.warp_on = StreamUtils.readByte(is);
        if (this.warp_on == 1) {
            StreamUtils.readBoolean(is);
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
        }
    }

    private void LoadPlayers(InputStream is) throws IOException {
        int i;
        this.numplayers = StreamUtils.readShort(is);
        this.CommPlayers = StreamUtils.readShort(is);
        this.myconnectindex = StreamUtils.readShort(is);
        this.connecthead = StreamUtils.readShort(is);
        for (i = 0; i < this.connectpoint2.length; ++i) {
            this.connectpoint2[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < this.numplayers; ++i) {
            this.Player[i].readObject(is);
        }
    }

    private void LoadMap(InputStream is) throws IOException {
        int i;
        this.boardfilename = Directory.DUMMY_ENTRY;
        String name = StreamUtils.readString(is, 144);
        if (!name.isEmpty()) {
            this.boardfilename = Main.game.getCache().getEntry(name, true);
        }
        this.numsectors = StreamUtils.readInt(is);
        this.sector = new Sector[this.numsectors];
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new Sector().readObject(is);
        }
        this.wall = new Wall[StreamUtils.readInt(is)];
        for (i = 0; i < this.wall.length; ++i) {
            this.wall[i] = new Wall().readObject(is);
        }
        int numSprites = StreamUtils.readInt(is);
        this.sprite = new ArrayList<Sprite>(numSprites * 2);
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.sprite.add(new WangSprite().readObject(is));
        }
        this.FinishTimer = StreamUtils.readInt(is);
        this.FinishedLevel = StreamUtils.readBoolean(is);
        this.FinishAnim = StreamUtils.readInt(is);
        this.playTrack = StreamUtils.readInt(is);
    }

    private void LoadSectorUserInfos(InputStream is) throws IOException {
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            int sectnum = StreamUtils.readInt(is);
            if (sectnum == -1) continue;
            Sect_User pSectUser = new Sect_User();
            pSectUser.readObject(is);
            this.SectUser.set(sectnum, pSectUser);
        }
    }

    private void LoadUserInfos(InputStream is) throws IOException {
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            int snum = StreamUtils.readInt(is);
            if (snum == -1) continue;
            USER user = new USER();
            user.readObject(is);
            this.pUser.set(snum, user);
        }
    }

    private void LoadSectorObjects(InputStream is) throws IOException {
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            this.SectorObject[i].readObject(is);
        }
    }

    private void LoadSineSect(InputStream is) throws IOException {
        int j;
        int i;
        int len = StreamUtils.readInt(is);
        int len2 = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len2; ++j) {
                this.SineWaveFloor[i][j].load(is);
            }
        }
        len = StreamUtils.readInt(is);
        len2 = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len2; ++j) {
                this.SineWall[i][j].load(is);
            }
        }
        len = StreamUtils.readInt(is);
        for (i = 0; i < len; ++i) {
            this.SpringBoard[i].load(is);
        }
    }

    private void LoadTracks(InputStream is) throws IOException {
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            this.Track[i] = new TRACK();
            TRACK tr = this.Track[i];
            tr.ttflags = StreamUtils.readInt(is);
            tr.flags = StreamUtils.readShort(is);
            tr.NumPoints = StreamUtils.readShort(is);
            if (tr.NumPoints == 0) {
                tr.TrackPoint = new TRACK_POINT[1];
                continue;
            }
            tr.TrackPoint = new TRACK_POINT[tr.NumPoints];
            for (int j = 0; j < tr.NumPoints; ++j) {
                TRACK_POINT tp = tr.TrackPoint[j] = new TRACK_POINT();
                tp.x = StreamUtils.readInt(is);
                tp.y = StreamUtils.readInt(is);
                tp.z = StreamUtils.readInt(is);
                tp.ang = StreamUtils.readShort(is);
                tp.tag_low = StreamUtils.readShort(is);
                tp.tag_high = StreamUtils.readShort(is);
            }
        }
    }

    private void LoadAnims(InputStream is) throws IOException {
        this.AnimCnt = StreamUtils.readInt(is);
        for (int i = 0; i < this.AnimCnt; ++i) {
            this.pAnim[i].load(is);
        }
    }

    private void LoadMirrors(InputStream is) throws IOException {
        this.mirrorcnt = StreamUtils.readInt(is);
        this.mirrorinview = StreamUtils.readBoolean(is);
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            this.mirror[i] = new MirrorType();
            this.mirror[i].load(is);
        }
    }

    private void LoadQueues(InputStream is) throws IOException {
        this.StarQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.StarQueue);
        this.HoleQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.HoleQueue);
        this.WallBloodQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.WallBloodQueue);
        this.FloorBloodQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.FloorBloodQueue);
        this.GenericQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.GenericQueue);
        this.LoWangsQueueHead = StreamUtils.readInt(is);
        SafeLoader.readBytes(is, this.LoWangsQueue);
    }

    private void LoadStuff(InputStream is) throws IOException {
        this.PlayClock = StreamUtils.readInt(is);
        this.Kills = StreamUtils.readInt(is);
        this.TotalKillable = StreamUtils.readInt(is);
        StreamUtils.readInt(is);
        this.TimeLimit = StreamUtils.readInt(is);
        this.TimeLimitClock = StreamUtils.readInt(is);
        int i = StreamUtils.readUnsignedByte(is);
        this.MultiGameType = i != -1 ? WangNetwork.MultiGameTypes.values()[i] : null;
        this.TeamPlay = StreamUtils.readBoolean(is);
        this.HurtTeammate = StreamUtils.readBoolean(is);
        this.SpawnMarkers = StreamUtils.readBoolean(is);
        this.NoRespawn = StreamUtils.readBoolean(is);
        this.Nuke = StreamUtils.readBoolean(is);
        for (i = 0; i < Engine.MAXTILES; ++i) {
            this.picanm[i] = StreamUtils.readInt(is);
        }
        this.LevelSecrets = StreamUtils.readShort(is);
        this.show2dsector.readObject(is);
        this.show2dwall.readObject(is);
        this.show2dsprite.readObject(is);
        this.Bunny_Count = StreamUtils.readInt(is);
        this.GodMode = StreamUtils.readBoolean(is);
        this.serpwasseen = StreamUtils.readBoolean(is);
        this.sumowasseen = StreamUtils.readBoolean(is);
        this.zillawasseen = StreamUtils.readBoolean(is);
        SafeLoader.readBytes(is, this.BossSpriteNum);
    }

    private static void readBytes(InputStream is, IntArray array) throws IOException {
        array.clear();
        int len = StreamUtils.readInt(is);
        for (int i = 0; i < len; ++i) {
            array.add(StreamUtils.readInt(is));
        }
    }

    public static GameInfo findAddon(String addonFileName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                return ResourceHandler.episodeManager.getEpisode(addonEntry);
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return null;
    }
}

