/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;

public class AIGoblin {
    public static final AIState goblinChill = new AIState(){

        @Override
        public void process(PLAYER plr, int i) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                Main.engine.deletesprite(i);
                return;
            }
            spr.setLotag(spr.getLotag() - 3);
            if (spr.getLotag() < 0) {
                spr.setPicnum(spr.getPicnum() + 1);
                spr.setLotag(18);
                if (spr.getPicnum() == 951) {
                    spr.setPicnum(922);
                    WHOBJ.newstatus(i, 109);
                }
            }
        }
    };
    public static final AIState goblinWar = new AIState(){

        @Override
        public void process(PLAYER plr, int i) {
            Sprite spr = Main.boardService.getSprite(i);
            if (spr == null) {
                Main.engine.deletesprite(i);
                return;
            }
            if (spr.getLotag() > 256) {
                spr.setLotag(100);
                spr.setExtra(0);
            }
            switch (spr.getExtra()) {
                case 0: {
                    long olddist = 16384L;
                    boolean found = false;
                    for (int k = 0; k < Engine.MAXSPRITES; ++k) {
                        long dist;
                        Sprite spr2 = Main.boardService.getSprite(k);
                        if (spr2 == null || spr2.getPicnum() != 922 || spr.getPal() == spr2.getPal() || spr.getHitag() != spr2.getHitag() || (dist = (long)(Pragmas.klabs(spr.getX() - spr2.getX()) + Pragmas.klabs(spr.getY() - spr2.getY()))) >= olddist) continue;
                        found = true;
                        olddist = dist;
                        spr.setOwner(k);
                        spr.setAng(EngineUtils.getAngle(spr2.getX() - spr.getX(), spr2.getY() - spr.getY()));
                        spr.setExtra(1);
                    }
                    if (found) break;
                    if (spr.getPal() == 5) {
                        spr.setHitag(WHOBJ.adjusthp(35));
                    } else if (spr.getPal() == 4) {
                        spr.setHitag(WHOBJ.adjusthp(25));
                    } else {
                        spr.setHitag(WHOBJ.adjusthp(15));
                    }
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                        break;
                    }
                    WHOBJ.newstatus(i, 109);
                    break;
                }
                case 1: {
                    short k = spr.getOwner();
                    Sprite ownerSpr = Main.boardService.getSprite(k);
                    if (ownerSpr == null) break;
                    int movehit = Ai.aimove(i);
                    if (movehit == 0) {
                        spr.setAng(EngineUtils.getAngle(ownerSpr.getX() - spr.getX(), ownerSpr.getY() - spr.getY()));
                    } else if ((movehit & 0xE0000000) == Integer.MIN_VALUE) {
                        spr.setExtra(3);
                        spr.setAng((short)(spr.getAng() + (Main.engine.krand() & 0x80) & 0x7FF));
                        spr.setLotag(60);
                    } else if ((movehit & 0xE0000000) == -1073741824) {
                        int sprnum = movehit & 0x1FFFFFFF;
                        if (sprnum != k) {
                            spr.setExtra(3);
                            spr.setAng((short)(spr.getAng() + (Main.engine.krand() & 0x80) & 0x7FF));
                            spr.setLotag(60);
                        } else {
                            spr.setAng(EngineUtils.getAngle(ownerSpr.getX() - spr.getX(), ownerSpr.getY() - spr.getY()));
                        }
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                    if (Ai.checkdist(i, ownerSpr.getX(), ownerSpr.getY(), ownerSpr.getZ())) {
                        spr.setExtra(2);
                    } else {
                        spr.setPicnum(922);
                    }
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 2: {
                    short k = spr.getOwner();
                    Sprite ownerSpr = Main.boardService.getSprite(k);
                    if (ownerSpr == null) break;
                    if (Ai.checkdist(i, ownerSpr.getX(), ownerSpr.getY(), ownerSpr.getZ())) {
                        if ((Main.engine.krand() & 1) != 0) {
                            if (Main.engine.krand() % 10 > 6) {
                                WHSND.playsound_loc(WHSND.S_GENSWING, spr.getX(), spr.getY());
                            }
                            if (Main.engine.krand() % 10 > 6) {
                                WHSND.playsound_loc(WHSND.S_SWORD1 + Main.engine.krand() % 6, spr.getX(), spr.getY());
                            }
                            if (Ai.checkdist(plr, i)) {
                                WHPLR.addhealth(plr, -(Main.engine.krand() & 5));
                            }
                            if (Main.engine.krand() % 100 > 90) {
                                spr.setExtra(0);
                                spr.setPicnum(922);
                                ownerSpr.setExtra(4);
                                ownerSpr.setPicnum(968);
                                ownerSpr.setLotag(20);
                                ownerSpr.setHitag(0);
                                WHOBJ.newstatus(k, 107);
                            } else {
                                spr.setExtra(0);
                                ownerSpr.setExtra(3);
                                ownerSpr.setAng((short)(spr.getAng() + (Main.engine.krand() & 0x80) & 0x7FF));
                                ownerSpr.setLotag(60);
                            }
                        }
                    } else {
                        spr.setExtra(1);
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 3: {
                    spr.setLotag(spr.getLotag() - 3);
                    if (Ai.aimove(i) != 0) {
                        spr.setAng((short)(Main.engine.krand() & 0x7FF));
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                    if (spr.getLotag() < 0) {
                        spr.setLotag(0);
                        spr.setExtra(0);
                    }
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 4: {
                    spr.setPicnum(968);
                    break;
                }
            }
            AIGoblin.checkexpl(plr, i);
        }
    };

    public static void create() {
        Ai.enemy[7] = new Enemy();
        Ai.enemy[7].info = new EnemyInfo(36, 36, 1024, 120, 0, 64, false, 15, 0){

            @Override
            public short getHealth(Sprite spr) {
                if (spr.getPal() == 5) {
                    return WHOBJ.adjusthp(35);
                }
                if (spr.getPal() == 4) {
                    return WHOBJ.adjusthp(25);
                }
                return WHOBJ.adjusthp(this.health);
            }
        };
        Ai.enemy[7].chase = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                short osectnum;
                Sector osec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setLotag(250);
                }
                if ((osec = Main.boardService.getSector(osectnum = spr.getSectnum())) == null) {
                    return;
                }
                if (Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                    if (Ai.checkdist(plr, i)) {
                        if (plr.getShadowtime() > 0) {
                            spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                            WHOBJ.newstatus(i, 122);
                        } else {
                            WHOBJ.newstatus(i, 6);
                        }
                    } else if (Main.engine.krand() % 63 > 60) {
                        spr.setAng((short)((Main.engine.krand() & 0xFFFFFF80) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        int movestat = Ai.aimove(i);
                        if ((movestat & 0xE0000000) == 0x40000000) {
                            spr.setAng((short)(spr.getAng() + 1024 & 0x7FF));
                            WHOBJ.newstatus(i, 122);
                            return;
                        }
                        if ((movestat & 0xE0000000) == -1073741824) {
                            if ((movestat & 0x1FFFFFFF) != plr.getSpritenum()) {
                                short daang = (short)(spr.getAng() - 256 & 0x7FF);
                                spr.setAng(daang);
                                if (plr.getShadowtime() > 0) {
                                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                                    WHOBJ.newstatus(i, 122);
                                } else {
                                    WHOBJ.newstatus(i, 128);
                                }
                            } else {
                                spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                                WHOBJ.newstatus(i, 128);
                            }
                        }
                    }
                } else {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                    WHOBJ.newstatus(i, 122);
                }
                Sector sec = Main.boardService.getSector(spr.getSectnum());
                if (sec == null) {
                    return;
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                if (osec.getLotag() == 4444) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                sec = Main.boardService.getSector(spr.getSectnum());
                if (sec == null) {
                    return;
                }
                if ((Engine.zr_florhit & 0xE0000000) == 0x40000000 && (sec.getFloorpicnum() == 79 || sec.getFloorpicnum() == 62 || sec.getFloorpicnum() == 61)) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].die = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() <= 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(20);
                    if (spr.getPicnum() == 977) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
        Ai.enemy[7].pain = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(922);
                    spr.setAng((short)plr.getAng());
                    WHOBJ.newstatus(i, 122);
                }
                Ai.aimove(i);
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].face = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                boolean cansee = Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum());
                if (cansee && plr.getInvisibletime() < 0) {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                    spr.setPicnum(922);
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.setOwner(plr.getSpritenum());
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.getOwner() == plr.getSpritenum()) {
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() & 0x7FF));
                    WHOBJ.newstatus(i, 142);
                } else if (cansee) {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(plr, i)) {
                    WHOBJ.newstatus(i, 6);
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].flee = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                short osectnum = spr.getSectnum();
                Sector osec = Main.boardService.getSector(osectnum);
                if (osec == null) {
                    return;
                }
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE0000000) != 0x40000000 && movestat != 0) {
                    if ((movestat & 0xE0000000) == Integer.MIN_VALUE) {
                        Wall wal = Main.boardService.getWall(movestat & 0x1FFFFFFF);
                        if (wal != null) {
                            int nx = -(wal.getWall2().getY() - wal.getY()) >> 4;
                            int ny = wal.getWall2().getX() - wal.getX() >> 4;
                            spr.setAng(EngineUtils.getAngle(nx, ny));
                        }
                    } else {
                        spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].stand = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                if (EngineUtils.sin(spr.getAng() + 2560 & 0x7FF) * (plr.getX() - spr.getX()) + EngineUtils.sin(spr.getAng() + 2048 & 0x7FF) * (plr.getY() - spr.getY()) >= 0 && Main.engine.cansee(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), spr.getX(), spr.getY(), spr.getZ() - (Main.engine.getTile(spr.getPicnum()).getHeight() << 7), spr.getSectnum()) && plr.getInvisibletime() < 0) {
                    if (spr.getPicnum() == 942) {
                        spr.setPicnum(946);
                        WHSND.playsound_loc(18 + Main.engine.krand() % 2, spr.getX(), spr.getY());
                        WHOBJ.newstatus(i, 127);
                    } else {
                        spr.setPicnum(922);
                        if (plr.getShadowtime() > 0) {
                            spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                            WHOBJ.newstatus(i, 122);
                        } else {
                            WHOBJ.newstatus(i, 2);
                        }
                    }
                }
                Ai.checksector6(i);
            }
        };
        Ai.enemy[7].attack = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                Main.engine.getzrange(spr.getX(), spr.getY(), spr.getZ() - 1, spr.getSectnum(), spr.getClipdist() << 2, 65537);
                spr.setZ(Engine.zr_florz);
                switch (Ai.checkfluid(i, Engine.zr_florhit)) {
                    case 2: {
                        spr.setHitag(spr.getHitag() - 1);
                        if (spr.getHitag() < 0) {
                            WHOBJ.newstatus(i, 107);
                        }
                    }
                    case 1: {
                        spr.setZ(spr.getZ() + (Main.engine.getTile(spr.getPicnum()).getHeight() << 5));
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                if (spr.getLotag() == 31) {
                    if (Ai.checksight(plr, i) && Ai.checkdist(plr, i)) {
                        spr.setAng((short)Ai.checksight_ang);
                        Ai.attack(plr, i);
                    }
                } else if (spr.getLotag() < 0) {
                    spr.setPicnum(922);
                    if (plr.getShadowtime() > 0) {
                        spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                        WHOBJ.newstatus(i, 122);
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                }
                spr.setLotag(spr.getLotag() - 3);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[7].resurrect = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                    spr.setPicnum(922);
                    spr.setHitag(WHOBJ.adjusthp(35));
                    spr.setLotag(100);
                    spr.setCstat(spr.getCstat() | 1);
                }
            }
        };
        Ai.enemy[7].search = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Ai.aisearch(plr, i, false);
                if (!Ai.checksector6(i)) {
                    AIGoblin.checkexpl(plr, i);
                }
            }
        };
        Ai.enemy[7].frozen = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPal(0);
                    spr.setPicnum(922);
                    WHOBJ.newstatus(i, 109);
                }
            }
        };
        Ai.enemy[7].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    spr.setPicnum(spr.getPicnum() + 1);
                    spr.setLotag(24);
                    if (spr.getPicnum() == 2457) {
                        WHOBJ.trailingsmoke(i, false);
                        Main.engine.deletesprite(i);
                    }
                }
            }
        };
        Ai.enemy[7].skirmish = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                short osectnum;
                Sector osec;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                if (spr.getLotag() < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if ((osec = Main.boardService.getSector(osectnum = spr.getSectnum())) == null) {
                    return;
                }
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE0000000) != 0x40000000 && movestat != 0) {
                    spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) == null) {
                    return;
                }
                if (spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
                if (Ai.checksector6(i)) {
                    return;
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
    }

    public static void goblinWarProcess(PLAYER plr) {
        ListNode<Sprite> node = Main.boardService.getStatNode(132);
        while (node != null) {
            ListNode<Sprite> next = node.getNext();
            Sprite spr = node.get();
            if (spr.getDetail() == 7) {
                goblinWar.process(plr, node.getIndex());
            }
            node = next;
        }
    }

    public static void checkexpl(PLAYER ignoredPlr, int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        ListNode<Sprite> sectNode = Main.boardService.getSectNode(spr.getSectnum());
        while (sectNode != null) {
            ListNode<Sprite> next = sectNode.getNext();
            Sprite secSprite = sectNode.get();
            long dx = Pragmas.klabs(spr.getX() - secSprite.getX());
            long dy = Pragmas.klabs(spr.getY() - secSprite.getY());
            long dz = Pragmas.klabs((spr.getZ() >> 8) - (secSprite.getZ() >> 8));
            long dh = Main.engine.getTile(secSprite.getPicnum()).getHeight() >> 1;
            if (dx + dy < 512L && dz - dh <= (long)WHOBJ.getPickHeight() && (secSprite.getPicnum() == Names.EXPLO2 || secSprite.getPicnum() == Names.SMOKEFX || secSprite.getPicnum() == 660)) {
                spr.setHitag(spr.getHitag() - 12);
                if (spr.getHitag() < 0) {
                    WHOBJ.newstatus(i, 107);
                }
            }
            sectNode = next;
        }
    }

    public static void premap(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        spr.setDetail(7);
        if (spr.getHitag() >= 90 && spr.getHitag() <= 99) {
            short ohitag = spr.getHitag();
            Ai.enemy[7].info.set(spr);
            if (spr.getPal() != 0) {
                spr.setXrepeat(30);
            }
            spr.setExtra(0);
            spr.setOwner(0);
            spr.setHitag(ohitag);
            return;
        }
        Ai.enemy[7].info.set(spr);
        if (spr.getPicnum() == 942) {
            Main.engine.changespritestat(i, 8);
            spr.setLotag(30);
            if (Main.engine.krand() % 100 > 50) {
                spr.setExtra(1);
            }
            return;
        }
        Main.engine.changespritestat(i, 109);
        if (Main.engine.krand() % 100 > 50) {
            spr.setExtra(1);
        }
    }
}

