/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;

public class AIRat {
    public static void create() {
        Ai.enemy[18] = new Enemy();
        Ai.enemy[18].info = new EnemyInfo(32, 32, 512, 120, 0, 32, false, 0, 0){

            @Override
            public short getHealth(Sprite spr) {
                return 10;
            }
        };
        Ai.enemy[18].chase = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                WHOBJ.newstatus(i, 122);
            }
        };
        Ai.enemy[18].search = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                WHOBJ.newstatus(i, 122);
            }
        };
        Ai.enemy[18].face = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setAng(EngineUtils.getAngle(plr.getX() - spr.getX(), plr.getY() - spr.getY()));
                spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                spr.setOwner(plr.getSprite().getOwner());
                WHOBJ.newstatus(i, 122);
            }
        };
        Ai.enemy[18].die = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Main.engine.deletesprite(i);
            }
        };
        Ai.enemy[18].flee = new AIState(){

            @Override
            public void process(PLAYER plr, int i) {
                Sector sec;
                Sprite sp;
                Wall wal;
                Sprite spr = Main.boardService.getSprite(i);
                if (spr == null) {
                    Main.engine.deletesprite(i);
                    return;
                }
                spr.setLotag(spr.getLotag() - 3);
                short osectnum = spr.getSectnum();
                Sector osec = Main.boardService.getSector(osectnum);
                if (osec == null) {
                    return;
                }
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE0000000) == 0x40000000) {
                    spr.setAng((short)(spr.getAng() + 1024 & 0x7FF));
                    return;
                }
                if ((movestat & 0xE0000000) == Integer.MIN_VALUE && (wal = Main.boardService.getWall(movestat & 0x1FFFFFFF)) != null) {
                    Wall wal2 = wal.getWall2();
                    short wallang = (short)(EngineUtils.getAngle(wal2.getX() - wal.getX(), wal2.getY() - wal.getY()) + 512 & 0x7FF);
                    spr.setAng((short)(Main.engine.krand() & 256 + wallang));
                }
                if ((movestat & 0xE0000000) == -1073741824 && (sp = Main.boardService.getSprite(movestat & 0x1FFFFFFF)) != null) {
                    spr.setOwner((short)(movestat & 0x1FFFFFFF));
                    spr.setAng(EngineUtils.getAngle(sp.getX() - spr.getX(), sp.getY() - spr.getY()));
                    spr.setAng((short)((Main.engine.krand() & 0x100) + spr.getAng() + 1024 & 0x7FF));
                }
                if (Pragmas.klabs(plr.getX() - spr.getX()) <= 1024 && Pragmas.klabs(plr.getY() - spr.getY()) <= 1024) {
                    spr.setOwner(plr.getSprite().getOwner());
                    WHOBJ.newstatus(i, 109);
                }
                if ((sec = Main.boardService.getSector(spr.getSectnum())) != null && spr.getSectnum() != osectnum && sec.getLotag() == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                sec = Main.boardService.getSector(spr.getSectnum());
                if (sec != null && (Engine.zr_florhit & 0xE0000000) == 0x40000000 && (sec.getFloorpicnum() == 79 || sec.getFloorpicnum() == 80 || sec.getFloorpicnum() == 62 || sec.getFloorpicnum() == 61)) {
                    spr.setHitag(spr.getHitag() - 1);
                    if (spr.getHitag() < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.getX(), spr.getY(), spr.getZ());
            }
        };
    }

    public static void premap(int i) {
        Sprite spr = Main.boardService.getSprite(i);
        if (spr == null) {
            Main.engine.deletesprite(i);
            return;
        }
        spr.setDetail(18);
        Ai.enemy[18].info.set(spr);
        Main.engine.changespritestat(i, 109);
        spr.setShade(12);
        spr.setPal(5);
    }
}

