/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;
import ru.m210projects.Witchaven.Factory.WH2MenuHandler;
import ru.m210projects.Witchaven.Factory.WHEngine;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Factory.WHNetwork;
import ru.m210projects.Witchaven.Factory.WHOSDFunc;
import ru.m210projects.Witchaven.Factory.WHPolyGDX;
import ru.m210projects.Witchaven.Factory.WHPolymost;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Factory.WHSliderDrawable;
import ru.m210projects.Witchaven.Factory.WHSoftware;
import ru.m210projects.Witchaven.Fonts.HealthFont;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Fonts.PotionFont;
import ru.m210projects.Witchaven.Fonts.ScoreFont;
import ru.m210projects.Witchaven.Fonts.TheFont;
import ru.m210projects.Witchaven.Fonts.WH2Fonts;
import ru.m210projects.Witchaven.Main;

public class WHFactory
extends BuildFactory {
    private final Main app;

    public WHFactory(Main app) {
        super("stuff.dat");
        this.app = app;
        OsdColor.DEFAULT.setPal(30);
    }

    @Override
    public void drawInitScreen() {
        WHRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, 500, 0, 0, 10);
    }

    @Override
    public Engine engine() throws Exception {
        Main.engine = new WHEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new WHSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new WHPolyGDX(this.app.pCfg);
        }
        return new WHPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new DefScript(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new WHOSDFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = Main.game.WH2 ? new WH2MenuHandler(this.app) : new WHMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(6){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    if (Main.game.WH2) {
                        return new WH2Fonts();
                    }
                    return new MenuFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new TheFont();
                }
                if (i == 2) {
                    return new HealthFont();
                }
                if (i == 3) {
                    return new PotionFont();
                }
                if (i == 4) {
                    return new ScoreFont();
                }
                return EngineUtils.getLargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new WHNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new WHSliderDrawable();
    }
}

