/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.Polymost.Polymost2D;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.ScreenFade;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Witchaven.Factory.WHMapSettings;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHScreen;

public class WHPolymost
extends Polymost
implements WHRenderer {
    protected int framew;
    protected int frameh;
    protected GLTile frameTexture;
    private boolean drunk;
    private float drunkIntensive = 1.0f;

    public WHPolymost(GameConfig config) {
        super(config);
        this.globalfog.setFogScale(64);
    }

    @Override
    public void setPrepareMirror(boolean inpreparemirror) {
        this.inpreparemirror = inpreparemirror;
    }

    @Override
    protected Polymost2D allocOrphoRenderer(Engine engine) {
        return new Polymost2D(this, (IOverheadMapSettings)new WHMapSettings(engine.getBoardService()));
    }

    @Override
    public void drawmasks() {
        super.drawmasks();
        if (this.drunk) {
            boolean hasShader;
            Gdx.gl.glActiveTexture(33984);
            boolean bl = hasShader = this.texshader != null && this.texshader.isBinded();
            if (hasShader) {
                this.texshader.unbind();
            }
            if (this.frameTexture == null || this.framew != this.xdim || this.frameh != this.ydim) {
                int size;
                for (size = 1; size < Math.max(this.xdim, this.ydim); size <<= 1) {
                }
                if (this.frameTexture != null) {
                    this.frameTexture.dispose();
                } else {
                    this.frameTexture = this.textureCache.newTile(TileData.PixelFormat.Rgb, size, size);
                }
                this.frameTexture.bind();
                this.gl.glTexImage2D(3553, 0, 6407, this.frameTexture.getWidth(), this.frameTexture.getHeight(), 0, 6407, 5121, null);
                this.frameTexture.unsafeSetFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                this.framew = this.xdim;
                this.frameh = this.ydim;
            }
            this.textureCache.bind(this.frameTexture);
            this.gl.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.frameTexture.getWidth(), this.frameTexture.getHeight());
            this.gl.glDisable(2929);
            this.gl.glDisable(3008);
            this.gl.glEnable(3553);
            this.gl.glMatrixMode(5889);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            float tiltang = this.drunkIntensive * 360.0f / 2048.0f;
            float tilt = Math.min(Math.max(tiltang, -MAXDRUNKANGLE), MAXDRUNKANGLE);
            this.gl.glScalef(1.05f, 1.05f, 1.0f);
            this.gl.glRotatef(tilt, 0.0f, 0.0f, 1.0f);
            this.gl.glMatrixMode(5888);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            float u = (float)this.xdim / (float)this.frameTexture.getWidth();
            float v = (float)this.ydim / (float)this.frameTexture.getHeight();
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, Math.abs(tilt) / (2.0f * MAXDRUNKANGLE));
            this.gl.glBegin(6);
            this.gl.glTexCoord2f(0.0f, 0.0f);
            this.gl.glVertex2f(-1.0f, -1.0f);
            this.gl.glTexCoord2f(0.0f, v);
            this.gl.glVertex2f(-1.0f, 1.0f);
            this.gl.glTexCoord2f(u, v);
            this.gl.glVertex2f(1.0f, 1.0f);
            this.gl.glTexCoord2f(u, 0.0f);
            this.gl.glVertex2f(1.0f, -1.0f);
            this.gl.glEnd();
            this.gl.glMatrixMode(5888);
            this.gl.glPopMatrix();
            this.gl.glMatrixMode(5889);
            this.gl.glPopMatrix();
            this.gl.glEnable(2929);
            this.gl.glEnable(3008);
            this.gl.glDisable(3553);
            if (hasShader) {
                this.texshader.bind();
            }
        }
    }

    @Override
    public void setdrunk(float intensive) {
        if (intensive == 0.0f) {
            this.drunk = false;
            this.drunkIntensive = 0.0f;
        } else {
            this.drunk = true;
            this.drunkIntensive = intensive;
        }
    }

    @Override
    public float getdrunk() {
        return this.drunkIntensive;
    }

    @Override
    public byte[] getGotPic() {
        return this.gotpic;
    }

    @Override
    public Color getshadefactor(int shade, int method) {
        if (WHScreen.drawfloormirror) {
            switch (this.renderingType) {
                case Sprite: {
                    shade = 20;
                    break;
                }
                case Wall: 
                case MaskWall: {
                    int wal = this.renderingType.getIndex();
                    Wall wall = this.boardService.getWall(wal);
                    if (wall == null) break;
                    int dist = Pragmas.klabs(wall.getX() - this.globalposx);
                    shade = Gameutils.BClipLow((dist += Pragmas.klabs(wall.getY() - this.globalposy)) >> 7, 20);
                    break;
                }
                default: {
                    shade = 30;
                }
            }
        }
        return super.getshadefactor(shade, method);
    }

    @Override
    public int animateoffs(int tilenum, int nInfo) {
        return super.animateoffs(tilenum, 0);
    }

    private void renderScreenFade() {
        this.gl.glBegin(4);
        for (int i = 0; i < 6; i += 2) {
            this.gl.glVertex2f(vertices[i], vertices[i + 1]);
        }
        this.gl.glEnd();
    }

    @Override
    public void scrSetDac() {
        if (this.config.isPaletteEmulation()) {
            WHRenderer.super.scrSetDac();
            return;
        }
        if (Main.game.menu.gShowMenu) {
            return;
        }
        boolean hasShader = this.beginShowFade();
        for (ScreenFade fade : WHFX.SCREEN_DAC_ARRAY) {
            this.showScreenFade(fade);
        }
        this.endShowFade(hasShader);
    }

    @Override
    public void showScreenFade(ScreenFade screenFade) {
        int intensive = screenFade.getIntensive();
        if (intensive == 0) {
            return;
        }
        if (intensive > 32) {
            intensive = 32;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        switch (screenFade.getName()) {
            case "BLUE": {
                int a;
                b = a = (int)Math.min(4.2f * ((float)intensive + (intensive < 10 ? (float)intensive / 2.0f : 0.0f)), 255.0f);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(0, 0, b, 0);
                this.renderScreenFade();
                break;
            }
            case "GREEN": {
                int a;
                g = a = Math.min(4 * (intensive + (intensive < 10 ? intensive / 2 : 0)), 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(0, g, 0, 0);
                this.renderScreenFade();
                break;
            }
            case "WHITE": {
                g = r = intensive;
                int a = Math.min(intensive + 32, 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(r, g, 0, 0);
                this.renderScreenFade();
                break;
            }
            case "RED": {
                int a;
                r = a = Math.min(4 * (intensive + (intensive < 10 ? intensive / 2 : 0)), 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(r, 0, 0, 0);
                this.renderScreenFade();
            }
        }
    }
}

