/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.osd.commands.OsdValueRange;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Witchaven.Animate;
import ru.m210projects.Witchaven.Config;
import ru.m210projects.Witchaven.Factory.WHControl;
import ru.m210projects.Witchaven.Factory.WHDummyRenderer;
import ru.m210projects.Witchaven.Factory.WHEngine;
import ru.m210projects.Witchaven.Factory.WHFactory;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Menu.GameMenu;
import ru.m210projects.Witchaven.Menu.MainMenu;
import ru.m210projects.Witchaven.Menu.MenuCorruptGame;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Screens.CutsceneScreen;
import ru.m210projects.Witchaven.Screens.DemoScreen;
import ru.m210projects.Witchaven.Screens.GameScreen;
import ru.m210projects.Witchaven.Screens.LoadingScreen;
import ru.m210projects.Witchaven.Screens.MenuScreen;
import ru.m210projects.Witchaven.Screens.PrecacheScreen;
import ru.m210projects.Witchaven.Screens.StatisticsScreen;
import ru.m210projects.Witchaven.Screens.VictoryScreen;
import ru.m210projects.Witchaven.Screens.WHMessageScreen;
import ru.m210projects.Witchaven.Types.Delayitem;
import ru.m210projects.Witchaven.Types.EpisodeEntry;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.MapInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SWINGDOOR;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;
import ru.m210projects.Witchaven.WHTAG;
import ru.m210projects.Witchaven.Whldsv;
import ru.m210projects.Witchaven.Whmap;

public class Main
extends BuildGame {
    public static final String appdefwh1 = "whgdx.def";
    public static final String appdefwh2 = "wh2gdx.def";
    public static MenuScreen gMenuScreen;
    public static LoadingScreen gLoadScreen;
    public static GameScreen gGameScreen;
    public static VictoryScreen gVictoryScreen;
    public static CutsceneScreen gCutsceneScreen;
    public static StatisticsScreen gStatisticsScreen;
    public static DemoScreen gDemoScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static WHEngine engine;
    public static BoardService boardService;
    public static Config cfg;
    public final boolean WH2;
    public WHMenuHandler menu;
    public final Runnable main = new Runnable(){

        @Override
        public void run() {
            WHSND.stopallsounds();
            gDemoScreen.onStopRecord();
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.isEmpty() || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo(Main.this.cache.getGameDirectory())) {
                Main.this.changeScreen(gMenuScreen);
            }
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
        }
    };

    public Main(List<String> args, GameConfig cfg, String name, String version, boolean release, boolean isWH2) throws IOException {
        super(args, cfg, name, version, release);
        this.WH2 = isWH2;
        game = this;
        Main.cfg = (Config)cfg;
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new WHMessageScreen(this, header, text, type);
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (!entry.isExtension("map")) {
            return;
        }
        Console.out.println("Start dropped map: " + entry.getName());
        gGameScreen.newgame(entry, 0, Globals.difficulty);
    }

    @Override
    @NotNull
    public WHRenderer getRenderer() {
        Renderer renderer = super.getRenderer();
        if (renderer instanceof WHRenderer) {
            WHRenderer wHRenderer = (WHRenderer)renderer;
            if (wHRenderer == null) {
                Main.$$$reportNull$$$0(0);
            }
            return wHRenderer;
        }
        return new WHDummyRenderer();
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        boardService = engine.getBoardService();
        Names.init();
        WHFX.initlava();
        WHFX.initwater();
        this.ConsoleInit();
        Engine.visibility = 1024;
        Engine.parallaxtype = 1;
        if (this.WH2) {
            int j;
            ArtEntry artEntry = engine.getTile(182);
            if (artEntry instanceof DynamicArtEntry) {
                ((DynamicArtEntry)artEntry).clearData();
            }
            for (int j2 = 0; j2 < 256; ++j2) {
                Globals.tempbuf[j2] = (byte)(j2 + 32 & 0xFF);
            }
            PaletteManager paletteManager = engine.getPaletteManager();
            paletteManager.makePalookup(16, Globals.tempbuf, 0, 0, 0, 1);
            for (j = 0; j < 256; ++j) {
                Globals.tempbuf[j] = (byte)j;
            }
            paletteManager.makePalookup(17, Globals.tempbuf, 24, 24, 24, 1);
            for (j = 0; j < 256; ++j) {
                Globals.tempbuf[j] = (byte)j;
            }
            paletteManager.makePalookup(18, Globals.tempbuf, 8, 8, 48, 1);
        }
        this.readpalettetable();
        for (int i = 0; i < Engine.MAXSECTORS; ++i) {
            WHTAG.delayitem[i] = new Delayitem();
        }
        WHSND.sndInit();
        this.initstruct();
        WHScreen.initpaletteshifts();
        this.InitOriginalEpisodes();
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, this.WH2 ? appdefwh2 : appdefwh1, "whgdx.dat");
        Directory gameDir = this.cache.getGameDirectory();
        if (this.pCfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry(this.WH2 ? appdefwh2 : appdefwh1);
                        if (!def.exists()) break;
                        this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                        this.baseDef.loadScript(file.getName(), def);
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(file.getName(), file);
                    }
                }
            }
        }
        if ((filgdx = gameDir.getEntry(this.WH2 ? appdefwh2 : appdefwh1)).exists()) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        Whldsv.FindSaves(this.getUserDirectory());
        this.InitCutscenes();
        gLoadScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gVictoryScreen = new VictoryScreen();
        gCutsceneScreen = new CutsceneScreen(this);
        gStatisticsScreen = new StatisticsScreen(this);
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[13] = new MenuCorruptGame(this);
        gMenuScreen = new MenuScreen(this);
        gDemoScreen.checkDemoEntry(gameDir);
        System.gc();
        MemLog.log("create");
        return true;
    }

    public String getGameDef() {
        return this.WH2 ? appdefwh2 : appdefwh1;
    }

    private void InitOriginalEpisodes() {
        String[] sMapName;
        if (this.WH2) {
            sMapName = new String[]{"Antechamber of asmodeus", "Halls of ragnoth", "Lokis tomb", "Forsaken realm", "Eye of midian", "Dungeon of disembowlment", "Stronghold of chaos", "Jaws of venom", "Descent into doom", "Hack n sniff", "Straits of perdition", "Plateau of insanity", "Crypt of decay", "Mausoleum of madness", "Gateway into oblivion", "Lungs of hell"};
        } else {
            sMapName = new String[48];
            for (int i = 0; i < sMapName.length; ++i) {
                sMapName[i] = "Map " + (i + 1);
            }
        }
        Directory dir = this.cache.getGameDirectory();
        Globals.gOriginalEpisode = new EpisodeInfo("Original", new EpisodeEntry.Addon(dir, dir.getDirectoryEntry()));
        for (int i = 0; i < sMapName.length; ++i) {
            Globals.gOriginalEpisode.gMapInfo.add(new MapInfo("level" + (i + 1) + ".map", sMapName[i]));
        }
        WHMenuUserContent.episodeManager.putEpisode(Globals.gOriginalEpisode);
    }

    private void initstruct() {
        for (int i = 0; i < 32; ++i) {
            WHTAG.swingdoor[i] = new SWINGDOOR();
        }
        Animate.initanimations();
    }

    @Override
    public GameProcessor createGameProcessor() {
        return new WHControl(this);
    }

    @Override
    public BuildFactory getFactory() {
        return new WHFactory(this);
    }

    public void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.getPrompt().setVersion(this.getTitle(), OsdColor.YELLOW, 10);
        OsdCallback.OsdRunnable cmdGod = argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                WHPLR.player[Mmulti.myconnectindex].setGodMode(!WHPLR.player[Mmulti.myconnectindex].isGodMode());
                if (WHPLR.player[Mmulti.myconnectindex].isGodMode()) {
                    Console.out.println("God mode: On");
                } else {
                    Console.out.println("God mode: Off");
                }
            } else {
                Console.out.println("god: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        };
        Console.out.registerCommand(new OsdCallback("god", "", cmdGod));
        Console.out.registerCommand(new OsdCallback("darkness", "", cmdGod));
        Console.out.registerCommand(new OsdCallback("noclip", "", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                WHPLR.player[Mmulti.myconnectindex].setNoclip(!WHPLR.player[Mmulti.myconnectindex].isNoclip());
                if (WHPLR.player[Mmulti.myconnectindex].isNoclip()) {
                    Console.out.println("Noclip mode: On");
                } else {
                    Console.out.println("Noclip mode: Off");
                }
            } else {
                Console.out.println("Noclip: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("showmap", "", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                Arrays.fill(Engine.show2dsector.getArray(), (byte)-1);
                WHScreen.showmessage("showmap: on", 360);
            } else {
                Console.out.println("showmap: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("scooter", "", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                PLAYER plr = WHPLR.player[WHPLR.pyrn];
                plr.getWeapon()[1] = 1;
                plr.getAmmo()[1] = 45;
                plr.getWeapon()[2] = 1;
                plr.getAmmo()[2] = 55;
                plr.getWeapon()[3] = 1;
                plr.getAmmo()[3] = 50;
                plr.getWeapon()[4] = 1;
                plr.getAmmo()[4] = 80;
                plr.getWeapon()[5] = 1;
                plr.getAmmo()[5] = 100;
                plr.getWeapon()[6] = 1;
                plr.getAmmo()[6] = 50;
                plr.getWeapon()[7] = 2;
                plr.getAmmo()[7] = 40;
                plr.getWeapon()[8] = 1;
                plr.getAmmo()[8] = 250;
                plr.getWeapon()[9] = 1;
                plr.getAmmo()[9] = 50;
                plr.setSelectedgun(4);
                plr.setCurrweapon(4);
                WHScreen.showmessage("All weapons and ammo", 360);
            } else {
                Console.out.println("scooter: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("mommy", "", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                PLAYER plr = WHPLR.player[WHPLR.pyrn];
                Arrays.fill(plr.getPotion(), 9);
                WHScreen.showmessage("All Potions and Spells", 360);
            } else {
                Console.out.println("mommy: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCallback("wango", "", argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                PLAYER plr = WHPLR.player[WHPLR.pyrn];
                for (int i = 0; i < 8; ++i) {
                    plr.getOrb()[i] = 1;
                    plr.getOrbammo()[i] = 9;
                }
                plr.setHealth(0);
                WHPLR.addhealth(plr, 200);
                plr.setArmor(150);
                plr.setArmortype(3);
                plr.setLvl(7);
                plr.setMaxhealth(200);
                plr.getTreasure()[14] = 1;
                plr.getTreasure()[15] = 1;
                plr.getTreasure()[16] = 1;
                plr.getTreasure()[17] = 1;
                WHScreen.showmessage("Full Health, Armor, Scrolls; Bonus EXP", 360);
            } else {
                Console.out.println("wango: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        OsdCallback.OsdRunnable cmdPowerup = argv -> {
            if (this.isCurrentScreen(gGameScreen)) {
                PLAYER plr = WHPLR.player[WHPLR.pyrn];
                WHFX.weaponpowerup(plr);
            } else {
                Console.out.println("powerup: not in a single-player game");
            }
            return CommandResponse.SILENT_RESPONSE;
        };
        Console.out.registerCommand(new OsdCallback("powerup", "", cmdPowerup));
        Console.out.registerCommand(new OsdCallback("enchant", "", cmdPowerup));
        Console.out.registerCommand(new OsdValueRange("changemap", "", 2.0f, 25.0f){

            @Override
            public float getValue() {
                return WHPLR.mapon;
            }

            @Override
            protected void setCheckedValue(float value) {
                WHPLR.mapon = (int)value;
                Whmap.loadnewlevel(WHPLR.mapon);
            }
        });
    }

    public void readpalettetable() {
        Entry fp = this.cache.getEntry("lookup.dat", true);
        if (fp.exists()) {
            try (InputStream is = fp.getInputStream();){
                int num_tables = StreamUtils.readUnsignedByte(is);
                for (int j = 0; j < num_tables; ++j) {
                    int lookup_num = StreamUtils.readUnsignedByte(is);
                    engine.getPaletteManager().makePalookup(lookup_num, StreamUtils.readBytes(is, 256), 0, 0, 0, 1);
                }
            }
            catch (IOException e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
    }

    private void InitCutscenes() {
        Console.out.println("Initializing cutscenes");
        GrpFile group = new GrpFile("Cutscenes");
        LinkedHashSet<Directory> groupList = new LinkedHashSet<Directory>();
        Directory gameDir = this.cache.getGameDirectory();
        Directory smkDir = gameDir.getDirectory(gameDir.getEntry("smk"));
        if (!smkDir.isEmpty()) {
            groupList.add(smkDir);
        }
        groupList.add(gameDir);
        for (Group group2 : groupList) {
            group2.stream().filter(e -> e.isExtension("smk")).forEach(group::addEntry);
        }
        if (!group.isEmpty()) {
            this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
        } else {
            Console.out.println("Cutscenes were not found", OsdColor.YELLOW);
        }
    }

    @Override
    public void dispose() {
        gDemoScreen.onStopRecord();
        super.dispose();
    }

    @Override
    public void show() {
        gDemoScreen.onStopRecord();
        if (gCutsceneScreen.init("intro.smk")) {
            this.changeScreen(gCutsceneScreen.setSkipping(this.main).escSkipping(true));
        } else {
            this.main.run();
        }
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                String report = "boardfilename " + Globals.boardfilename;
                report = report + "\r\n";
                if (WHPLR.player[0] != null) {
                    report = report + "PlayerX " + WHPLR.player[0].getX();
                    report = report + "\r\n";
                    report = report + "PlayerY " + WHPLR.player[0].getY();
                    report = report + "\r\n";
                    report = report + "PlayerZ " + WHPLR.player[0].getZ();
                    report = report + "\r\n";
                }
                return report.getBytes();
            }
        };
    }

    static {
        mUserFlag = UserFlag.None;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Witchaven/Main", "getRenderer"));
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;


        public static UserFlag parseValue(byte index) {
            switch (index) {
                case 1: {
                    return Addon;
                }
                case 2: {
                    return UserMap;
                }
            }
            return None;
        }
    }
}

