/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Menu;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Main;

public class WHSwitch
extends MenuItem {
    private static WHSwitch touchedObj;
    private final int[][] pics = new int[][]{{510, 20}, {511, 20}, {512, 25}, {513, 25}};
    public final int nTile;
    public final int nCount;
    public int nValue;
    public final MenuProc callback;

    public WHSwitch(Object text, Font font, int x, int y, int nSelect, int nCount, MenuProc callback) {
        super(text, font);
        this.x = x;
        this.y = y;
        this.flags = 7;
        this.width = 320;
        this.nTile = 513;
        Main.engine.getTile(this.nTile).disableAnimation();
        Main.engine.getTile(this.nTile + 2).disableAnimation();
        this.nCount = nCount;
        this.nValue = nSelect;
        this.callback = callback;
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int shade = 0;
        int pal = this.pal;
        WHRenderer renderer = Main.game.getRenderer();
        if (this.m_pMenu.mGetFocusedItem(this)) {
            shade = 16 - (Main.engine.getTotalClock() & 0x3F);
            pal = 20;
        }
        int stat = 26;
        if (this.text != null) {
            px = this.width / 2 + this.x - this.font.getWidth(this.text, 1.0f) / 2;
            this.font.drawTextScaled((Renderer)renderer, px, this.y, this.text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
        }
        int posX = this.width / 2 + this.x - (this.nCount - 1) * this.pics[this.nCount - 1][1] / 2;
        int varY = this.y + 25;
        for (int i = 0; i < this.nCount; ++i) {
            stat = 10;
            if (i != this.nValue - 1) {
                stat |= 0x21;
            }
            renderer.rotatesprite(posX << 16, varY << 16, 32768, 0, this.pics[i][0], 0, 0, stat);
            posX += this.pics[i][1];
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.nValue = Gameutils.BClipLow(this.nValue - 1, 1);
                break;
            }
            case RIGHT: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                this.nValue = Gameutils.BClipHigh(this.nValue + 1, this.nCount);
                break;
            }
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (touchedObj == this && this.callback != null) {
                    this.callback.run(handler, this);
                }
            }
            default: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        if (this.callback != null) {
            this.callback.run(handler, this);
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        int posY = this.y + 25;
        boolean isTouched = false;
        if (!Gdx.input.isTouched() && touchedObj != this) {
            touchedObj = null;
        }
        if (my > posY - Main.engine.getTile(510).getHeight() / 2 && my < posY + Main.engine.getTile(510).getHeight() / 2) {
            int posX = this.width / 2 + this.x - (this.nCount - 1) * this.pics[this.nCount - 1][1] / 2;
            for (int i = 0; i < this.nCount; ++i) {
                if (mx > posX - Main.engine.getTile(this.pics[i][0]).getWidth() / 2 && mx < posX + Main.engine.getTile(this.pics[i][0]).getWidth() / 2 && Gdx.input.isTouched()) {
                    this.nValue = i + 1;
                    isTouched = true;
                    if (Gdx.input.isTouched()) {
                        touchedObj = this;
                    }
                }
                posX += this.pics[i][1];
            }
        }
        return isTouched;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

