/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Screens;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Witchaven.Animate;
import ru.m210projects.Witchaven.Config;
import ru.m210projects.Witchaven.Factory.WHControl;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Factory.WHRenderer;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Menu.MenuInterfaceSet;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Potions;
import ru.m210projects.Witchaven.Screens.DemoScreen;
import ru.m210projects.Witchaven.Spellbooks;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.PLOCATION;
import ru.m210projects.Witchaven.WH2MUS;
import ru.m210projects.Witchaven.WHANI;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;
import ru.m210projects.Witchaven.WHTAG;
import ru.m210projects.Witchaven.Weapons;
import ru.m210projects.Witchaven.Whldsv;
import ru.m210projects.Witchaven.Whmap;

public class GameScreen
extends GameAdapter {
    public int gNameShowTime;
    private final Main game;

    public GameScreen(Main game) {
        super(game, Main.gLoadScreen);
        this.game = game;
        for (int i = 0; i < 16; ++i) {
            WHPLR.player[i] = new PLAYER();
            WHPLR.gPrevPlayerLoc[i] = new PLOCATION();
        }
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            WHPLR.player[i].getInput().Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        if (this.game.gPaused || !DemoScreen.isDemoPlaying() && !DemoScreen.isDemoScreen(this) && (this.game.menu.gShowMenu || Console.out.isShowing())) {
            return;
        }
        Main.gDemoScreen.onRecord();
        int TICSPERFRAME = Main.engine.getTimer().getFrameTicks();
        Globals.lockclock += TICSPERFRAME;
        short i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            WHPLR.player[i2].setOldsector(WHPLR.player[i2].getSector());
            i2 = Mmulti.connectpoint2[i2];
        }
        PLAYER plr = WHPLR.player[WHPLR.pyrn];
        WHPLR.viewBackupPlayerLoc(WHPLR.pyrn);
        this.processinput(WHPLR.pyrn);
        WHPLR.updateviewmap(plr);
        WHScreen.updatepaletteshifts();
        WHOBJ.processobjs(plr);
        WHANI.animateobjs(plr);
        WHTAG.animatetags(WHPLR.pyrn);
        Animate.doanimations();
        WHTAG.dodelayitems(TICSPERFRAME);
        WHFX.dofx();
        Spellbooks.speelbookprocess(plr);
        WHOBJ.timerprocess(plr);
        Weapons.weaponsprocess(WHPLR.pyrn);
        this.whtime();
        WHSND.updatesounds();
        if (Globals.followmode) {
            Globals.followx += Globals.followvel * EngineUtils.sin(2560 - (Globals.followa += (int)Globals.followang) & 0x7FF) >> 10;
            Globals.followy += Globals.followvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followx += Globals.followsvel * EngineUtils.sin(1024 - Globals.followa & 0x7FF) >> 10;
            Globals.followy -= Globals.followsvel * EngineUtils.sin(2560 - Globals.followa & 0x7FF) >> 10;
        }
    }

    private void whtime() {
        if (++Globals.fortieth == 40) {
            Globals.fortieth = 0;
            ++Globals.seconds;
        }
        if (Globals.seconds == 60) {
            ++Globals.minutes;
            Globals.seconds = 0;
        }
        if (Globals.minutes == 60) {
            ++Globals.hours;
            Globals.minutes = 0;
        }
    }

    @Override
    public void DrawWorld(float smooth) {
        WHScreen.drawscreen(WHPLR.pyrn, (int)smooth);
        if (!this.game.gPaused && this.game.WH2 && WHSND.songptr.handle != null && !WHSND.songptr.handle.isPlaying()) {
            WH2MUS.startsong(Main.engine.rand() % 2);
            WH2MUS.attacktheme = 0;
        }
    }

    @Override
    public void DrawHud(float smooth) {
        WHRenderer renderer = this.game.getRenderer();
        if (this.pMenu.gShowMenu && !(this.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            return;
        }
        if (!WHPLR.player[WHPLR.pyrn].isDead()) {
            WHScreen.drawweapons(WHPLR.pyrn);
        }
        if (WHPLR.player[WHPLR.pyrn].getSpiked() == 1) {
            WHScreen.spikeheart(WHPLR.player[WHPLR.pyrn]);
        }
        if (WHFX.scarytime >= 0) {
            WHScreen.drawscary();
        }
        WHScreen.drawInterface(WHPLR.player[WHPLR.pyrn]);
        if (this.game.isCurrentScreen(Main.gGameScreen) && Main.engine.getTotalClock() < this.gNameShowTime) {
            Transparent transp = Transparent.None;
            if (Main.engine.getTotalClock() > this.gNameShowTime - 20) {
                transp = Transparent.Bit1;
            }
            if (Main.engine.getTotalClock() > this.gNameShowTime - 10) {
                transp = Transparent.Bit2;
            }
            if (Main.cfg.showMapInfo && !this.game.menu.gShowMenu) {
                if (Globals.gCurrentEpisode != null && Globals.gCurrentEpisode.getMap(WHPLR.mapon) != null) {
                    this.game.getFont(1).drawTextScaled((Renderer)renderer, 160, 114, Globals.gCurrentEpisode.getMap((int)WHPLR.mapon).title, 1.0f, 0, 0, TextAlign.Center, transp, ConvertType.Normal, true);
                } else if (Globals.boardfilename != null) {
                    this.game.getFont(1).drawTextScaled((Renderer)renderer, 160, 114, Globals.boardfilename.getName(), 1.0f, 0, 0, TextAlign.Center, transp, ConvertType.Normal, true);
                }
            }
        }
        WHFX.WHITE_DAC.setIntensive(WHScreen.whitecount);
        WHFX.RED_DAC.setIntensive(WHScreen.redcount);
        WHFX.GREEN_DAC.setIntensive(WHScreen.greencount);
        WHFX.BLUE_DAC.setIntensive(WHScreen.bluecount);
        renderer.scrSetDac();
    }

    protected boolean gameKeyDownCommon(GameKey gameKey, boolean inGame) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        WHMenuHandler menu = this.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            if (inGame) {
                menu.mOpen(menu.mMenus[1], -1);
            } else {
                menu.mOpen(menu.mMenus[0], -1);
            }
            return true;
        }
        if (Config.WhKeys.Show_Loadmenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1) {
                return false;
            }
            menu.mOpen(menu.mMenus[3], -1);
            return true;
        }
        if (Config.WhKeys.Show_Sounds.equals(gameKey)) {
            menu.mOpen(menu.mMenus[8], -1);
            return true;
        }
        if (Config.WhKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[10], -1);
            return true;
        }
        if (Config.WhKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[6], -1);
            return true;
        }
        if (Config.WhKeys.Gamma.equals(gameKey)) {
            menu.mOpen(menu.mMenus[11], -1);
            return true;
        }
        if (Config.WhKeys.Make_Screenshot.equals(gameKey)) {
            this.makeScreenshot();
            return true;
        }
        return false;
    }

    protected void makeScreenshot() {
        WHRenderer renderer = this.game.getRenderer();
        String name = Main.mUserFlag == Main.UserFlag.UserMap ? "scr-" + FileUtils.getFullName(Globals.boardfilename.getName()) + "-xxxx.png" : "scr-map" + WHPLR.mapon + "-xxxx.png";
        String filename = renderer.screencapture(this.game.getUserDirectory(), name);
        if (filename != null) {
            WHScreen.showmessage(filename + " saved", 240);
        } else {
            WHScreen.showmessage("Screenshot not saved. Access denied!", 240);
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, true)) {
            return true;
        }
        WHMenuHandler menu = this.game.menu;
        if (Config.WhKeys.Show_Savemenu.equals(gameKey)) {
            if (this.game.nNetMode == BuildGame.NetMode.Single) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[4], -1);
                return true;
            }
        } else {
            if (Config.WhKeys.Quicksave.equals(gameKey)) {
                Whldsv.quicksave();
                return true;
            }
            if (Config.WhKeys.Quickload.equals(gameKey)) {
                Whldsv.quickload();
                return true;
            }
        }
        return false;
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (Whldsv.gQuickSaving) {
            if (this.captBuffer != null) {
                Whldsv.savegame(this.game.getUserDirectory(), "[quicksave_" + Whldsv.quickslot + "]", "quicksav" + Whldsv.quickslot + ".sav");
                Whldsv.quickslot ^= 1;
                Whldsv.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (Whldsv.gAutosaveRequest) {
            if (this.captBuffer != null) {
                Whldsv.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                Whldsv.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    @Override
    protected boolean prepareboard(Entry map) {
        WHSND.sndStopMusic();
        this.game.nNetMode = BuildGame.NetMode.Single;
        this.gNameShowTime = 500;
        Globals.followmode = false;
        ((WHControl)this.game.getProcessor()).reset();
        if (Whmap.prepareboard(this, map) == null) {
            this.game.show();
            return false;
        }
        return true;
    }

    public void processinput(int num) {
        int goalz;
        Sector psec;
        int sprIndex;
        Sprite spr;
        int onsprite = -1;
        PLAYER plr = WHPLR.player[num];
        int bits = plr.getInput().bits;
        if ((bits & 1) == 0) {
            plr.setKeytoggle(false);
        }
        if (plr.getHealth() <= 0) {
            WHPLR.playerdead(plr);
            if (plr.isDead()) {
                if (plr.getHoriz() < 200.0f) {
                    plr.setHoriz(plr.getHoriz() + 6.0f);
                }
                if (!DemoScreen.isDemoPlaying()) {
                    if (Whldsv.lastload != null && Whldsv.lastload.exists()) {
                        WHScreen.showmessage("Press \"USE\" to load last saved game or press \"ENTER\" to restart level", 320);
                        if ((bits & 0x200000) != 0) {
                            this.game.changeScreen(Main.gLoadScreen);
                            Main.gLoadScreen.init(() -> {
                                if (!Whldsv.loadgame(Whldsv.lastload)) {
                                    this.game.GameMessage("Can't load game!");
                                }
                            });
                            return;
                        }
                    } else {
                        WHScreen.showmessage("Press \"ENTER\" to restart level", 320);
                    }
                    if (Gdx.input.isKeyPressed(66)) {
                        if (Main.mUserFlag == Main.UserFlag.UserMap) {
                            this.loadboard(Globals.boardfilename, null);
                            return;
                        }
                        WHPLR.initplayersprite(plr);
                        WHPLR.justteleported = true;
                        Globals.lockclock = Main.engine.getTotalClock();
                        if (!Globals.netgame) {
                            Whmap.loadnewlevel(WHPLR.mapon);
                        }
                        WHScreen.zoom = 256;
                        WHScreen.displaytime = 0;
                    }
                }
            }
            return;
        }
        int tics = 3;
        plr.getInput().fvel += tics * plr.getDamage_vel() << 14;
        plr.getInput().svel += tics * plr.getDamage_svel() << 14;
        plr.getInput().angvel += (float)plr.getDamage_angvel();
        if (plr.getDamage_vel() != 0) {
            plr.setDamage_vel(Gameutils.BClipHigh(plr.getDamage_vel() + (tics << 3), 0));
        }
        if (plr.getDamage_svel() != 0) {
            plr.setDamage_svel(Gameutils.BClipLow(plr.getDamage_svel() - (tics << 3), 0));
        }
        if (plr.getDamage_angvel() != 0) {
            plr.setDamage_angvel(Gameutils.BClipLow(plr.getDamage_angvel() - (tics << 1), 0));
        }
        plr.getSprite().setCstat(plr.getSprite().getCstat() ^ 1);
        this.pEngine.getzrange(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), 128, 65537);
        int loz = Engine.zr_florz;
        int lohit = Engine.zr_florhit;
        plr.getSprite().setCstat(plr.getSprite().getCstat() ^ 1);
        if ((lohit & 0xE0000000) == -1073741824 && (spr = Main.boardService.getSprite(sprIndex = lohit & 0x1FFFFFFF)) != null && spr.getZ() - plr.getZ() <= WHPLR.getPlayerHeight() << 8) {
            onsprite = sprIndex;
        }
        int feetoffground = (psec = Main.boardService.getSector(plr.getSector())) != null ? psec.getFloorz() - plr.getZ() : 0;
        plr.setHoriz(Gameutils.BClipRange(plr.getHoriz() + plr.getInput().horiz, -100.0f, 200.0f));
        if ((bits & 0x10) != 0) {
            if (plr.getHoriz() > 0.0f) {
                plr.setHoriz(plr.getHoriz() - 6.0f);
                WHPLR.autohoriz = 0;
            }
        } else if ((bits & 8) != 0) {
            if (plr.getHoriz() < 200.0f) {
                plr.setHoriz(plr.getHoriz() + 6.0f);
            }
            WHPLR.autohoriz = 0;
        }
        if ((bits & 0x2000000) != 0) {
            plr.getOrbactive()[5] = -1;
        }
        if ((bits & 4) != 0 && plr.getHasshot() == 0 && plr.getCurrweaponfired() == 0) {
            Weapons.plrfireweapon(plr);
        }
        if ((bits & 0x80) != 0 && plr.getOrbshot() == 0 && plr.getCurrweaponflip() == 0 && plr.getCurrweaponanim() == 0) {
            if (plr.getOrb()[plr.getCurrentorb()] == 1 && plr.getCurrweapon() == 0 && Spellbooks.lvlspellcheck(plr)) {
                plr.setOrbshot(1);
                Spellbooks.activatedaorb(plr);
            }
            if (plr.getCurrweapon() != 0) {
                Weapons.autoweaponchange(plr, 0);
            }
        }
        if ((bits & 0x80000) != 0 && plr.getPotion()[plr.getCurrentpotion()] > 0) {
            Potions.usapotion(plr);
        }
        if ((bits & 0x200000) != 0 && !Globals.netgame) {
            WHPLR.plruse(plr);
        }
        if ((bits & 0x400000) != 0 && plr.getTurnAround() == 0) {
            plr.setTurnAround((short)-1024);
        }
        if (plr.getTurnAround() < 0) {
            plr.setTurnAround((short)Gameutils.BClipHigh(plr.getTurnAround() + 64, 0));
            plr.setAng(Gameutils.BClampAngle(plr.getAng() + 64.0f));
        }
        if ((psec = Main.boardService.getSector(plr.getSector())) != null && (psec.getFloorpicnum() != 79 || psec.getFloorpicnum() != 5 || psec.getFloorpicnum() != 90 || psec.getFloorpicnum() != 86 || psec.getFloorpicnum() != 61 || psec.getFloorpicnum() != 62 || psec.getFloorpicnum() != 80) && feetoffground <= 8192) {
            plr.getInput().fvel /= 3;
            plr.getInput().svel /= 3;
        }
        if (psec != null && (psec.getFloorpicnum() == 79 || psec.getFloorpicnum() == 5 || psec.getFloorpicnum() == 90 || psec.getFloorpicnum() == 86 || psec.getFloorpicnum() == 61 || psec.getFloorpicnum() == 62 || psec.getFloorpicnum() == 80) && plr.getOrbactive()[5] < 0 && plr.getZ() >= psec.getFloorz() - (plr.getHeight() << 8) - 2048) {
            goalz = loz - 8192;
            switch (psec.getFloorpicnum()) {
                case 61: 
                case 62: 
                case 79: 
                case 80: {
                    if (plr.getTreasure()[5] == 1) {
                        goalz = loz - (WHPLR.getPlayerHeight() << 8);
                        break;
                    }
                    plr.getInput().fvel -= plr.getInput().fvel >> 3;
                    plr.getInput().svel -= plr.getInput().svel >> 3;
                    if (plr.getInvincibletime() > 0 || plr.getManatime() > 0 || plr.isGodMode()) break;
                    if (WHSND.lavasnd == -1) {
                        WHSND.lavasnd = WHSND.playsound(WHSND.S_FIRELOOP1, 0, 0, -1);
                    }
                    WHPLR.addhealth(plr, -1);
                    WHScreen.startredflash(10);
                    break;
                }
                case 90: {
                    if (plr.getTreasure()[4] == 1) {
                        goalz = loz - (WHPLR.getPlayerHeight() << 8);
                        break;
                    }
                    plr.getInput().fvel -= plr.getInput().fvel >> 3;
                    plr.getInput().svel -= plr.getInput().svel >> 3;
                    break;
                }
                case 86: {
                    if (plr.getHealth() >= plr.getMaxhealth()) break;
                    WHPLR.addhealth(plr, 1);
                    WHScreen.startblueflash(5);
                }
            }
        } else if (plr.getOrbactive()[5] > 0) {
            goalz = plr.getZ() - (plr.getHeight() << 8);
            plr.setHvel(0);
        } else {
            goalz = loz - (plr.getHeight() << 8);
        }
        if (plr.getOrbactive()[5] < 0 && (bits & 1) != 0 && !plr.isKeytoggle() && plr.getOnsomething() != 0) {
            if (this.game.WH2) {
                plr.setHvel(plr.getHvel() - 6144);
            } else {
                plr.setHvel(plr.getHvel() - 3840);
            }
            plr.setOnsomething(0);
            plr.setKeytoggle(true);
        }
        if ((bits & 2) != 0 && psec != null && goalz < psec.getFloorz() - (plr.getHeight() >> 3)) {
            goalz = this.game.WH2 ? (goalz += 12288) : (goalz += 6144);
        }
        boolean onground = plr.getOnsomething() != 0;
        int vel = Pragmas.klabs(plr.getInput().fvel) + Pragmas.klabs(plr.getInput().svel) >> 16;
        if (vel < 16) {
            vel = 0;
        }
        if ((bits & 0x800000) != 0 || (bits & 1) != 0) {
            this.dophysics(plr, goalz, 1, vel);
        } else if ((bits & 0x1000000) != 0 || (bits & 2) != 0) {
            this.dophysics(plr, goalz, -1, vel);
        } else {
            this.dophysics(plr, goalz, 0, vel);
        }
        if (!onground && plr.getOnsomething() != 0) {
            if (plr.getFallz() > 32768) {
                if (this.pEngine.krand() % 2 != 0) {
                    WHSND.playsound_loc(WHSND.S_PLRPAIN1 + this.pEngine.krand() % 2, plr.getX(), plr.getY());
                } else {
                    WHSND.playsound_loc(WHSND.S_PUSH1 + this.pEngine.krand() % 2, plr.getX(), plr.getY());
                }
                WHPLR.addhealth(plr, -(plr.getFallz() >> 13));
                plr.setFallz(0);
            } else if (plr.getFallz() > 8192) {
                WHSND.playsound_loc(WHSND.S_BREATH1 + this.pEngine.krand() % 2, plr.getX(), plr.getY());
            }
        }
        if (plr.getIhaveflag() > 0) {
            plr.getInput().fvel -= plr.getInput().fvel >> 2;
            plr.getInput().svel -= plr.getInput().svel >> 2;
        }
        if (plr.getInput().fvel != 0 || plr.getInput().svel != 0) {
            int xvect = plr.getInput().fvel;
            int yvect = plr.getInput().svel;
            int oldposx = plr.getX();
            int oldposy = plr.getY();
            if (plr.isNoclip()) {
                plr.setX(plr.getX() + (xvect >> 14));
                plr.setY(plr.getY() + (yvect >> 14));
                int sect = Main.engine.updatesector(plr.getX(), plr.getY(), plr.getSector());
                if (sect != -1) {
                    plr.setSector(sect);
                }
            } else {
                this.pEngine.clipmove(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), xvect, yvect, 128, 1024, 1024, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    plr.setX(Engine.clipmove_x);
                    plr.setY(Engine.clipmove_y);
                    plr.setZ(Engine.clipmove_z);
                    plr.setSector(Engine.clipmove_sectnum);
                }
                this.pEngine.pushmove(plr.getX(), plr.getY(), plr.getZ(), plr.getSector(), 128, 1024, 1024, 65537);
                if (Engine.pushmove_sectnum != -1) {
                    plr.setX(Engine.pushmove_x);
                    plr.setY(Engine.pushmove_y);
                    plr.setZ(Engine.pushmove_z);
                    plr.setSector(Engine.pushmove_sectnum);
                }
            }
            psec = Main.boardService.getSector(plr.getSector());
            if (plr.getSector() != plr.getOldsector()) {
                if (psec != null && WHSND.lavasnd != -1) {
                    switch (psec.getFloorpicnum()) {
                        case 61: 
                        case 62: 
                        case 79: 
                        case 80: {
                            break;
                        }
                        default: {
                            WHSND.stopsound(WHSND.lavasnd);
                            WHSND.lavasnd = -1;
                        }
                    }
                }
                WHFX.sectorsounds();
            }
            plr.setHoriz(plr.getHoriz() - (float)plr.getOldhoriz());
            int dist = EngineUtils.sqrt((plr.getX() - oldposx) * (plr.getX() - oldposx) + (plr.getY() - oldposy) * (plr.getY() - oldposy));
            if (Pragmas.klabs(plr.getInput().svel | plr.getInput().fvel) > (this.game.WH2 ? 20 : 15)) {
                dist >>= 2;
            }
            if (dist > 0 && feetoffground <= plr.getHeight() << 8 || onsprite != -1) {
                plr.setOldhoriz(dist * EngineUtils.sin(Globals.lockclock << 5 & 0x7FF) >> 19 >> 2);
                plr.setHoriz(plr.getHoriz() + (float)plr.getOldhoriz());
            } else {
                plr.setOldhoriz(0);
            }
            plr.setHoriz(Gameutils.BClipRange(plr.getHoriz(), -100.0f, 200.0f));
            Sprite onsp = Main.boardService.getSprite(onsprite);
            if (onsp != null && dist > 50 && plr.getLopoint() == 1 && plr.getJustplayed() == 0) {
                switch (onsp.getPicnum()) {
                    case 260: 
                    case 263: 
                    case 537: {
                        if (plr.getWalktoggle() != 0) {
                            WHSND.playsound_loc(145, plr.getX() + 3000, plr.getY());
                        } else {
                            WHSND.playsound_loc(145, plr.getX(), plr.getY() + 3000);
                        }
                        plr.setWalktoggle(plr.getWalktoggle() ^ 1);
                        plr.setJustplayed(1);
                        break;
                    }
                    case 68: {
                        if (plr.getWalktoggle() != 0) {
                            WHSND.playsound_loc(WHSND.S_SOFTCHAINWALK, plr.getX() + 3000, plr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_SOFTCHAINWALK, plr.getX(), plr.getY() + 3000);
                        }
                        plr.setWalktoggle(plr.getWalktoggle() ^ 1);
                        plr.setJustplayed(1);
                        break;
                    }
                    case 490: 
                    case 491: {
                        if (plr.getWalktoggle() != 0) {
                            WHSND.playsound_loc(WHSND.S_LOUDCHAINWALK, plr.getX() + 3000, plr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_LOUDCHAINWALK, plr.getX(), plr.getY() + 3000);
                        }
                        plr.setWalktoggle(plr.getWalktoggle() ^ 1);
                        plr.setJustplayed(1);
                        break;
                    }
                    case 271: {
                        if (plr.getWalktoggle() != 0) {
                            WHSND.playsound_loc(WHSND.S_SOFTCREAKWALK, plr.getX() + 3000, plr.getY());
                        } else {
                            WHSND.playsound_loc(WHSND.S_SOFTCREAKWALK, plr.getX(), plr.getY() + 3000);
                        }
                        plr.setWalktoggle(plr.getWalktoggle() ^ 1);
                        plr.setJustplayed(1);
                        break;
                    }
                    case 1070: {
                        WHSND.playsound_loc(WHSND.S_DEADSTEP, onsp.getX(), onsp.getY());
                        plr.setJustplayed(1);
                        WHOBJ.newstatus(onsprite, 107);
                        break;
                    }
                    case 916: 
                    case 1940: 
                    case 1941: 
                    case 1952: 
                    case 1953: 
                    case 1955: 
                    case 1957: 
                    case 1979: 
                    case 1980: 
                    case 1981: 
                    case 1984: {
                        WHSND.playsound_loc(WHSND.S_DEADSTEP, plr.getX(), plr.getY());
                        plr.setJustplayed(1);
                        break;
                    }
                }
                if (onsp.getPicnum() == Names.RAT) {
                    WHSND.playsound_loc(WHSND.S_RATS1 + this.pEngine.krand() % 2, onsp.getX(), onsp.getY());
                    plr.setJustplayed(1);
                    this.pEngine.deletesprite(onsprite);
                }
            }
            if (plr.getLopoint() == 0 && plr.getOldhoriz() == -2 && plr.getJustplayed() == 0) {
                plr.setLopoint(1);
            }
            if (plr.getLopoint() == 1 && plr.getOldhoriz() != -2 && plr.getJustplayed() == 1) {
                plr.setLopoint(0);
                plr.setJustplayed(0);
            }
            if ((vel = Pragmas.klabs(plr.getInput().fvel) + Pragmas.klabs(plr.getInput().svel) >> 16) > 40 && dist > 10) {
                plr.setRunningtime(plr.getRunningtime() + 3);
            } else {
                plr.setRunningtime(plr.getRunningtime() - 3);
            }
            if (plr.getRunningtime() < -360) {
                plr.setRunningtime(0);
            }
            if (plr.getRunningtime() > 360) {
                WHSND.SND_Sound(WHSND.S_PLRPAIN1);
                plr.setRunningtime(0);
            }
        }
        if (plr.getInput().angvel != 0.0f) {
            plr.setAng(plr.getAng() + plr.getInput().angvel * 3.0f / 16.0f);
            plr.setAng(Gameutils.BClampAngle(plr.getAng()));
        }
        this.game.pInt.setsprinterpolate(plr.getSpritenum(), plr.getSprite());
        this.pEngine.setsprite(plr.getSpritenum(), plr.getX(), plr.getY(), plr.getZ() + (plr.getHeight() << 8));
        plr.getSprite().setAng((short)plr.getAng());
        if (plr.getSector() >= 0 && Main.engine.getceilzofslope(plr.getSector(), plr.getX(), plr.getY()) > Main.engine.getflorzofslope(plr.getSector(), plr.getX(), plr.getY()) - 2048) {
            WHPLR.addhealth(plr, -10);
        }
        if ((bits & 0x20) != 0) {
            WHPLR.autohoriz = 1;
        }
        if (WHPLR.autohoriz == 1) {
            this.autothehoriz(plr);
        }
        if (plr.getCurrweaponfired() != 1 && plr.getCurrweaponfired() != 6) {
            plr.setHasshot(0);
        }
        Weapons.weaponchange(num);
        Spellbooks.bookprocess(num);
        Potions.potionchange(num);
    }

    public void autothehoriz(PLAYER plr) {
        if (plr.getHoriz() < 100.0f) {
            plr.setHoriz(Gameutils.BClipHigh(plr.getHoriz() + 12.0f, 100));
        }
        if (plr.getHoriz() > 100.0f) {
            plr.setHoriz(Gameutils.BClipLow(plr.getHoriz() - 12.0f, 100));
        }
        if (plr.getHoriz() == 100.0f) {
            WHPLR.autohoriz = 0;
        }
    }

    public void dophysics(PLAYER plr, int goalz, int flyupdn, int v) {
        if (plr.getOrbactive()[5] > 0) {
            if (v > 0) {
                if (plr.getHoriz() > 125.0f) {
                    plr.setHvel(plr.getHvel() - 768);
                } else if (plr.getHoriz() < 75.0f) {
                    plr.setHvel(plr.getHvel() + 768);
                }
            }
            if (flyupdn > 0) {
                plr.setHvel(plr.getHvel() - 384);
            }
            if (flyupdn < 0) {
                plr.setHvel(plr.getHvel() + 384);
            }
            plr.setHvel(plr.getHvel() + (EngineUtils.sin(Globals.lockclock << 4 & 0x7FF) >> 6));
            plr.setFallz(0);
        } else if (plr.getZ() < goalz) {
            if (this.game.WH2) {
                plr.setHvel(plr.getHvel() + 768);
            } else {
                plr.setHvel(plr.getHvel() + 480);
            }
            plr.setOnsomething(plr.getOnsomething() & 0xFFFFFFFC);
            plr.setFallz(plr.getFallz() + plr.getHvel());
        } else if (plr.getZ() > goalz) {
            plr.setHvel(plr.getHvel() - (plr.getZ() - goalz >> 6));
            plr.setOnsomething(plr.getOnsomething() | 1);
            plr.setFallz(0);
        } else {
            plr.setFallz(0);
        }
        plr.setZ(plr.getZ() + plr.getHvel());
        if (plr.getHvel() > 0 && plr.getZ() > goalz) {
            plr.setHvel(plr.getHvel() >> 2);
        } else if (plr.getOnsomething() != 0 && plr.getHvel() < 0 && plr.getZ() < goalz) {
            plr.setHvel(0);
            plr.setZ(goalz);
        }
        if (plr.getSector() != -1) {
            if (plr.getZ() - (plr.getHeight() >> 2) < Main.engine.getceilzofslope(plr.getSector(), plr.getX(), plr.getY())) {
                plr.setZ(Main.engine.getceilzofslope(plr.getSector(), plr.getX(), plr.getY()) + (plr.getHeight() >> 2));
                plr.setHvel(0);
            } else if (plr.getOrbactive()[5] > 0) {
                if (plr.getZ() + (plr.getHeight() << 7) > Main.engine.getflorzofslope(plr.getSector(), plr.getX(), plr.getY())) {
                    plr.setZ(Main.engine.getflorzofslope(plr.getSector(), plr.getX(), plr.getY()) - (plr.getHeight() << 7));
                    plr.setHvel(0);
                }
            } else if (plr.getZ() + (plr.getHeight() >> 4) > Main.engine.getflorzofslope(plr.getSector(), plr.getX(), plr.getY())) {
                plr.setZ(Main.engine.getflorzofslope(plr.getSector(), plr.getX(), plr.getY()) - (plr.getHeight() >> 4));
                plr.setHvel(0);
            }
        }
        plr.setJumphoriz(-(plr.getHvel() >> 8));
    }

    @Override
    public void sndHandlePause(boolean pause) {
        WHSND.sndHandlePause(pause);
    }

    public void newgame(Object item, int nLevel, int skills) {
        Main.gDemoScreen.onStopRecord();
        this.pNet.ready2send = false;
        this.game.nNetMode = BuildGame.NetMode.Single;
        WHPLR.mapon = nLevel;
        Globals.difficulty = skills;
        WHPLR.justteleported = false;
        Whmap.nextlevel = false;
        Main.UserFlag flag = Main.UserFlag.None;
        if (item instanceof EpisodeInfo) {
            EpisodeInfo game = (EpisodeInfo)item;
            if (!game.equals(Globals.gOriginalEpisode)) {
                if (!WHMenuUserContent.checkEpisodeResources(game)) {
                    return;
                }
                flag = Main.UserFlag.Addon;
                Console.out.println("Start user episode: " + game.Title);
            } else {
                WHMenuUserContent.resetEpisodeResources(game);
            }
            if (Globals.gCurrentEpisode != null && Globals.gCurrentEpisode.getMap(WHPLR.mapon) != null) {
                Globals.boardfilename = Main.game.cache.getEntry(Globals.gCurrentEpisode.getMap((int)WHPLR.mapon).path, true);
            }
        } else if (item instanceof FileEntry) {
            flag = Main.UserFlag.UserMap;
            Globals.boardfilename = (Entry)item;
            WHPLR.mapon = 0;
            WHMenuUserContent.resetEpisodeResources(null);
            Console.out.println("Start user map: " + ((FileEntry)item).getName());
        }
        Main.mUserFlag = flag;
        WHSND.sndStopMusic();
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            this.loadboard(Globals.boardfilename, null).setTitle("Loading " + Globals.boardfilename);
        } else if (Globals.gCurrentEpisode != null && Globals.boardfilename != null) {
            this.loadboard(Globals.boardfilename, null);
        } else {
            this.game.show();
        }
        this.game.menu.mClose();
    }
}

