/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven;

import com.badlogic.gdx.audio.Music;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.common.audio.AudioChannel;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Architecture.common.audio.SourceListener;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Types.Ambsounds;
import ru.m210projects.Witchaven.Types.HmiEntry;
import ru.m210projects.Witchaven.Types.Songtype;
import ru.m210projects.Witchaven.Types.Soundtype;
import ru.m210projects.Witchaven.Types.WHGroup;
import ru.m210projects.Witchaven.Types.WHSoundEntry;
import ru.m210projects.Witchaven.WH2MUS;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.Weapons;

public class WHSND {
    public static final int S_SPELL2 = 153;
    public static final int S_THROWPIKE = 154;
    public static final int S_AGM_PAIN1 = 130;
    public static final int S_AGM_DIE1 = 133;
    public static final int S_FIRESWING = 145;
    public static final int S_FIREWEAPONLOOP = 146;
    public static final int S_ENERGYWEAPONLOOP = 147;
    public static final int S_ENERGYSWING = 148;
    public static final int S_BIGGLASSBREAK1 = 149;
    public static final int S_IMPGROWL1 = 152;
    public static final int S_IMPDIE1 = 155;
    public static final int S_SWINGDOOR = 157;
    public static final int S_NUKESPELL = 158;
    public static final int S_DOORSPELL = 159;
    public static final int S_FIRESPELL = 160;
    public static final int S_GENERALMAGIC1 = 161;
    public static final int S_GENERALMAGIC2 = 162;
    public static final int S_GENERALMAGIC3 = 163;
    public static final int S_GENERALMAGIC4 = 164;
    public static final int MAX_ACTIVE_SAMPLES = 256;
    public static final int MAX_AMB_SOUNDS = 8;
    public static final int BASE_SONG = 0;
    public static final int TOTALSOUNDS = 164;
    public static final short songelements = 3;
    public static final short totallevels = 6;
    public static final short arrangements = 3;
    public static final int S_THUNDER1 = 0;
    public static int S_WINDLOOP1 = 4;
    public static int S_WAVELOOP1 = 5;
    public static int S_LAVALOOP1 = 6;
    public static int S_FIRELOOP1 = 7;
    public static int S_STONELOOP1 = 8;
    public static int S_BATSLOOP = 9;
    public static int S_PLRWEAPON0 = 10;
    public static int S_PLRWEAPON1 = 11;
    public static int S_PLRWEAPON2 = 12;
    public static int S_PLRWEAPON3 = 13;
    public static int S_PLRWEAPON4 = 14;
    public static final int S_GOBLIN1 = 15;
    public static final int S_GOBPAIN1 = 18;
    public static final int S_GOBDIE1 = 20;
    public static int S_KSNARL1 = 23;
    public static int S_KPAIN1 = 27;
    public static int S_KDIE1 = 29;
    public static int S_DEMON1 = 31;
    public static int S_DEMONDIE1 = 36;
    public static int S_MSNARL1 = 38;
    public static int S_MPAIN1 = 42;
    public static int S_MDEATH1 = 43;
    public static final int S_DRAGON1 = 44;
    public static int S_RIP1 = 47;
    public static int S_SKELHIT1 = 50;
    public static int S_SKELETONDIE = 52;
    public static int S_GUARDIAN1 = 53;
    public static int S_GUARDIANPAIN1 = 55;
    public static int S_GUARDIANDIE = 57;
    public static int S_WISP = 58;
    public static int S_WISP2 = 59;
    public static int S_SPLASH1 = 60;
    public static int S_WILLOWDIE = 66;
    public static final int S_FATWITCHDIE = 67;
    public static int S_JUDY1 = 68;
    public static int S_JUDYDIE = 72;
    public static final int S_SKULLWITCH1 = 73;
    public static final int S_SKULLWITCHDIE = 76;
    public static int S_GRONDEATHA = 77;
    public static int S_CHAIN1 = 80;
    public static int S_FLAME1 = 81;
    public static int S_GRONPAINA = 82;
    public static int S_CLUNK = 85;
    public static int S_DEMONTHROW = 86;
    public static final int S_WITCHTHROW = 87;
    public static int S_DOOR1 = 88;
    public static int S_DOOR2 = 89;
    public static int S_CREAKDOOR1 = 91;
    public static int S_CREAKDOOR2 = 92;
    public static int S_CREAKDOOR3 = 93;
    public static int S_STING1 = 94;
    public static int S_STING2 = 95;
    public static int S_POTION1 = 96;
    public static int S_GENTHROW = 97;
    public static int S_GENSWING = 98;
    public static int S_ARROWHIT = 99;
    public static int S_WALLHIT1 = 100;
    public static int S_SPELL1 = 102;
    public static int S_FREEZE = 103;
    public static int S_FREEZEDIE = 104;
    public static int S_RATS1 = 107;
    public static int S_WINDLOOP2 = 109;
    public static int S_BREATH1 = 110;
    public static int S_PUSH1 = 112;
    public static int S_PLRPAIN1 = 114;
    public static int S_GORE1 = 116;
    public static int S_GORE1A = 118;
    public static int S_DEADSTEP = 120;
    public static int S_HEARTBEAT = 121;
    public static int S_SOFTCHAINWALK = 122;
    public static int S_SOFTCREAKWALK = 123;
    public static int S_LOUDCHAINWALK = 124;
    public static int S_SCARYDUDE = 126;
    public static int S_WATERY = 127;
    public static int S_GLASSBREAK1 = 128;
    public static int S_TREASURE1 = 131;
    public static int S_SWORD1 = 132;
    public static int S_SWORD2 = 133;
    public static int S_SOCK1 = 138;
    public static int S_SOCK4 = 141;
    public static int S_KOBOLDHIT = 142;
    public static final int S_SPIDERBITE = 143;
    public static int S_FIREBALL = 144;
    public static final int S_WOOD1 = 145;
    public static final int S_CHAINDOOR1 = 146;
    public static int S_PULLCHAIN1 = 147;
    public static int S_PICKUPAXE = 148;
    public static int S_EXPLODE = 149;
    public static int S_SKELSEE = 150;
    public static int S_BARRELBREAK = 151;
    public static int S_WARP = 152;
    public static int S_PICKUPFLAG = 155;
    public static int S_DROPFLAG = 156;
    public static int S_DRINK = 158;
    public static int S_PAGE = 159;
    public static int S_BOTTLES = 160;
    public static int S_CRACKING = 161;
    public static int S_PLRDIE1 = 162;
    public static final int S_FATLAUGH = 163;
    public static int lavasnd = -1;
    public static int batsnd = -1;
    public static int cartsnd = -1;
    private static WHGroup fhsongs = null;
    public static Songtype songptr;
    public static int songsperlevel;
    private static WHGroup fhsounds;
    public static final ByteBuffer[] pSfx;
    public static BuildAudio audio;
    public static final Ambsounds[] ambsoundarray;
    public static final Soundtype[] SampleRay;
    public static int currTrack;
    public static Entry currSong;

    public static void sndInit() {
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        if (fhsongs == null) {
            WHSND.setupmidi();
        }
        if (fhsounds == null) {
            WHSND.setupdigi();
        }
        if (Main.game.WH2) {
            S_WINDLOOP1 = 3;
            S_WAVELOOP1 = 4;
            S_LAVALOOP1 = 5;
            S_FIRELOOP1 = 6;
            S_STONELOOP1 = 7;
            S_BATSLOOP = 8;
            S_PLRWEAPON0 = 9;
            S_PLRWEAPON1 = 10;
            S_PLRWEAPON2 = 11;
            S_PLRWEAPON3 = 12;
            S_PLRWEAPON4 = 13;
            S_KSNARL1 = 14;
            S_KPAIN1 = 18;
            S_KDIE1 = 20;
            S_DEMON1 = 22;
            S_DEMONDIE1 = 27;
            S_MSNARL1 = 29;
            S_MPAIN1 = 33;
            S_MDEATH1 = 34;
            S_RIP1 = 35;
            S_SKELHIT1 = 38;
            S_SKELETONDIE = 40;
            S_SKELSEE = 41;
            S_GUARDIAN1 = 42;
            S_GUARDIANPAIN1 = 44;
            S_GUARDIANDIE = 46;
            S_WISP = 47;
            S_WISP2 = 48;
            S_SPLASH1 = 49;
            S_WILLOWDIE = 54;
            S_JUDY1 = 55;
            S_JUDYDIE = 56;
            S_CHAIN1 = 57;
            S_FLAME1 = 58;
            S_CLUNK = 59;
            S_DEMONTHROW = 60;
            S_DOOR1 = 61;
            S_DOOR2 = 62;
            S_CREAKDOOR1 = 64;
            S_CREAKDOOR2 = 65;
            S_CREAKDOOR3 = 66;
            S_STING1 = 67;
            S_STING2 = 68;
            S_POTION1 = 69;
            S_GENTHROW = 70;
            S_GENSWING = 71;
            S_ARROWHIT = 72;
            S_WALLHIT1 = 73;
            S_SPELL1 = 75;
            S_FREEZE = 76;
            S_FREEZEDIE = 77;
            S_RATS1 = 80;
            S_WINDLOOP2 = 82;
            S_BREATH1 = 83;
            S_PUSH1 = 85;
            S_PLRPAIN1 = 87;
            S_GORE1 = 89;
            S_GORE1A = 91;
            S_DEADSTEP = 93;
            S_HEARTBEAT = 94;
            S_SOFTCHAINWALK = 95;
            S_SOFTCREAKWALK = 96;
            S_LOUDCHAINWALK = 97;
            S_SCARYDUDE = 98;
            S_WATERY = 99;
            S_GLASSBREAK1 = 100;
            S_TREASURE1 = 103;
            S_SWORD1 = 104;
            S_SWORD2 = 105;
            S_SOCK1 = 110;
            S_SOCK4 = 113;
            S_KOBOLDHIT = 114;
            S_FIREBALL = 115;
            S_PULLCHAIN1 = 116;
            S_PICKUPAXE = 117;
            S_EXPLODE = 118;
            S_BARRELBREAK = 119;
            S_WARP = 120;
            S_PICKUPFLAG = 121;
            S_DROPFLAG = 122;
            S_DRINK = 124;
            S_PAGE = 125;
            S_BOTTLES = 126;
            S_CRACKING = 127;
            S_PLRDIE1 = 128;
            S_GRONDEATHA = 136;
            S_GRONPAINA = 142;
        }
    }

    public static Entry getMusicEntry(int index) {
        if (fhsongs != null) {
            return fhsongs.getEntry(index);
        }
        return Directory.DUMMY_ENTRY;
    }

    public static Entry getSoundEntry(int index) {
        if (fhsounds != null) {
            return fhsounds.getEntry(index);
        }
        return Directory.DUMMY_ENTRY;
    }

    public static void sndStopMusic() {
        if (WHSND.songptr.handle != null) {
            WHSND.songptr.handle.stop();
        }
        currSong = Directory.DUMMY_ENTRY;
        currTrack = -1;
    }

    public static void setupmidi() {
        String songs = "SONGS";
        if (Main.game.WH2) {
            songs = "F_SONGS";
        }
        Entry songsEntry = Main.game.getCache().getEntry(songs, true);
        try {
            fhsongs = new WHGroup(songsEntry.getName(), songsEntry::getInputStream, HmiEntry.class);
        }
        catch (IOException e) {
            Console.out.println("setupmidi: cant open songs", OsdColor.RED);
        }
        songptr = new Songtype();
        songsperlevel = Main.game.WH2 ? 4 : 9;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (WHSND.songptr.handle != null) {
                WHSND.songptr.handle.pause();
            }
            audio.stopAllSounds();
        } else if (!Main.cfg.isMuteMusic() && WHSND.songptr.handle != null) {
            WHSND.songptr.handle.play();
        }
    }

    public static boolean sndPlayTrack(int nTrack) {
        String CD;
        if (Main.cfg.getMusicType() == 0 || Main.cfg.isMuteMusic()) {
            return false;
        }
        if (WHSND.songptr.handle != null && WHSND.songptr.handle.isPlaying() && currTrack == nTrack) {
            return true;
        }
        if (Main.game.currentDef != null && (CD = Main.game.currentDef.audInfo.getDigitalInfo(Integer.toString(nTrack))) != null && !CD.isEmpty() && (WHSND.songptr.handle = WHSND.newMusic(Main.game.cache.getEntry(CD, true))) != null) {
            WHSND.sndStopMusic();
            currTrack = nTrack;
            WHSND.songptr.handle.setLooping(true);
            WHSND.songptr.handle.play();
            return true;
        }
        return false;
    }

    public static void SND_MenuMusic() {
        if (Main.game.WH2) {
            WHSND.startmusic(16);
            return;
        }
        int which = 6 * songsperlevel + 0 + 2;
        WHSND.songptr.entry = WHSND.getMusicEntry(which);
        WHSND.playsong(7);
    }

    public static void startmusic(int level) {
        if (!Main.game.WH2) {
            int index = songsperlevel * (level %= 6) + 6 + 0;
            WHSND.songptr.entry = WHSND.getMusicEntry(index);
            WHSND.playsong(level);
        } else {
            if (level < 0 || level > 16) {
                level = 0;
            }
            WH2MUS.loadlevelsongs(level);
            WH2MUS.startsong(0);
        }
    }

    private static void playsong(int track) {
        if (Main.cfg.isMuteMusic()) {
            return;
        }
        if (WHSND.sndPlayTrack(track)) {
            return;
        }
        if (!WHSND.songptr.entry.exists()) {
            return;
        }
        if (currSong.equals(WHSND.songptr.entry)) {
            return;
        }
        WHSND.sndStopMusic();
        WHSND.songptr.handle = WHSND.newMusic(WHSND.songptr.entry);
        if (WHSND.songptr.handle != null) {
            currSong = WHSND.songptr.entry;
            WHSND.songptr.handle.setLooping(true);
            WHSND.songptr.handle.play();
        }
    }

    public static void setupdigi() {
        Entry soundsEntry = Main.game.getCache().getEntry("JOESND", true);
        try {
            fhsounds = new WHGroup(soundsEntry.getName(), soundsEntry::getInputStream, WHSoundEntry.class);
        }
        catch (IOException e) {
            Console.out.println("setupdigi: cant open sounds", OsdColor.RED);
        }
        for (int i = 0; i < 256; ++i) {
            WHSND.SampleRay[i] = new Soundtype();
            WHSND.SampleRay[i].sndnum = -1;
        }
    }

    public static void updatesounds() {
        if (Console.out.isShowing() || Main.cfg.isNoSound()) {
            return;
        }
        audio.setListener(WHPLR.player[WHPLR.pyrn].getX(), WHPLR.player[WHPLR.pyrn].getZ() >> 4, WHPLR.player[WHPLR.pyrn].getY(), (int)WHPLR.player[WHPLR.pyrn].getAng());
        for (int i = 0; i < 256; ++i) {
            if (WHSND.SampleRay[i].hVoice == null) continue;
            if (WHSND.SampleRay[i].loop > 0.0f) {
                WHSND.SampleRay[i].loop -= 0.008333334f;
                if (WHSND.SampleRay[i].loop <= 0.0f) {
                    WHSND.stopsound(i);
                    return;
                }
            }
            if (WHSND.SampleRay[i].x == 0 && WHSND.SampleRay[i].y == 0) continue;
            int sqrdist = Math.abs(WHPLR.player[WHPLR.pyrn].getX() - WHSND.SampleRay[i].x) + Math.abs(WHPLR.player[WHPLR.pyrn].getY() - WHSND.SampleRay[i].y);
            int wVol = 39000 - (sqrdist << 2);
            if (sqrdist < 1500) {
                wVol = Short.MAX_VALUE;
            } else if (sqrdist > 8500) {
                wVol = 7936;
            }
            wVol = Gameutils.BClipRange((int)((float)wVol / 32767.0f * 255.0f), 0, 255);
            WHSND.SampleRay[i].hVoice.setVolume((float)wVol / 255.0f);
        }
    }

    public static void SND_CheckLoops() {
        if (cartsnd != -1) {
            cartsnd = -1;
        }
        if (lavasnd != -1) {
            lavasnd = -1;
        }
        if (batsnd != -1) {
            batsnd = -1;
        }
        if (Weapons.enchantedsoundhandle != -1) {
            WHSND.SND_StopLoop(Weapons.enchantedsoundhandle);
        }
        for (int wIndex = 0; wIndex < 8; ++wIndex) {
            if (WHSND.ambsoundarray[wIndex].hsound == -1) continue;
            WHSND.ambsoundarray[wIndex].hsound = -1;
        }
        WHSND.stopallsounds();
    }

    public static void SND_StopLoop(int which) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        WHSND.stopsound(which);
    }

    public static void SND_Sound(int sn) {
        WHSND.playsound(sn, 0, 0, 0);
    }

    public static void playsound_loc(int sn, int x, int y) {
        WHSND.playsound(sn, x, y, 0);
    }

    public static int playsound(int sn, int x, int y, int loop) {
        if (Main.cfg.isNoSound()) {
            return -1;
        }
        if (sn >= 164) {
            Console.out.println("wrong sound: " + sn);
            return -1;
        }
        Entry entry = WHSND.getSoundEntry(sn);
        int prioritize = 0;
        if (entry instanceof WHSoundEntry) {
            prioritize = ((WHSoundEntry)entry).getPrioritize();
        }
        if (sn == S_STONELOOP1) {
            for (int wIndex = 0; wIndex < 256; ++wIndex) {
                if (sn != WHSND.SampleRay[wIndex].sndnum) continue;
                return -1;
            }
        }
        int sound = 0;
        block1: while (WHSND.SampleRay[sound].hVoice != null && WHSND.SampleRay[sound].hVoice.isActive()) {
            if (++sound != 256) continue;
            if (prioritize < 9) {
                return -1;
            }
            for (int wIndex = 0; wIndex < 256; ++wIndex) {
                if (WHSND.SampleRay[wIndex].priority >= 9 || WHSND.SampleRay[wIndex].loop == -1.0f) continue;
                WHSND.stopsound(wIndex);
                sound = wIndex;
                break block1;
            }
            return -1;
        }
        boolean globalVoice = false;
        int wVol = Short.MAX_VALUE;
        if (x != 0 && y != 0 && WHPLR.player[WHPLR.pyrn].getX() != x && WHPLR.player[WHPLR.pyrn].getY() != y) {
            int sqrdist = Pragmas.klabs(WHPLR.player[WHPLR.pyrn].getX() - x) + Pragmas.klabs(WHPLR.player[WHPLR.pyrn].getY() - y);
            wVol = sqrdist >= 1500 && sqrdist > 8500 ? 7936 : 39000 - (sqrdist << 2);
        } else {
            globalVoice = true;
        }
        if (pSfx[sn] == null) {
            if (!entry.exists()) {
                Console.out.println("playsound: bad read of digilist", OsdColor.RED);
            }
            ByteBuffer buf = ByteBuffer.allocateDirect((int)entry.getSize());
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.put(entry.getBytes());
            WHSND.pSfx[sn] = buf;
        }
        pSfx[sn].rewind();
        wVol = Gameutils.BClipRange((int)((float)wVol / 32767.0f * 255.0f), 1, 255);
        Source hVoice = loop != 0 ? WHSND.newSound(pSfx[sn], 11025, 8, 255) : WHSND.newSound(pSfx[sn], 11025, 8, 80 * (wVol + 1));
        if (hVoice != null) {
            if (!globalVoice) {
                hVoice.setPosition(x, 0, y);
            }
            if (loop != 0) {
                hVoice.loop((float)wVol / 255.0f);
            } else {
                hVoice.play((float)wVol / 255.0f);
            }
            WHSND.setSourceCallback(hVoice, SampleRay[sound]);
            WHSND.SampleRay[sound].hVoice = hVoice;
            WHSND.SampleRay[sound].loop = loop;
            WHSND.SampleRay[sound].sndnum = sn;
            WHSND.SampleRay[sound].priority = prioritize;
            WHSND.SampleRay[sound].x = x;
            WHSND.SampleRay[sound].y = y;
            return sound;
        }
        return -1;
    }

    private static void setSourceCallback(Source source, SourceListener listener) {
        source.setListener(listener);
    }

    public static void stopallsounds() {
        for (int i = 0; i < 256; ++i) {
            WHSND.stopsound(i);
        }
        audio.stopAllSounds();
    }

    public static void stopsound(int i) {
        if (i < 0 || i >= 164) {
            return;
        }
        WHSND.SampleRay[i].sndnum = -1;
        WHSND.SampleRay[i].priority = 0;
        WHSND.SampleRay[i].x = 0;
        WHSND.SampleRay[i].y = 0;
        if (WHSND.SampleRay[i].hVoice == null) {
            return;
        }
        Source hVoice = WHSND.SampleRay[i].hVoice;
        WHSND.SampleRay[i].hVoice = null;
        WHSND.SampleRay[i].loop = 0.0f;
        hVoice.stop();
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int channel, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, AudioChannel.parseChannel(channel), priority);
    }

    static Music newMusic(Entry entry) {
        return audio.newMusic(entry);
    }

    static {
        fhsounds = null;
        pSfx = new ByteBuffer[165];
        ambsoundarray = new Ambsounds[]{new Ambsounds(0), new Ambsounds(S_WINDLOOP1), new Ambsounds(S_WINDLOOP2), new Ambsounds(S_WAVELOOP1), new Ambsounds(S_LAVALOOP1), new Ambsounds(S_WATERY), new Ambsounds(S_STONELOOP1), new Ambsounds(S_BATSLOOP)};
        SampleRay = new Soundtype[256];
        currTrack = -1;
        currSong = Directory.DUMMY_ENTRY;
    }
}

