// duke3d_w32:
// Replaced icculus ASM extrapolated C functions with 
// those from JFDuke. (much cleaner code)

// A.ASM replacement using C
// Mainly by Ken Silverman, with things melded with my port by
// Jonathon Fowler (jonof@edgenetwork.org)
//
// "Build Engine & Tools" Copyright (c) 1993-1997 Ken Silverman
// Ken Silverman's official web site: "http://www.advsys.net/ken"
// See the included license file "BUILDLIC.TXT" for license info.

#include "a.h"
#include "build.h"

long krecip(long num);	// from engine.c

static unsigned char mach3_al;

#define BITSOFPRECISION 3
#define BITSOFPRECISIONPOW 8

extern long asm1, asm2, asm3, asm4, fpuasm, globalx3, globaly3;
//extern void *reciptable;
extern long reciptable[2048];

static long bpl, transmode = 0;
static long glogx, glogy, gbxinc, gbyinc, gpinc;
static char *gbuf, *gpal, *ghlinepal, *gtrans;

	//Global variable functions
static long fixchain;
void setvlinebpl(long dabpl) { bpl = fixchain = dabpl; }
void fixtransluscence(long datransoff) { gtrans = (char *)datransoff; }
void settransnormal(void) { transmode = 0; }
void settransreverse(void) { transmode = 1; }


	//Ceiling/floor horizontal line functions
void sethlinesizes(long logx, long logy, long bufplc)
	{ glogx = logx; glogy = logy; gbuf = (char *)bufplc; }
void setpalookupaddress(char *paladdr) { ghlinepal = paladdr; }
void setuphlineasm4(long bxinc, long byinc) { gbxinc = bxinc; gbyinc = byinc; }
void hlineasm4(long cnt, long skiploadincs, long paloffs, unsigned long by, unsigned long bx, long p)
{
	char *palptr;

	palptr = (char *)&ghlinepal[paloffs];
	if (!skiploadincs) { gbxinc = asm1; gbyinc = asm2; }
	for(;cnt>=0;cnt--)
	{
		*((char *)p) = palptr[gbuf[((bx>>(32-glogx))<<glogy)+(by>>(32-glogy))]];
		bx -= gbxinc;
		by -= gbyinc;
		p--;
	}
}


#if 0
	//Sloped ceiling/floor vertical line functions
void setupslopevlin(long logylogx, long bufplc, long pinc)
{
	glogx = (logylogx&255); 
	glogy = (logylogx>>8);
	gbuf = (char *)bufplc; 
	gpinc = pinc;
}
void slopevlin(long p, long i, long slopaloffs, long cnt, long bx, long by)
{
	long *slopalptr, bz, bzinc;
	unsigned long u, v;

	bz = asm3; 
	bzinc = (asm1>>3);
	slopalptr = (long *)slopaloffs;
	for(;cnt>0;cnt--)
	{
		i = krecip(bz>>6); 
		bz += bzinc;
		u = bx+globalx3*i;
		v = by+globaly3*i;
		(*(char *)p) = *(char *)(slopalptr[0]+gbuf[((u>>(32-glogx))<<glogy)+(v>>(32-glogy))]);
		slopalptr--;
		p += gpinc;
	}
}
#endif
/* #pragma aux setupslopevlin parm [eax][ebx][ecx] modify [edx] */
static long slopemach_ebx;
static long slopemach_ecx;
static long slopemach_edx;
static unsigned char slopemach_ah1;
static unsigned char slopemach_ah2;
static float asm2_f;
typedef union { unsigned int i; float f; } bitwisef2i;
void setupslopevlin(long i1, long i2, long i3)
{
	bitwisef2i c;
	slopemach_ebx = i2;
	slopemach_ecx = i3;
	slopemach_edx = (1<<(i1&0x1f)) - 1;
	slopemach_edx <<= ((i1&0x1f00)>>8);
	slopemach_ah1 = 32-((i1&0x1f00)>>8);
	slopemach_ah2 = (slopemach_ah1 - (i1&0x1f)) & 0x1f;
	c.f = asm2_f = (float)asm1;
	asm2 = c.i;
} /* setupslopevlin */

//extern long reciptable[2048];
extern long globalx3, globaly3;
extern long fpuasm;
#define low32(a) ((a&0xffffffff))
#define high32(a) ((int)(((__int64)a&(__int64)0xffffffff00000000)>>32))

/* #pragma aux slopevlin parm [eax][ebx][ecx][edx][esi][edi] */
void slopevlin(long i1, long i2, long i3, long i4, long i5, long i6)
{
	bitwisef2i c;
	unsigned long ecx,eax,ebx,edx,esi,edi;
	float a = (float) asm3 + asm2_f;
	i1 -= slopemach_ecx;
	esi = i5 + low32((__int64)globalx3 * (__int64)((unsigned long)i2<<3));
	edi = i6 + low32((__int64)globaly3 * (__int64)((unsigned long)i2<<3));
	ebx = i4;
	do {
		// -------------
		// All this is calculating a fixed point approx. of 1/a
		c.f = a;
		fpuasm = eax = c.i;
		edx = (((long)eax) < 0) ? 0xffffffff : 0;
		eax = eax << 1;
		ecx = (eax>>24);	//  exponent
		eax = ((eax&0xffe000)>>11);
		ecx = ((ecx&0xffffff00)|((ecx-2)&0xff));
		eax = reciptable[eax/4];
		eax >>= (ecx&0x1f);
		eax ^= edx;
		// -------------
		edx = (unsigned long)i2;
		i2 = eax;
		eax -= edx;
		ecx = low32((__int64)globalx3 * (__int64)eax);
		eax = low32((__int64)globaly3 * (__int64)eax);
		a += asm2_f;

		asm4 = ebx;
		ecx = ((ecx&0xffffff00)|(ebx&0xff));
		if (ebx >= 8) ecx = ((ecx&0xffffff00)|8);

		ebx = esi;
		edx = edi;
		while ((ecx&0xff))
		{
			ebx >>= slopemach_ah2;
			esi += ecx;
			edx >>= slopemach_ah1;
			ebx &= slopemach_edx;
			edi += eax;
			i1 += slopemach_ecx;
			edx = ((edx&0xffffff00)|((((unsigned char *)(ebx+edx))[slopemach_ebx])));
			ebx = *((unsigned long*)i3); // register trickery
			i3 -= 4;
			eax = ((eax&0xffffff00)|(*((unsigned char *)(ebx+edx))));
			ebx = esi;
			*((unsigned char *)i1) = (eax&0xff);
			edx = edi;
			ecx = ((ecx&0xffffff00)|((ecx-1)&0xff));
		}
		ebx = asm4;
		ebx -= 8;	// BITSOFPRECISIONPOW
	} while ((long)ebx > 0);
} /* slopevlin */

static unsigned char mach3_al;
long prevlineasm1(long i1, long i2, long i3, long i4, long i5, long i6)
{
	unsigned char *source = (unsigned char *)i5;
	unsigned char *dest = (unsigned char *)i6;
	if (i3 == 0)
	{
		i1 += i4;
		((unsigned long)i4) >>= mach3_al;
		i4 = (i4&0xffffff00) | (source[i4]&0xff);
		*dest = ((unsigned char*)i2)[i4];
		return i1;
	} else {
		return vlineasm1(i1,i2,i3,i4,i5,i6);
	}
} /* prevlineasm1 */

	//Wall,face sprite/wall sprite vertical line functions
void setupvlineasm(long neglogy) { glogy = mach3_al = neglogy;}
long vlineasm1(long vinc, long paloffs, long cnt, unsigned long vplc, long bufplc, long p)
{
	gbuf = (char *)bufplc;
	gpal = (char *)paloffs;
	for(;cnt>=0;cnt--)
	{
		*((char *)p) = gpal[gbuf[vplc>>glogy]];
		p += bpl;
		vplc += vinc;
	}

	return vplc;
}

void setupmvlineasm(long neglogy) { glogy = neglogy; }
long mvlineasm1(long vinc, long paloffs, long cnt, unsigned long vplc, long bufplc, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	gpal = (char *)paloffs;
	for(;cnt>=0;cnt--)
	{
		ch = gbuf[vplc>>glogy]; if (ch != 255) *((char *)p) = gpal[ch];
		p += bpl;
		vplc += vinc;
	}

	return vplc;
}

/* #pragma aux vlineasm4 parm [ecx][edi] modify [eax ebx ecx edx esi edi] */
extern long vplce[4], vince[4], palookupoffse[4], bufplce[4];
void vlineasm4(long i1, long i2)
{
	{
		int i;
		unsigned long temp;
		unsigned long index = (i2 + ylookup[i1]);
		unsigned char *dest = (unsigned char*)(-ylookup[i1]);
		do {
			for (i = 0; i < 4; i++)
			{
				temp = ((unsigned)vplce[i]) >> mach3_al;
				temp = (((unsigned char*)(bufplce[i]))[temp]);
				dest[index+i] = ((unsigned char*)(palookupoffse[i]))[temp];
				vplce[i] += vince[i];
			}
			dest += fixchain;
		} while (((unsigned)dest - fixchain) < ((unsigned)dest));
	}
} /* vlineasm4 */

void setuptvlineasm(long neglogy) { glogy = neglogy; }
long tvlineasm1(long vinc, long paloffs, long cnt, unsigned long vplc, long bufplc, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	gpal = (char *)paloffs;
	if (transmode)
	{
		for(;cnt>=0;cnt--)
		{
			ch = gbuf[vplc>>glogy];
			if (ch != 255) *((char *)p) = gtrans[(*((char *)p))+(gpal[ch]<<8)];
			p += bpl;
			vplc += vinc;
		}
	}
	else
	{
		for(;cnt>=0;cnt--)
		{
			ch = gbuf[vplc>>glogy];
			if (ch != 255) *((char *)p) = gtrans[((*((char *)p))<<8)+gpal[ch]];
			p += bpl;
			vplc += vinc;
		}
	}

	return vplc;
}

	//Floor sprite horizontal line functions
void msethlineshift(long logx, long logy) { glogx = logx; glogy = logy; }
void mhline(long bufplc, unsigned long bx, long cntup16, long junk, unsigned long by, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	gpal = (char *)asm3;
	for(cntup16>>=16;cntup16>0;cntup16--)
	{
		ch = gbuf[((bx>>(32-glogx))<<glogy)+(by>>(32-glogy))];
		if (ch != 255) *((char *)p) = gpal[ch];
		bx += asm1;
		by += asm2;
		p++;
	}
}

void tsethlineshift(long logx, long logy) { glogx = logx; glogy = logy; }
void thline(long bufplc, unsigned long bx, long cntup16, long junk, unsigned long by, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	gpal = (char *)asm3;
	if (transmode)
	{
		for(cntup16>>=16;cntup16>0;cntup16--)
		{
			ch = gbuf[((bx>>(32-glogx))<<glogy)+(by>>(32-glogy))];
			if (ch != 255) *((char *)p) = gtrans[(*((char *)p))+(gpal[ch]<<8)];
			bx += asm1;
			by += asm2;
			p++;
		}
	}
	else
	{
		for(cntup16>>=16;cntup16>0;cntup16--)
		{
			ch = gbuf[((bx>>(32-glogx))<<glogy)+(by>>(32-glogy))];
			if (ch != 255) *((char *)p) = gtrans[((*((char *)p))<<8)+gpal[ch]];
			bx += asm1;
			by += asm2;
			p++;
		}
	}
}


	//Rotatesprite vertical line functions
void setupspritevline(long paloffs, long bxinc, long byinc, long ysiz)
{
	gpal = (char *)paloffs;
	gbxinc = bxinc;
	gbyinc = byinc;
	glogy = ysiz;
}
void spritevline(long bx, long by, long cnt, long bufplc, long p)
{
	gbuf = (char *)bufplc;
	for(;cnt>1;cnt--)
	{
		(*(char *)p) = gpal[gbuf[(bx>>16)*glogy+(by>>16)]];
		bx += gbxinc;
		by += gbyinc;
		p += bpl;
	}
}

	//Rotatesprite vertical line functions
void msetupspritevline(long paloffs, long bxinc, long byinc, long ysiz)
{
	gpal = (char *)paloffs;
	gbxinc = bxinc;
	gbyinc = byinc;
	glogy = ysiz;
}
void mspritevline(long bx, long by, long cnt, long bufplc, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	for(;cnt>1;cnt--)
	{
		ch = gbuf[(bx>>16)*glogy+(by>>16)];
		if (ch != 255) (*(char *)p) = gpal[ch];
		bx += gbxinc;
		by += gbyinc;
		p += bpl;
	}
}

void tsetupspritevline(long paloffs, long bxinc, long byinc, long ysiz)
{
	gpal = (char *)paloffs;
	gbxinc = bxinc;
	gbyinc = byinc;
	glogy = ysiz;
}
void tspritevline(long bx, long by, long cnt, long bufplc, long p)
{
	char ch;

	gbuf = (char *)bufplc;
	if (transmode)
	{
		for(;cnt>1;cnt--)
		{
			ch = gbuf[(bx>>16)*glogy+(by>>16)];
			if (ch != 255) *((char *)p) = gtrans[(*((char *)p))+(gpal[ch]<<8)];
			bx += gbxinc;
			by += gbyinc;
			p += bpl;
		}
	}
	else
	{
		for(;cnt>1;cnt--)
		{
			ch = gbuf[(bx>>16)*glogy+(by>>16)];
			if (ch != 255) *((char *)p) = gtrans[((*((char *)p))<<8)+gpal[ch]];
			bx += gbxinc;
			by += gbyinc;
			p += bpl;
		}
	}
}

void setupdrawslab (long dabpl, long pal)
	{ bpl = dabpl; gpal = (char *)pal; }

void drawslab (long dx, long v, long dy, long vi, long vptr, long p)
{
	long x;
	
	while (dy > 0)
	{
		for(x=0;x<dx;x++) *(char *)(p+x) = gpal[(long)(*(char *)((v>>16)+vptr))];
		p += bpl; v += vi; dy--;
	}
}

void stretchhline (long p0, long u, long cnt, long uinc, long rptr, long p)
{
	p0 = p-(cnt<<2);
	do
	{
		p--;
		*(char *)p = *(char *)((u>>16)+rptr); u -= uinc;
	} while (p > p0);
}


void mmxoverlay() { }

/*
 * vim:ts=4:
 */

