/*
  Lame duke to Duke 3D map converter.
  By Mark Jaskolski (Mark_Jaskolski@Hotmail.com)

  Basically, this program converts the tile numbers
  used in Lameduke to their equivilent numbers in the
  Duke 3D tileset. Where no close match was available,
  I have simply picked a tile which I thought was
  close enough (Which doesn't always look as good).

  The program expects to find the original lameduke
  maps (Converted up to version 7 format) in the
  directory

  C:\LAMEDUKE\

  And all converted maps are placed into this
  directory here (Previous maps with the same name
  will be overwritten).

  C:\LAMECONV\

  You can change these directories if you want, but
  you will have to recompile the source.

  If you don't like the tile conversions I have used,
  you can change them. Just modify the entries in the
  huge switch statement towards the end of the file.
  The leftmost number is the LameDuke tile number, and
  the rightmost number (the one before the break) is
  the Duke3D tile to convert it to.

  Do what you want with this program, It's being
  released to the public domain as-is. Let's face it,
  you can't exactly make this program worse anyway.
*/

short tileconv(short oldtile);

//Directory that holds the original lameduke maps
static const char *inpath = "C:\\LAMEDUKE\\";

//Directory where the converted maps will be placed
static const char *outpath = "C:\\LAMECONV\\";

//Holds x/y coord of last bad tile
static long x;
static long y;

//Number of tiles processed
static long tilecount = 0;

//Number of tiles which weren't converted
static long badcount = 0;

//Names of the map files to convert
#define LEVELCOUNT 31
static const char *filename[] =
{
  "L1","L2","L3","L4","L5","L6","L7","L8","L9",
  "M1","M2","M3","M4","M5","M6","M7","M8",
  "N1","N2","N3","N4","N5","N6","N7","N8",
  "O1","O2","O3","O4",
  "WAR1","WAR2"
};

#include <malloc.h>;
#include <fcntl.h>;

void main()
{
  char *temp;
  char *tempptr;

  char buffer[256];
  char infile[256];
  char outfile[256];

  char level;

  char inhandle;
  char outhandle;

  long version;
  long readsize;
  long writesize;
  short itemcount;

  long l;

  temp = malloc(262144);

  for(level=0;level<LEVELCOUNT;level++)
  {

    strcpy(buffer,filename[level]);
    strcat(buffer,".MAP");
    printf("**** PROCESSING %s ****\n",buffer);

    strcpy(infile,inpath);
    strcat(infile,buffer);
    strcpy(outfile,outpath);
    strcat(outfile,buffer);

    inhandle = open(infile,O_RDONLY|O_BINARY);
    if(inhandle == -1)
    {
      printf("Unable to open infile %s!\n",infile);
      break;
    }

    outhandle = open(outfile,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY);
    if(outhandle == -1)
    {
      printf("Unable to open outfile %s!\n",outfile);
      close(inhandle);
      break;
    }

    x = -1;
    y = -1;

    readsize = read(inhandle,&version,4);
    if(readsize != 4 || version != 7)
    {
      printf("Mapfile %s is corrupt!\n",infile);
      close(inhandle);
      close(outhandle);
      break;
    }
    writesize = write(outhandle,&version,4);
    readsize = read(inhandle,temp,16);
    writesize = write(outhandle,temp,16);

    //Convert sector floor and ceilings.

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*40);
    tempptr = temp;
    printf("  Converting %d sectors.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      tempptr += 16;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Ceiling texture
      tempptr += 8;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Floor texture
      tempptr += 16;
    }
    writesize = write(outhandle,temp,itemcount*40);

    //Convert walls

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*32);
    tempptr = temp;
    printf("  Converting %d walls.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      x = *((long *) tempptr);
      tempptr+=4;
      y = *((long *) tempptr);
      tempptr+=12;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Wall tile
      tempptr+=2;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Mask tile
      tempptr+=14;
    }
    writesize = write(outhandle,temp,itemcount*32);

    //Convert sprites

    readsize = read(inhandle,&itemcount,2);
    writesize = write(outhandle,&itemcount,2);
    readsize = read(inhandle,temp,itemcount*44);
    tempptr = temp;
    printf("  Converting %d sprites.\n",itemcount);
    for(l=0;l<itemcount;l++)
    {
      x = *((long *) tempptr);
      tempptr+=4;
      y = *((long *) tempptr);
      tempptr+=10;
      *((short *) tempptr) = tileconv(*((short *) tempptr)); //Sprite tile
      tempptr+=30;
    }
    writesize = write(outhandle,temp,itemcount*44);

    close(inhandle);
    close(outhandle);
  }
  free(temp);

  printf("Processed %d tiles (%d tiles were not converted).\n\n",tilecount,badcount);
  printf("Done!\n");
}

short tileconv(short oldtile)
{
  short newtile;

  tilecount++;
  switch(oldtile)
  {
    case -1: newtile = 0; break; //CHECK!
    case 0: newtile = 13; break;
    case 1: newtile = 804; break;
    case 2: newtile = 15; break;
    case 3: newtile = 16; break;
    case 4: newtile = 17; break;
    case 5: newtile = 5; break;
    case 6: newtile = 18; break;
    case 7: newtile = 19; break;
    case 8: newtile = 34; break;
    case 9: newtile = 35; break;
    case 10: newtile = 36; break;
    case 11: newtile = 43; break;
    case 12: newtile = 3027; break;
    case 13: newtile = 740; break;
    case 14: newtile = 65; break;
    case 15: newtile = 66; break;
    case 16: newtile = 67; break;
    case 17: newtile = 68; break;
    case 18: newtile = 69; break;
    case 19: newtile = 71; break;
    case 20: newtile = 72; break;
    case 21: newtile = 73; break;
    case 22: newtile = 74; break;
    case 23: newtile = 4; break;
    case 24: newtile = 75; break;
    case 25: newtile = 76; break;
    case 26: newtile = 77; break;
    case 27: newtile = 116; break; //FIX
    case 28: newtile = 117; break;
    case 29: newtile = 118; break;
    case 30: newtile = 119; break;
    case 31: newtile = 2; break;
    case 32: newtile = 3; break;
    case 33: newtile = 129; break;
    case 34: newtile = 6; break;
    case 35: newtile = 172; break;
    case 36: newtile = 173; break;
    case 37: newtile = 174; break;
    case 38: newtile = 22; break;
    case 39: newtile = 175; break;
    case 40: newtile = 176; break;
    case 41: newtile = 177; break;
    case 42: newtile = 178; break;
    case 43: newtile = 179; break;
    case 44: newtile = 3488; break;
    case 45: newtile = 308; break;
    case 46: newtile = 1247; break;
    case 47: newtile = 1248; break;
    case 48: newtile = 2810; break; //nonexistent lameduke graphic. L9.map refers to it
    case 49: newtile = 336; break;
    case 50: newtile = 336; break;
    case 51: newtile = 8; break;
    case 52: newtile = 316; break;
    case 53: newtile = 339; break;
    case 54: newtile = 356; break;
    case 55: newtile = 741; break;
    case 56: newtile = 386; break;
    case 57: newtile = 1247; break;
    case 58: newtile = 3489; break;
    case 59: newtile = 440; break;
    case 60: newtile = 51; break; //cola
    case 68: newtile = 3490; break;
    case 69: newtile = 512; break;
    case 70: newtile = 616; break;
    case 71: newtile = 982; break;
    case 72: newtile = 1297; break;
    case 73: newtile = 1339; break;
    case 74: newtile = 1389; break;
    case 75: newtile = 1399; break;
    case 76: newtile = 1404; break;
    case 77: newtile = 1410; break;
    case 78: newtile = 1411; break;
    case 79: newtile = 1412; break;
    case 80: newtile = 1413; break;
    case 81: newtile = 1414; break;
    case 82: newtile = 1415; break;
    case 83: newtile = 1416; break;
    case 84: newtile = 1417; break;
    case 85: newtile = 1418; break;
    case 86: newtile = 1819; break;
    case 87: newtile = 3295; break;
    case 88: newtile = 3296; break;
    case 89: newtile = 3297; break;
    case 90: newtile = 3298; break;
    case 91: newtile = 353; break;
    case 92: newtile = 354; break;
    case 93: newtile = 3299; break;
    case 94: newtile = 3300; break;
    case 95: newtile = 980; break;
    case 96: newtile = 3301; break;
    case 97: newtile = 2940; break;
    case 98: newtile = 2941; break;
    case 99: newtile = 2942; break;
    case 100: newtile = 2943; break;
    case 101: newtile = 2944; break;
    case 102: newtile = 2945; break;
    case 103: newtile = 2946; break;
    case 104: newtile = 2947; break;
    case 105: newtile = 2948; break;
    case 106: newtile = 2949; break;
    case 107: newtile = 2950; break;
    case 108: newtile = 2951; break;
    case 109: newtile = 2952; break;
    case 110: newtile = 2953; break;
    case 111: newtile = 2954; break;
    case 112: newtile = 2955; break;
    case 113: newtile = 2956; break;
    case 114: newtile = 2957; break;
    case 115: newtile = 2958; break;
    case 116: newtile = 2959; break;
    case 117: newtile = 2960; break;
    case 118: newtile = 2961; break;
    case 119: newtile = 2962; break;
    case 120: newtile = 2963; break;
    case 121: newtile = 2964; break;
    case 122: newtile = 2965; break;
    case 123: newtile = 2966; break;
    case 124: newtile = 2967; break;
    case 125: newtile = 2968; break;
    case 126: newtile = 2969; break;
    case 127: newtile = 2970; break;
    case 128: newtile = 2971; break;
    case 129: newtile = 2972; break;
    case 130: newtile = 2973; break;
    case 131: newtile = 2974; break;
    case 132: newtile = 2975; break;
    case 133: newtile = 2976; break;
    case 134: newtile = 2977; break;
    case 135: newtile = 2978; break;
    case 136: newtile = 2979; break;
    case 137: newtile = 2980; break;
    case 138: newtile = 2981; break;
    case 139: newtile = 2982; break;
    case 140: newtile = 2983; break;
    case 141: newtile = 2984; break;
    case 142: newtile = 2985; break;
    case 143: newtile = 2986; break;
    case 144: newtile = 2987; break;
    case 145: newtile = 2988; break;
    case 146: newtile = 2989; break;
    case 147: newtile = 2990; break;
    case 148: newtile = 2991; break;
    case 149: newtile = 2930; break;
    case 150: newtile = 2931; break;
    case 151: newtile = 2932; break;
    case 152: newtile = 2933; break;
    case 153: newtile = 2934; break;
    case 154: newtile = 2935; break;
    case 155: newtile = 2936; break;
    case 156: newtile = 2937; break;
    case 157: newtile = 2938; break;
    case 158: newtile = 2939; break;
    case 159: newtile = 55; break; // Does this cokecan even exist in a lameduke map?
    case 167: newtile = 977; break;
    case 168: newtile = 3302; break;
    case 169: newtile = 3303; break;
    case 170: newtile = 3304; break;
    case 171: newtile = 3305; break;
    case 172: newtile = 3051; break;
    case 173: newtile = 2812; break;
    case 174: newtile = 3306; break;
    case 175: newtile = 1; break;
    case 176: newtile = 3307; break;
    case 177: newtile = 3308; break;
    case 178: newtile = 198; break;
    case 179: newtile = 503; break;
    case 180: newtile = 3309; break; //Monitor: might have to be changed
    case 181: newtile = 981; break;
    case 182: newtile = 981; break;
    case 183: newtile = 3311; break;
    case 184: newtile = 3312; break;
    case 185: newtile = 3313; break;
    case 186: newtile = 3314; break;
    case 187: newtile = 3315; break;
    case 188: newtile = 3316; break;
    case 189: newtile = 3317; break;
    case 190: newtile = 3318; break; //I don't know, what the lameduke graphics 191 - 194 are.
    case 195: newtile = 983; break;
    case 196: newtile = 984; break;
    case 197: newtile = 985; break;
    case 198: newtile = 986; break;
    case 199: newtile = 987; break;
    case 200: newtile = 1591; break;
    case 201: newtile = 1592; break;
    case 202: newtile = 1593; break;
    case 203: newtile = 1594; break;
    case 204: newtile = 1595; break;
    case 205: newtile = 1596; break;
    case 206: newtile = 816; break;
    case 207: newtile = 817; break;
    case 208: newtile = 818; break;
    case 209: newtile = 1600; break;
    case 210: newtile = 1601; break;
    case 211: newtile = 1602; break;
    case 212: newtile = 1603; break;
    case 213: newtile = 572; break;
    case 214: newtile = 1605; break;
    case 215: newtile = 661; break;
    case 216: newtile = 662; break;
    case 217: newtile = 1606; break; //Animation: 217 - 219; Starttile: 217 --> 1606 - 1608; Starttile 1606 (MarkJ used 407 for this)
    case 220: newtile = 1609; break;
    case 221: newtile = 821; break;
    case 222: newtile = 822; break;
    case 223: newtile = 1612; break;
    case 224: newtile = 1613; break;
    case 225: newtile = 1614; break;
    case 226: newtile = 1615; break;
    case 227: newtile = 1616; break;
    case 228: newtile = 1617; break;
    case 229: newtile = 1618; break;
    case 230: newtile = 1619; break;
    case 231: newtile = 1624; break;
    case 232: newtile = 1626; break;
    case 233: newtile = 3484; break; //alternative: 1088; break; //i have to check, how this works, maybe the graphic(s) of the lameduke reactor has to be used
    case 234: newtile = 1628; break;
    case 247: newtile = 1880; break; //the bird as drone? this might need further work
    case 262: newtile = 1629; break;
    case 263: newtile = 2370; break;
    case 265: newtile = 621; break;
    case 266: newtile = 621; break;
    case 267: newtile = 621; break;
    case 268: newtile = 621; break;
    case 269: newtile = 621; break;
    case 270: newtile = 2811; break; //nonexistent lameduke graphic, L9.map refers to it
    case 274: newtile = 1639; break;
    case 280: newtile = 1654; break;
    case 281: newtile = 1655; break;
    case 282: newtile = 3491; break;
    case 283: newtile = 1405; break;
    case 284: newtile = 1406; break;
    case 291: newtile = 3328; break;
    case 292: newtile = 3329; break;
    case 293: newtile = 3347; break;
    case 294: newtile = 3348; break;
    case 295: newtile = 3349; break;
    case 296: newtile = 3362; break;
    case 303: newtile = 7; break; //MarkJ used for this "0" (the number zero) His comment was: "SOME CONTROLLER 'C'"
    case 305: newtile = 634; break;
    case 309: newtile = 3363; break;
    case 310: newtile = 10; break;
    case 313: newtile = 2928; break;
    case 314: newtile = 3023; break;
    case 315: newtile = 3024; break;
    case 316: newtile = 3025; break;
    case 317: newtile = 3364; break;
    case 318: newtile = 3365; break;
    case 319: newtile = 3366; break;
    case 320: newtile = 3367; break;
    case 321: newtile = 3054; break;
    case 322: newtile = 3055; break;
    case 323: newtile = 3460; break;
    case 327: newtile = 3464; break;
    case 331: newtile = 503; break; //It's Glass. Originally the window with the word COCA COLA and LOTTO
    case 332: newtile = 3369; break;
    case 333: newtile = 3388; break;
    case 334: newtile = 3468; break;
    case 338: newtile = 3472; break;
    case 342: newtile = 3476; break;
    case 343: newtile = 3477; break;
    case 344: newtile = 1819; break;
    case 345: newtile = 3028; break;
    case 347: newtile = 3029; break;
    case 349: newtile = 3030; break;
    case 350: newtile = 3031; break;
    case 351: newtile = 3032; break;
    case 352: newtile = 3033; break;
    case 353: newtile = 3493; break;
    case 354: newtile = 3034; break;
    case 355: newtile = 3035; break;
    case 356: newtile = 3036; break;
    case 357: newtile = 3320; break;
    case 358: newtile = 3321; break;
    case 359: newtile = 3322; break;
    case 360: newtile = 3323; break;
    case 361: newtile = 3324; break;
    case 362: newtile = 3325; break;
    case 363: newtile = 3326; break;
    case 364: newtile = 3327; break;
    case 365: newtile = 3494; break;
    case 366: newtile = 1861; break;
    case 367: newtile = 1862; break;
    case 368: newtile = 1863; break;
    case 369: newtile = 1864; break;
    case 370: newtile = 1865; break;
    case 371: newtile = 1866; break;
    case 372: newtile = 835; break;
    case 373: newtile = 836; break;
    case 374: newtile = 1867; break; // MarkJ used 843 for this. Might be better ?
    case 375: newtile = 837; break;
    case 376: newtile = 1868; break;
    case 377: newtile = 1869; break;
    case 378: newtile = 1877; break;
    case 379: newtile = 1878; break;
    case 380: newtile = 1879; break;
    case 381: newtile = 2916; break; //parking meter, front
    case 382: newtile = 2917; break; //parking meter, side
    case 383: newtile = 1887; break;
    case 384: newtile = 1888; break;
    case 385: newtile = 1889; break;
    case 386: newtile = 1911; break;
    case 387: newtile = 1912; break;
    case 388: newtile = 1913; break;
    case 395: newtile = 132; break; // switch: slotdoor (does the function depend on the tilenumber? If not, it should be possible to use the original lameduke switch gfx in another slot
    case 396: newtile = 133; break; // switch: see line above
    case 397: newtile = 1914; break;
    case 398: newtile = 3037; break;
    case 399: newtile = 3038; break;
    case 400: newtile = 3039; break;
    case 401: newtile = 3040; break;
    case 402: newtile = 3495; break;
    case 403: newtile = 3041; break;
    case 404: newtile = 3042; break;
    case 405: newtile = 134; break; // switch
    case 406: newtile = 135; break; // switch
    case 407: newtile = 3043; break;
    case 408: newtile = 2000; break; // changes fempunk into pigcop
    case 457: newtile = 2001; break; // ???
    case 477: newtile = 3044; break;
    case 478: newtile = 3045; break;
    case 479: newtile = 3046; break;
    case 480: newtile = 3047; break;
    case 483: newtile = 3496; break;
    case 484: newtile = 3048; break;
    case 485: newtile = 3049; break;
    case 486: newtile = 3050; break;
    case 487: newtile = 1974; break;
    case 488: newtile = 3056; break; // 1226; break; //PAL=2
    case 489: newtile = 3057; break;
    case 490: newtile = 1920; break; // commander
    case 570: newtile = 560; break; // mirror // what's 571?
    case 572: newtile = 562; break; //FIX //???
    case 573: newtile = 198; break; //??? glas??? MarkJ wrote here: 198; break; //FIX // I (Funduke) tried it with: 504; break; . but it didn't work
    case 574: newtile = 504; break; //???
    case 579: newtile = 1880; break; // drone
    case 593: newtile = 3058; break;
    case 594: newtile = 3059; break;
    case 595: newtile = 3060; break;
    case 596: newtile = 1994; break;
    case 597: newtile = 1995; break;
    case 598: newtile = 1996; break;
    case 600: newtile = 1997; break;
    case 601: newtile = 3497; break;
    case 602: newtile = 1998; break;
    case 603: newtile = 1999; break;
    case 604: newtile = 2020; break;
    case 605: newtile = 2021; break;
    case 606: newtile = 569; break;
    case 607: newtile = 570; break;
    case 608: newtile = 2022; break;
    case 609: newtile = 572; break;
    case 610: newtile = 2023; break;
    case 611: newtile = 2024; break;
    case 612: newtile = 3061; break;
    case 620: newtile = 3478; break; //maybe better: 1088; break; // reactor
    case 626: newtile = 3062; break;
    case 627: newtile = 1238; break;
    case 628: newtile = 1034; break;
    case 631: newtile = 1321; break;
    case 633: newtile = 955; break;
    case 634: newtile = 1015; break;
    case 635: newtile = 3063; break;
    case 636: newtile = 3064; break;
    case 637: newtile = 3065; break;
    case 638: newtile = 3066; break;
    case 639: newtile = 2062; break;
    case 659: newtile = 2063; break;
    case 660: newtile = 2064; break; // MarkJ wrote: 128; break; //PURPLE
    case 661: newtile = 2065; break; // MarkJ wrote: 128; break; //BLUE
    case 662: newtile = 2080; break; // MarkJ wrote: 128; break; //GREEN
    case 663: newtile = 2081; break; // MarkJ wrote: 128; break; //BLUE
    case 664: newtile = 2082; break;
    case 665: newtile = 2083; break;
    case 670: newtile = 2084; break;
    case 671: newtile = 2085; break;
    case 672: newtile = 2086; break;
    case 677: newtile = 621; break; //camera
    case 680: newtile = 11; break; // "V" = flying camera? just a guess!
    case 686: newtile = 2329; break;
    case 687: newtile = 2330; break;
    case 688: newtile = 2331; break;
    case 689: newtile = 2332; break;
    case 690: newtile = 2333; break; // RotT-flame
    case 713: newtile = 57; break; //jetpack
    case 716: newtile = 52; break;
    case 717: newtile = 55; break; //steroids
    case 718: newtile = 1348; break;
    case 719: newtile = 661; break;
    case 720: newtile = 1348; break; //MarkJ wrote: 100; break; (100 refers to atomic health)
    case 721: newtile = 26; break; //pipebomb
    case 722: newtile = 52; break;
    case 723: newtile = 40; break;
    case 724: newtile = 55; break;
    case 726: newtile = 661; break; //MarkJ wrote: 54; break; (54 refers to the armor)
    case 727: newtile = 53; break;
    case 728: newtile = 57; break;
    case 730: newtile = 2087; break;
    case 731: newtile = 2088; break;
    case 732: newtile = 2089; break;
    case 733: newtile = 2090; break;
    case 734: newtile = 2091; break;
    case 735: newtile = 2092; break;
    case 736: newtile = 2093; break;
    case 737: newtile = 2094; break;
    case 740: newtile = 2097; break;
    case 741: newtile = 2098; break;
    case 742: newtile = 2099; break;
    case 743: newtile = 2100; break;
    case 744: newtile = 2101; break;
    case 745: newtile = 2102; break;
    case 746: newtile = 2103; break;
    case 747: newtile = 2104; break;
    case 748: newtile = 2105; break;
    case 749: newtile = 2106; break;
    case 750: newtile = 2107; break;
    case 751: newtile = 2108; break;
    case 752: newtile = 2109; break;
    case 753: newtile = 2110; break;
    case 754: newtile = 2111; break;
    case 755: newtile = 2112; break;
    case 756: newtile = 2113; break;
    case 757: newtile = 2114; break;
    case 758: newtile = 2115; break;
    case 759: newtile = 2116; break;
    case 760: newtile = 2117; break;
    case 761: newtile = 3067; break;
    case 762: newtile = 3068; break;
    case 763: newtile = 3069; break;
    case 764: newtile = 2118; break;
    case 765: newtile = 2119; break;
    case 766: newtile = 3070; break;
    case 767: newtile = 3071; break;
    case 768: newtile = 3217; break;
    case 769: newtile = 3218; break;
    case 770: newtile = 3219; break;
    case 771: newtile = 3220; break;
    case 772: newtile = 3221; break;
    case 773: newtile = 3222; break;
    case 774: newtile = 3223; break;
    case 775: newtile = 3224; break;
    case 776: newtile = 3225; break;
    case 777: newtile = 3226; break;
    case 778: newtile = 3227; break;
    case 779: newtile = 2186; break;
    case 780: newtile = 2187; break;
    case 781: newtile = 2188; break;
    case 782: newtile = 2189; break;
    case 783: newtile = 3228; break;
    case 784: newtile = 3229; break;
    case 785: newtile = 2213; break;
    case 786: newtile = 2214; break;
    case 787: newtile = 2215; break;
    case 788: newtile = 2216; break; //MarkJ wrote: 1007; break;
    case 789: newtile = 1008; break;
    case 790: newtile = 3485; break;
    case 791: newtile = 3486; break;
    case 792: newtile = 3487; break;
    case 793: newtile = 1009; break;
    case 796: newtile = 2240; break;
    case 797: newtile = 2241; break;
    case 798: newtile = 3498; break;
    case 799: newtile = 2243; break;
    case 800: newtile = 2244; break;
    case 801: newtile = 279; break;
    case 802: newtile = 280; break;
    case 803: newtile = 281; break;
    case 804: newtile = 282; break;
    case 805: newtile = 283; break;
    case 806: newtile = 284; break;
    case 807: newtile = 2367; break;
    case 808: newtile = 2328; break;
    case 809: newtile = 2349; break;
    case 810: newtile = 2365; break;
    case 811: newtile = 288; break;
    case 812: newtile = 289; break;
    case 813: newtile = 290; break;
    case 814: newtile = 291; break;
    case 815: newtile = 292; break;
    case 816: newtile = 2366; break;
    case 817: newtile = 2368; break;
    case 818: newtile = 2369; break;
    case 819: newtile = 2430; break; //why does the animation not work? is the graphic too large?
    case 820: newtile = 2431; break;
    case 821: newtile = 2432; break;
    case 822: newtile = 2433; break;
    case 823: newtile = 2434; break;
    case 824: newtile = 2435; break;
    case 825: newtile = 2436; break;
    case 826: newtile = 2437; break;
    case 827: newtile = 1022; break;
    case 828: newtile = 1023; break;
    case 829: newtile = 3499; break;
    case 830: newtile = 2378; break;
    case 831: newtile = 1024; break;
    case 832: newtile = 2379; break;
    case 833: newtile = 312; break;
    case 834: newtile = 313; break;
    case 835: newtile = 314; break;
    case 836: newtile = 315; break;
    case 837: newtile = 2918; break;
    case 838: newtile = 1025; break;
    case 839: newtile = 2919; break;
    case 840: newtile = 3492; break;
    case 841: newtile = 318; break;
    case 842: newtile = 2438; break;
    case 843: newtile = 2439; break;
    case 844: newtile = 3500; break;
    case 845: newtile = 3501; break;
    case 846: newtile = 2459; break;
    case 847: newtile = 3502; break;
    case 848: newtile = 3503; break;
    case 849: newtile = 3504; break;
    case 850: newtile = 322; break;
    case 851: newtile = 323; break;
    case 852: newtile = 324; break;
    case 853: newtile = 1098; break;
    case 854: newtile = 3505; break;
    case 855: newtile = 2507; break;
    case 856: newtile = 3506; break;
    case 857: newtile = 3507; break;
    case 858: newtile = 2508; break;
    case 859: newtile = 2509; break;
    case 860: newtile = 2512; break;
    case 861: newtile = 2513; break;
    case 862: newtile = 2514; break;
    case 863: newtile = 2515; break;
    case 864: newtile = 2516; break;
    case 865: newtile = 2517; break;
    case 866: newtile = 2518; break;
    case 867: newtile = 2519; break;
    case 868: newtile = 2520; break;
    case 869: newtile = 1021; break;
    case 887: newtile = 3319; break;
    case 888: newtile = 2569; break;
    case 889: newtile = 3508; break;
    case 890: newtile = 3509; break;
    case 891: newtile = 2579; break;
    case 892: newtile = 2580; break;
    case 893: newtile = 2582; break;
    case 894: newtile = 2583; break;
    case 895: newtile = 3510; break;
    case 896: newtile = 2585; break;
    case 897: newtile = 331; break;
    case 898: newtile = 332; break;
    case 899: newtile = 2587; break;
    case 900: newtile = 2588; break;
    case 901: newtile = 2592; break;
    case 905: newtile = 904; break;
    case 908: newtile = 2593; break;
    case 909: newtile = 2594; break;
    case 910: newtile = 0; break; //NO TILE, CHECK THIS!
    case 921: newtile = 0; break; //NO TILE, CHECK THIS!
    case 925: newtile = 1880; break;
    case 930: newtile = 2360; break; //rotategun
    case 931: newtile = 2360; break;
    case 940: newtile = 940; break; //BOUNCEMINE
    case 957: newtile = 2599; break;
    case 958: newtile = 2600; break;
    case 959: newtile = 2601; break;
    case 960: newtile = 660; break; //waterdrop
    case 961: newtile = 2370; break; //greenslime
    case 970: newtile = 1275; break;
    case 971: newtile = 1276; break;
    case 972: newtile = 1277; break;
    case 973: newtile = 1278; break;
    case 974: newtile = 1026; break; //horseonside
    case 980: newtile = 2602; break;
    case 981: newtile = 2603; break;
    case 982: newtile = 2604; break; //glass??
    case 983: newtile = 2620; break;
    case 984: newtile = 2621; break;
    case 985: newtile = 2622; break;
    case 986: newtile = 2623; break;
    case 987: newtile = 2624; break; //MarkJ wrote: 3411; break;
    case 988: newtile = 2625; break; //Markj wrote: 3411; break;
    case 990: newtile = 2626; break;
    case 991: newtile = 2627; break;
    case 992: newtile = 2628; break;
    case 993: newtile = 2629; break;
    case 994: newtile = 3230; break;
    case 995: newtile = 3231; break;
    case 996: newtile = 3232; break;
    case 997: newtile = 3233; break;
    case 998: newtile = 3234; break;
    case 999: newtile = 3235; break;
    case 1000: newtile = 3236; break;
    case 1001: newtile = 3237; break;
    case 1002: newtile = 3238; break;
    case 1003: newtile = 3239; break;
    case 1004: newtile = 3252; break;
    case 1005: newtile = 3253; break;
    case 1006: newtile = 3254; break;
    case 1007: newtile = 3255; break;
    case 1008: newtile = 3256; break;
    case 1009: newtile = 3257; break;
    case 1010: newtile = 3511; break; // palette problem: alternative: 767; break;
    case 1011: newtile = 3258; break;
    case 1012: newtile = 3259; break;
    case 1013: newtile = 2687; break;
    case 1014: newtile = 2688; break;
    case 1015: newtile = 2689; break;
    case 1016: newtile = 2690; break;
    case 1017: newtile = 2691; break;
    case 1018: newtile = 2692; break;
    case 1019: newtile = 2693; break;
    case 1020: newtile = 2694; break;
    case 1021: newtile = 2695; break;
    case 1022: newtile = 2696; break;
    case 1023: newtile = 2697; break;
    case 1119: newtile = 44; break;
    case 1120: newtile = 41; break;
    case 1121: newtile = 23; break;
    case 1122: newtile = 2698; break;
    case 1123: newtile = 2699;break; //MarkJ wrote: 160; break;
    case 1124: newtile = 25; break; //FIX
    case 1125: newtile = 21; break;
    case 1130: newtile = 41; break;
    case 1131: newtile = 41; break;
    case 1136: newtile = 2700; break;
    case 1174: newtile = 1221; break;
    case 1175: newtile = 1222; break;
    case 1180: newtile = 2701; break;
    case 1181: newtile = 2702; break;
    case 1182: newtile = 2703; break;
    case 1183: newtile = 2704; break;
    case 1184: newtile = 663; break;
    case 1190: newtile = 2708; break;
    case 1200: newtile = 1232; break;
    case 1210: newtile = 2923; break; //this might need some con-hacking
    case 1211: newtile = 2924; break;
    case 1212: newtile = 2925; break;
    case 1213: newtile = 2926; break;
    case 1214: newtile = 2927; break;
    case 1220: newtile = 3274; break; // left at lame palette //MarkJ wrote: 701; break;
    case 1221: newtile = 3275; break; // left at lame palette //MarkJ wrote: 702; break;
    case 1222: newtile = 929; break;
    case 1223: newtile = 930; break;
    case 1224: newtile = 931; break;
    case 1225: newtile = 932; break;
    case 1226: newtile = 933; break;
    case 1227: newtile = 934; break;
    case 1228: newtile = 3276; break;
    case 1229: newtile = 936; break;
    case 1260: newtile = 3277; break;
    case 1261: newtile = 3278; break;
    case 1262: newtile = 3279; break;
    case 1263: newtile = 3282; break;
    case 1264: newtile = 3283; break;
    case 1265: newtile = 3284; break;
    case 1266: newtile = 3285; break;
    case 1280: newtile = 1550; break;
    case 1320: newtile = 640; break;
    case 1321: newtile = 641; break;
    case 1322: newtile = 642; break;
    case 1323: newtile = 643; break;
    case 1324: newtile = 644; break;
    case 1325: newtile = 645; break;
    case 1326: newtile = 646; break;
    case 1327: newtile = 647; break;
    case 1328: newtile = 648; break;
    case 1329: newtile = 649; break;
    case 1330: newtile = 650; break;
    case 1331: newtile = 651; break;
    case 1332: newtile = 652; break;
    case 1333: newtile = 653; break;
    case 1334: newtile = 654; break;
    case 1335: newtile = 655; break;
    case 1336: newtile = 656; break;
    case 1337: newtile = 657; break;
    case 1338: newtile = 658; break;
    case 1339: newtile = 659; break;
    case 1340: newtile = 3286; break;
    case 1341: newtile = 3287; break;
    case 1342: newtile = 3288; break;
    case 1398: newtile = 3289; break;
    case 1399: newtile = 3294; break;
    case 1400: newtile = 3052; break;
    case 1401: newtile = 3053; break;
    case 1402: newtile = 26; break;
    case 1408: newtile = 502; break; //security viewscreen. I would like to change this to the original lameduke-viewscreen
    case 1536: newtile = 1680; break; //trooper
    case 1680: newtile = 2120; break; //lizman
    case 1820: newtile = 1820; break; //octabrain
    default:
    {
      if(x==-1|y==-1)
      {
        printf("TILE %d NOT RECOGNIZED!\n",oldtile);
      }
      else
      {
        printf("TILE %d NOT RECOGNIZED! [%d,%d]\n",oldtile,x,y);
      }
      newtile = oldtile;
      badcount++;
      break;
    }
  }

  return newtile;
}